/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;

public class ByteToCharUnicode
extends ByteToCharConverter {
    static final char BYTE_ORDER_MARK = '\ufeff';
    static final char REVERSED_MARK = '\ufffe';
    static final int AUTO = 0;
    static final int BIG = 1;
    static final int LITTLE = 2;
    int originalByteOrder;
    int byteOrder;
    boolean usesMark;
    boolean started = false;
    int leftOverByte;
    boolean leftOver = false;

    public ByteToCharUnicode() {
        this.byteOrder = 0;
        this.originalByteOrder = 0;
        this.usesMark = true;
    }

    protected ByteToCharUnicode(int bo, boolean m) {
        this.originalByteOrder = this.byteOrder = bo;
        this.usesMark = m;
    }

    @Override
    public String getCharacterEncoding() {
        switch (this.originalByteOrder) {
            case 1: {
                return this.usesMark ? "UnicodeBig" : "UnicodeBigUnmarked";
            }
            case 2: {
                return this.usesMark ? "UnicodeLittle" : "UnicodeLittleUnmarked";
            }
        }
        return "Unicode";
    }

    @Override
    public int convert(byte[] in, int inOff, int inEnd, char[] out, int outOff, int outEnd) throws ConversionBufferFullException, MalformedInputException {
        char c;
        int b2;
        int b1;
        this.byteOff = inOff;
        this.charOff = outOff;
        if (inOff >= inEnd) {
            return 0;
        }
        int bc = 0;
        int inI = inOff;
        int outI = outOff;
        if (this.leftOver) {
            b1 = this.leftOverByte & 0xFF;
            this.leftOver = false;
        } else {
            b1 = in[inI++] & 0xFF;
        }
        bc = 1;
        if (this.usesMark && !this.started && inI < inEnd) {
            b2 = in[inI++] & 0xFF;
            bc = 2;
            c = (char)(b1 << 8 | b2);
            int bo = 0;
            if (c == '\ufeff') {
                bo = 1;
            } else if (c == '\ufffe') {
                bo = 2;
            }
            if (this.byteOrder == 0) {
                if (bo == 0) {
                    this.badInputLength = bc;
                    throw new MalformedInputException("Missing byte-order mark");
                }
                this.byteOrder = bo;
                if (inI < inEnd) {
                    b1 = in[inI++] & 0xFF;
                    bc = 1;
                }
            } else if (bo == 0) {
                --inI;
                bc = 1;
            } else if (this.byteOrder == bo) {
                if (inI < inEnd) {
                    b1 = in[inI++] & 0xFF;
                    bc = 1;
                }
            } else {
                this.badInputLength = bc;
                throw new MalformedInputException("Incorrect byte-order mark");
            }
            this.started = true;
        }
        while (inI < inEnd) {
            b2 = in[inI++] & 0xFF;
            bc = 2;
            c = this.byteOrder == 1 ? (char)(b1 << 8 | b2) : (char)(b2 << 8 | b1);
            if (c == '\ufffe') {
                throw new MalformedInputException("Reversed byte-order mark");
            }
            if (outI >= outEnd) {
                throw new ConversionBufferFullException();
            }
            out[outI++] = c;
            this.byteOff = inI;
            this.charOff = outI;
            if (inI >= inEnd) continue;
            b1 = in[inI++] & 0xFF;
            bc = 1;
        }
        if (bc == 1) {
            this.leftOverByte = b1;
            this.byteOff = inI;
            this.leftOver = true;
        }
        return outI - outOff;
    }

    @Override
    public void reset() {
        this.leftOver = false;
        this.charOff = 0;
        this.byteOff = 0;
        this.started = false;
        this.byteOrder = this.originalByteOrder;
    }

    @Override
    public int flush(char[] buf, int off, int len) throws MalformedInputException {
        if (this.leftOver) {
            this.reset();
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }
}

