/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.DocIdSetBuilder;

public abstract class AbstractPrefixTreeQuery
extends Query {
    protected final Shape queryShape;
    protected final String fieldName;
    protected final SpatialPrefixTree grid;
    protected final int detailLevel;

    public AbstractPrefixTreeQuery(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel) {
        this.queryShape = queryShape;
        this.fieldName = fieldName;
        this.grid = grid;
        this.detailLevel = detailLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractPrefixTreeQuery that = (AbstractPrefixTreeQuery)((Object)o);
        if (this.detailLevel != that.detailLevel) {
            return false;
        }
        if (!this.fieldName.equals(that.fieldName)) {
            return false;
        }
        return this.queryShape.equals((Object)that.queryShape);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.queryShape.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        result = 31 * result + this.detailLevel;
        return result;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSet docSet = AbstractPrefixTreeQuery.this.getDocIdSet(context);
                if (docSet == null) {
                    return null;
                }
                DocIdSetIterator disi = docSet.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }
        };
    }

    protected abstract DocIdSet getDocIdSet(LeafReaderContext var1) throws IOException;

    public abstract class BaseTermsEnumTraverser {
        protected final LeafReaderContext context;
        protected final int maxDoc;
        protected TermsEnum termsEnum;
        protected PostingsEnum postingsEnum;

        public BaseTermsEnumTraverser(LeafReaderContext context) throws IOException {
            this.context = context;
            LeafReader reader = context.reader();
            this.maxDoc = reader.maxDoc();
            Terms terms = reader.terms(AbstractPrefixTreeQuery.this.fieldName);
            if (terms != null) {
                this.termsEnum = terms.iterator();
            }
        }

        protected void collectDocs(BitSet bitSet) throws IOException {
            assert (this.termsEnum != null);
            this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
            bitSet.or((DocIdSetIterator)this.postingsEnum);
        }

        protected void collectDocs(DocIdSetBuilder docSetBuilder) throws IOException {
            assert (this.termsEnum != null);
            this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
            docSetBuilder.add((DocIdSetIterator)this.postingsEnum);
        }
    }
}

