/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.binding;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.binding.BindingLayout;

@GeneratedBy(value=BindingLayout.class)
public class BindingLayoutImpl
extends BasicObjectLayoutImpl
implements BindingLayout {
    public static final BindingLayout INSTANCE = new BindingLayoutImpl();
    protected static final Shape.Allocator BINDING_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey FRAME_IDENTIFIER = new HiddenKey("frame");
    protected static final Property FRAME_PROPERTY = Property.create(FRAME_IDENTIFIER, BINDING_ALLOCATOR.locationForType(MaterializedFrame.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);

    protected BindingLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createBindingShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new BindingType(logicalClass, metaClass)).addProperty(FRAME_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createBinding(DynamicObjectFactory factory, MaterializedFrame frame) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (BindingLayoutImpl.createsBinding(factory));
        assert (factory.getShape().hasProperty(FRAME_IDENTIFIER));
        assert (frame != null);
        return factory.newInstance(frame);
    }

    @Override
    public boolean isBinding(DynamicObject object) {
        return BindingLayoutImpl.isBinding(object.getShape().getObjectType());
    }

    private static boolean isBinding(ObjectType objectType) {
        return objectType instanceof BindingType;
    }

    private static boolean createsBinding(DynamicObjectFactory factory) {
        return BindingLayoutImpl.isBinding(factory.getShape().getObjectType());
    }

    @Override
    public MaterializedFrame getFrame(DynamicObject object) {
        assert (this.isBinding(object));
        assert (object.getShape().hasProperty(FRAME_IDENTIFIER));
        return (MaterializedFrame)FRAME_PROPERTY.get(object, this.isBinding(object));
    }

    public static class BindingType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public BindingType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public BindingType setLogicalClass(DynamicObject logicalClass) {
            return new BindingType(logicalClass, this.metaClass);
        }

        @Override
        public BindingType setMetaClass(DynamicObject metaClass) {
            return new BindingType(this.logicalClass, metaClass);
        }
    }
}

