/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.List;

public class TypeEqualityConstraint
implements ConstraintFormula {
    private static final Logger LOG = Logger.getInstance("#" + TypeEqualityConstraint.class.getName());
    private PsiType myT;
    private PsiType myS;

    public TypeEqualityConstraint(PsiType t, PsiType s) {
        this.myT = t;
        this.myS = s;
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        if (this.myT instanceof PsiWildcardType && this.myS instanceof PsiWildcardType) {
            PsiType tBound = ((PsiWildcardType)this.myT).getBound();
            PsiType sBound = ((PsiWildcardType)this.myS).getBound();
            if (tBound == null && sBound == null) {
                return true;
            }
            if (sBound == null && ((PsiWildcardType)this.myT).isExtends()) {
                constraints.add(new TypeEqualityConstraint(((PsiWildcardType)this.myS).getExtendsBound(), tBound));
                return true;
            }
            if (tBound == null && ((PsiWildcardType)this.myS).isExtends()) {
                constraints.add(new TypeEqualityConstraint(((PsiWildcardType)this.myT).getExtendsBound(), sBound));
                return true;
            }
            if (((PsiWildcardType)this.myT).isExtends() && ((PsiWildcardType)this.myS).isExtends() || ((PsiWildcardType)this.myT).isSuper() && ((PsiWildcardType)this.myS).isSuper()) {
                LOG.assertTrue(tBound != null);
                LOG.assertTrue(sBound != null);
                constraints.add(new TypeEqualityConstraint(tBound, sBound));
                return true;
            }
        }
        if (this.myT instanceof PsiWildcardType || this.myS instanceof PsiWildcardType) {
            session.registerIncompatibleErrorMessage("Incompatible equality constraint: " + session.getPresentableText(this.myT) + " and " + session.getPresentableText(this.myS));
            return false;
        }
        if (session.isProperType(this.myT) && session.isProperType(this.myS)) {
            boolean equal = Comparing.equal(this.myT, this.myS);
            if (!equal) {
                session.registerIncompatibleErrorMessage("Incompatible equality constraint: " + session.getPresentableText(this.myT) + " and " + session.getPresentableText(this.myS));
            }
            return equal;
        }
        if (this.myT == null || this.myT == PsiType.NULL) {
            return false;
        }
        if (this.myS == null || this.myS == PsiType.NULL) {
            return false;
        }
        InferenceVariable inferenceVariable = session.getInferenceVariable(this.myS);
        if (inferenceVariable != null && !(this.myT instanceof PsiPrimitiveType)) {
            inferenceVariable.addBound(this.myT, InferenceBound.EQ, session.myIncorporationPhase);
            return true;
        }
        inferenceVariable = session.getInferenceVariable(this.myT);
        if (inferenceVariable != null && !(this.myS instanceof PsiPrimitiveType)) {
            inferenceVariable.addBound(this.myS, InferenceBound.EQ, session.myIncorporationPhase);
            return true;
        }
        if (this.myT instanceof PsiClassType && this.myS instanceof PsiClassType) {
            PsiClassType.ClassResolveResult tResult = ((PsiClassType)this.myT).resolveGenerics();
            PsiClassType.ClassResolveResult sResult = ((PsiClassType)this.myS).resolveGenerics();
            PsiClass tClass = tResult.getElement();
            if (tClass != null && tClass.getManager().areElementsEquivalent(tClass, sResult.getElement())) {
                PsiSubstitutor tSubstitutor = tResult.getSubstitutor();
                PsiSubstitutor sSubstitutor = sResult.getSubstitutor();
                for (PsiTypeParameter typeParameter : tClass.getTypeParameters()) {
                    PsiType tSubstituted = tSubstitutor.substitute(typeParameter);
                    PsiType sSubstituted = sSubstitutor.substitute(typeParameter);
                    if (tSubstituted != null && sSubstituted != null) {
                        constraints.add(new TypeEqualityConstraint(tSubstituted, sSubstituted));
                    }
                    if (!(tSubstituted == null ^ sSubstituted == null)) continue;
                    session.registerIncompatibleErrorMessage("Incompatible equality constraint: " + session.getPresentableText(this.myT) + " and " + session.getPresentableText(this.myS));
                    return false;
                }
                return true;
            }
        }
        if (this.myT instanceof PsiArrayType && this.myS instanceof PsiArrayType) {
            constraints.add(new TypeEqualityConstraint(((PsiArrayType)this.myT).getComponentType(), ((PsiArrayType)this.myS).getComponentType()));
            return true;
        }
        session.registerIncompatibleErrorMessage(session.getInferenceVariables(), session.getPresentableText(this.myS) + " conforms to " + session.getPresentableText(this.myT));
        return false;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
        this.myS = substitutor2.substitute(this.myS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeEqualityConstraint that = (TypeEqualityConstraint)o;
        if (this.myS != null ? !this.myS.equals(that.myS) : that.myS != null) {
            return false;
        }
        return !(this.myT != null ? !this.myT.equals(that.myT) : that.myT != null);
    }

    public int hashCode() {
        int result2 = this.myT != null ? this.myT.hashCode() : 0;
        result2 = 31 * result2 + (this.myS != null ? this.myS.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return this.myT.getPresentableText() + " == " + this.myS.getPresentableText();
    }
}

