/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtBinaryExpressionWithTypeRHS
extends KtExpressionImpl
implements KtOperationExpression {
    public KtBinaryExpressionWithTypeRHS(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS", "accept"));
        }
        return visitor2.visitBinaryWithTypeRHSExpression(this, data);
    }

    @NotNull
    public KtExpression getLeft() {
        KtExpression left = this.findChildByClass(KtExpression.class);
        assert (left != null);
        KtExpression ktExpression = left;
        if (ktExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS", "getLeft"));
        }
        return ktExpression;
    }

    @IfNotParsed
    @Nullable
    public KtTypeReference getRight() {
        for (ASTNode node = this.getOperationReference().getNode(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof KtTypeReference)) continue;
            return (KtTypeReference)psi;
        }
        return null;
    }

    @Override
    @NotNull
    public KtSimpleNameExpression getOperationReference() {
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)this.findChildByType(KtNodeTypes.OPERATION_REFERENCE);
        if (ktSimpleNameExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS", "getOperationReference"));
        }
        return ktSimpleNameExpression;
    }
}

