#=============================================================================
# Copyright 2015 Luís Pereira <luis.artur.pereira@gmail.com>
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#=============================================================================


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was fm-qt-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

if (CMAKE_VERSION VERSION_LESS 3.0.2)
    message(FATAL_ERROR \"fm-qt requires at least CMake version 3.0.2\")
endif()

include(CMakeFindDependencyMacro)

find_dependency(Qt5Widgets "5.2")
find_dependency(Qt5X11Extras "5.2")

find_package(PkgConfig REQUIRED)
pkg_check_modules(PKG_GLIB glib-2.0)
pkg_check_modules(PKG_GIO
    gio-2.0
    gio-unix-2.0
)

pkg_check_modules(PKG_FM REQUIRED libfm>=1.2.0)
pkg_check_modules(PKG_MENUCACHE REQUIRED libmenu-cache>=0.4.0)

if (NOT TARGET fm-qt)
    include("${CMAKE_CURRENT_LIST_DIR}/fm-qt-targets.cmake")
    set_property(TARGET "fm-qt" APPEND PROPERTY
            INTERFACE_INCLUDE_DIRECTORIES
            "${PKG_GLIB_INCLUDE_DIRS}"
            "${PKG_GIO_INCLUDE_DIRS}"
            "${PKG_FM_INCLUDE_DIRS}"
            "${PKG_MENUCACHE_INCLUDE_DIRS}"
    )
    set_property(TARGET "fm-qt" APPEND PROPERTY
        INTERFACE_COMPILE_DEFINITIONS
            "QT_NO_KEYWORDS"
            "LIBFM_DATA_DIR=\"${PKG_FM_PREFIX}/share/libfm\""
    )
endif()
