/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class DragTracker
extends AbstractTool {
    private Figure fAnchorFigure;
    private int fLastX;
    private int fLastY;
    private boolean fMoved = false;

    public DragTracker(DrawingEditor newDrawingEditor, Figure anchor) {
        super(newDrawingEditor);
        this.fAnchorFigure = anchor;
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        this.fLastX = x;
        this.fLastY = y;
        if (e.isShiftDown()) {
            this.view().toggleSelection(this.fAnchorFigure);
            this.fAnchorFigure = null;
        } else if (!this.view().isFigureSelected(this.fAnchorFigure)) {
            this.view().clearSelection();
            this.view().addToSelection(this.fAnchorFigure);
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        boolean bl = this.fMoved = Math.abs(x - this.fAnchorX) > 4 || Math.abs(y - this.fAnchorY) > 4;
        if (this.fMoved) {
            FigureEnumeration figures = this.getUndoActivity().getAffectedFigures();
            while (figures.hasMoreElements()) {
                figures.nextFigure().moveBy(x - this.fLastX, y - this.fLastY);
            }
        }
        this.fLastX = x;
        this.fLastY = y;
    }

    public void activate() {
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selectionElements());
    }

    public void deactivate() {
        if (this.fMoved) {
            ((UndoActivity)this.getUndoActivity()).setBackupPoint(new Point(this.fLastX, this.fLastY));
        } else {
            this.setUndoActivity(null);
        }
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), new Point(this.fLastX, this.fLastY));
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private Point myOriginalPoint;
        private Point myBackupPoint;

        public UndoActivity(DrawingView newDrawingView, Point newOriginalPoint) {
            super(newDrawingView);
            this.setOriginalPoint(newOriginalPoint);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.moveAffectedFigures(this.getBackupPoint(), this.getOriginalPoint());
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            this.moveAffectedFigures(this.getOriginalPoint(), this.getBackupPoint());
            return true;
        }

        public void setBackupPoint(Point newBackupPoint) {
            this.myBackupPoint = newBackupPoint;
        }

        public Point getBackupPoint() {
            return this.myBackupPoint;
        }

        public void setOriginalPoint(Point newOriginalPoint) {
            this.myOriginalPoint = newOriginalPoint;
        }

        public Point getOriginalPoint() {
            return this.myOriginalPoint;
        }

        public void moveAffectedFigures(Point startPoint, Point endPoint) {
            FigureEnumeration figures = this.getAffectedFigures();
            while (figures.hasMoreElements()) {
                figures.nextFigure().moveBy(endPoint.x - startPoint.x, endPoint.y - startPoint.y);
            }
        }
    }
}

