/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import com.oracle.truffle.api.impl.DefaultVirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;

public final class DefaultCallTarget
implements RootCallTarget {
    private final RootNode rootNode;
    private volatile boolean initialized;

    DefaultCallTarget(RootNode function) {
        this.rootNode = function;
        this.rootNode.adoptChildren();
        this.rootNode.applyInstrumentation();
    }

    public String toString() {
        return this.rootNode.toString();
    }

    @Override
    public RootNode getRootNode() {
        return this.rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object callDirectOrIndirect(Node callNode, Object ... args) {
        if (!this.initialized) {
            this.initialize();
        }
        DefaultVirtualFrame frame = new DefaultVirtualFrame(this.getRootNode().getFrameDescriptor(), args);
        DefaultCallTarget.getRuntime().pushFrame(frame, this, callNode);
        try {
            Object object = this.getRootNode().execute(frame);
            return object;
        }
        finally {
            DefaultCallTarget.getRuntime().popFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call(Object ... args) {
        if (!this.initialized) {
            this.initialize();
        }
        DefaultVirtualFrame frame = new DefaultVirtualFrame(this.getRootNode().getFrameDescriptor(), args);
        DefaultCallTarget.getRuntime().pushFrame(frame, this);
        try {
            Object object = this.getRootNode().execute(frame);
            return object;
        }
        finally {
            DefaultCallTarget.getRuntime().popFrame();
        }
    }

    private static DefaultTruffleRuntime getRuntime() {
        return (DefaultTruffleRuntime)Truffle.getRuntime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        DefaultCallTarget defaultCallTarget = this;
        synchronized (defaultCallTarget) {
            if (!this.initialized) {
                ((DefaultTruffleRuntime)Truffle.getRuntime()).getTvmci().onFirstExecution(this);
                this.initialized = true;
            }
        }
    }
}

