/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsVisitorWithContext;
import com.google.dart.compiler.util.AstUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JsInvocation
extends JsExpressionImpl.JsExpressionHasArguments {
    @NotNull
    private JsExpression qualifier;

    public JsInvocation(@NotNull JsExpression qualifier, @NotNull List<JsExpression> arguments2) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/google/dart/compiler/backend/js/ast/JsInvocation", "<init>"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/google/dart/compiler/backend/js/ast/JsInvocation", "<init>"));
        }
        super(arguments2);
        this.qualifier = qualifier;
    }

    public JsInvocation(@NotNull JsExpression qualifier, JsExpression ... arguments2) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/google/dart/compiler/backend/js/ast/JsInvocation", "<init>"));
        }
        this(qualifier, new SmartList<JsExpression>(arguments2));
    }

    @Override
    @NotNull
    public List<JsExpression> getArguments() {
        List list2 = this.arguments;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsInvocation", "getArguments"));
        }
        return list2;
    }

    @NotNull
    public JsExpression getQualifier() {
        JsExpression jsExpression = this.qualifier;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsInvocation", "getQualifier"));
        }
        return jsExpression;
    }

    public void setQualifier(@NotNull JsExpression qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/google/dart/compiler/backend/js/ast/JsInvocation", "setQualifier"));
        }
        this.qualifier = qualifier;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitInvocation(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.qualifier);
        visitor2.acceptList(this.arguments);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            this.qualifier = v.accept(this.qualifier);
            v.acceptList(this.arguments);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsInvocation deepCopy() {
        JsExpression qualifierCopy = AstUtil.deepCopy(this.qualifier);
        List<JsExpression> argumentsCopy = AstUtil.deepCopy(this.arguments);
        JsInvocation jsInvocation = new JsInvocation(qualifierCopy, argumentsCopy).withMetadataFrom(this);
        if (jsInvocation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/dart/compiler/backend/js/ast/JsInvocation", "deepCopy"));
        }
        return jsInvocation;
    }
}

