/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpHeaderField;
import org.parosproxy.paros.network.HttpMessage;

public class VariantHeader
implements Variant {
    @Deprecated
    public static final String[] injectableHeaders = new String[]{"User-Agent", "Referer", "Host"};
    private static final String[] injectablesTempArray = new String[]{"Content-Length".toLowerCase(Locale.ROOT), "Pragma".toLowerCase(Locale.ROOT), "Cache-Control".toLowerCase(Locale.ROOT), "Cookie".toLowerCase(Locale.ROOT), "Authorization".toLowerCase(Locale.ROOT), "Proxy-Authorization".toLowerCase(Locale.ROOT), "Connection".toLowerCase(Locale.ROOT), "Proxy-Connection".toLowerCase(Locale.ROOT), "If-Modified-Since".toLowerCase(Locale.ROOT), "If-None-Match".toLowerCase(Locale.ROOT), "X-Csrf-Token".toLowerCase(Locale.ROOT), "X-CsrfToken".toLowerCase(Locale.ROOT), "X-Xsrf-Token".toLowerCase(Locale.ROOT), "X-ZAP-Scan-ID".toLowerCase(Locale.ROOT), "X-ZAP-RequestID".toLowerCase(Locale.ROOT), "X-Security-Proxy".toLowerCase(Locale.ROOT)};
    private static final HashSet<String> NON_INJECTABLE_HEADERS = new HashSet<String>(Arrays.asList(injectablesTempArray));
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();
    private static final Logger log = Logger.getLogger(VariantHeader.class);
    private static ScannerParam scannerOptions;

    @Override
    public void setMessage(HttpMessage httpMessage) {
        if (!this.isValidMessageToScan(httpMessage)) {
            return;
        }
        List<HttpHeaderField> list = httpMessage.getRequestHeader().getHeaders();
        int n = 0;
        for (HttpHeaderField httpHeaderField : list) {
            if (NON_INJECTABLE_HEADERS.contains(httpHeaderField.getName().toLowerCase(Locale.ROOT))) continue;
            this.params.add(new NameValuePair(8, httpHeaderField.getName(), httpHeaderField.getValue(), n++));
        }
    }

    private boolean isValidMessageToScan(HttpMessage httpMessage) {
        if (VariantHeader.getScannerOptions().isScanHeadersAllRequests()) {
            return true;
        }
        String string = null;
        try {
            string = httpMessage.getRequestHeader().getURI().getQuery();
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
        return string != null && !string.isEmpty() || httpMessage.getRequestBody().length() != 0;
    }

    private static ScannerParam getScannerOptions() {
        if (scannerOptions == null) {
            VariantHeader.getScannerOptionsSync();
        }
        return scannerOptions;
    }

    private static synchronized void getScannerOptionsSync() {
        if (scannerOptions == null) {
            scannerOptions = Model.getSingleton().getOptionsParam().getParamSet(ScannerParam.class);
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    @Override
    public String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2, true);
    }

    private String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2, boolean bl) {
        httpMessage.getRequestHeader().setHeader(nameValuePair.getName(), string2);
        return string + ":" + string2;
    }
}

