/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

public enum CodeRange {
    CR_UNKNOWN(0),
    CR_7BIT(16),
    CR_VALID(32),
    CR_BROKEN(48);

    private final int jrubyValue;

    private CodeRange(int jrubyValue) {
        this.jrubyValue = jrubyValue;
    }

    public int toInt() {
        return this.jrubyValue;
    }

    public static CodeRange fromInt(int codeRange) {
        switch (codeRange) {
            case 0: {
                return CR_UNKNOWN;
            }
            case 16: {
                return CR_7BIT;
            }
            case 32: {
                return CR_VALID;
            }
            case 48: {
                return CR_BROKEN;
            }
        }
        throw new UnsupportedOperationException("Don't know how to convert code range: " + codeRange);
    }
}

