/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.yaml;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.boot.yaml.ArrayDocumentMatcher;
import org.springframework.util.StringUtils;

public class SpringProfileDocumentMatcher
implements YamlProcessor.DocumentMatcher {
    private static final String[] DEFAULT_PROFILES = new String[]{"^\\s*$"};
    private static final String SPRING_PROFILES = "spring.profiles";
    private String[] activeProfiles = new String[0];

    public SpringProfileDocumentMatcher() {
    }

    public SpringProfileDocumentMatcher(String ... profiles) {
        this.addActiveProfiles(profiles);
    }

    public void addActiveProfiles(String ... profiles) {
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(this.activeProfiles));
        Collections.addAll(set, profiles);
        this.activeProfiles = set.toArray(new String[set.size()]);
    }

    public YamlProcessor.MatchStatus matches(Properties properties) {
        YamlProcessor.DocumentMatcher activeProfilesMatcher = this.getActiveProfilesDocumentMatcher();
        String profiles = properties.getProperty(SPRING_PROFILES);
        String negative = this.extractProfiles(profiles, ProfileType.NEGATIVE);
        String positive = this.extractProfiles(profiles, ProfileType.POSITIVE);
        if (StringUtils.hasLength((String)negative)) {
            properties = new Properties(properties);
            properties.setProperty(SPRING_PROFILES, negative);
            if (activeProfilesMatcher.matches(properties) == YamlProcessor.MatchStatus.FOUND) {
                return YamlProcessor.MatchStatus.NOT_FOUND;
            }
            if (StringUtils.isEmpty((Object)positive)) {
                return YamlProcessor.MatchStatus.FOUND;
            }
            properties.setProperty(SPRING_PROFILES, positive);
        }
        return activeProfilesMatcher.matches(properties);
    }

    private YamlProcessor.DocumentMatcher getActiveProfilesDocumentMatcher() {
        String[] profiles = this.activeProfiles;
        if (profiles.length == 0) {
            profiles = DEFAULT_PROFILES;
        }
        return new ArrayDocumentMatcher(SPRING_PROFILES, profiles);
    }

    private String extractProfiles(String profiles, ProfileType type) {
        if (profiles == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String candidate : StringUtils.commaDelimitedListToSet((String)profiles)) {
            ProfileType candidateType = ProfileType.POSITIVE;
            if (candidate.startsWith("!")) {
                candidateType = ProfileType.NEGATIVE;
            }
            if (candidateType != type) continue;
            result.append(result.length() > 0 ? "," : "");
            result.append(candidate.substring(type == ProfileType.POSITIVE ? 0 : 1));
        }
        return result.toString();
    }

    static enum ProfileType {
        POSITIVE,
        NEGATIVE;

    }
}

