/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.ComplexNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.NumericNode;
import org.jruby.ast.RationalNode;
import org.jruby.ast.StrNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.LexingCommon;
import org.jruby.lexer.yacc.HeredocTerm;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SimpleSourcePosition;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.StringTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.ParserSupport;
import org.jruby.util.ByteList;
import org.jruby.util.SafeDoubleParser;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;

public class RubyLexer
extends LexingCommon {
    private static final HashMap<String, Keyword> map = new HashMap();
    private ParserSupport parserSupport = null;
    private IRubyWarnings warnings;
    private StrTerm lex_strterm;
    private final ByteList TRUE = new ByteList(new byte[]{116, 114, 117, 101});
    private final ByteList FALSE = new ByteList(new byte[]{102, 97, 108, 115, 101});
    private ByteList numberBuffer = new ByteList(10);

    private BignumNode newBignumNode(String value2, int radix) {
        return new BignumNode(this.getPosition(), new BigInteger(value2, radix));
    }

    private FixnumNode newFixnumNode(String value2, int radix) throws NumberFormatException {
        return new FixnumNode(this.getPosition(), Long.parseLong(value2, radix));
    }

    private RationalNode newRationalNode(String value2, int radix) throws NumberFormatException {
        return new RationalNode(this.getPosition(), Long.parseLong(value2, radix), 1L);
    }

    private ComplexNode newComplexNode(NumericNode number) {
        return new ComplexNode(this.getPosition(), number);
    }

    @Override
    protected void ambiguousOperator(String op, String syn) {
        this.warnings.warn(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, this.getPosition(), "`" + op + "' after local variable or literal is interpreted as binary operator");
        this.warnings.warn(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, this.getPosition(), "even though it seems like " + syn);
    }

    public static Keyword getKeyword(String str) {
        return map.get(str);
    }

    @Override
    public int tokenize_ident(int result2) {
        String value2 = this.createTokenString();
        if (RubyLexer.isLexState(this.last_state, 384) && this.parserSupport.getCurrentScope().isDefined(value2) >= 0) {
            this.setState(2);
        }
        this.yaccValue = value2.intern();
        return result2;
    }

    public RubyLexer(ParserSupport support, LexerSource source2, IRubyWarnings warnings) {
        super(source2);
        this.parserSupport = support;
        this.warnings = warnings;
        this.reset();
    }

    @Deprecated
    public RubyLexer(ParserSupport support, LexerSource source2) {
        super(source2);
        this.parserSupport = support;
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.lex_strterm = null;
        this.ruby_sourceline = this.src.getLineOffset() - 1;
        this.parser_prepare();
    }

    @Override
    public int nextc() {
        if (this.lex_p == this.lex_pend) {
            this.line_offset += this.lex_pend;
            ByteList v = this.lex_nextline;
            this.lex_nextline = null;
            if (v == null) {
                if (this.eofp) {
                    return -1;
                }
                if (this.src == null || (v = this.src.gets()) == null) {
                    this.eofp = true;
                    this.lex_goto_eol();
                    return -1;
                }
            }
            if (this.heredoc_end > 0) {
                this.ruby_sourceline = this.heredoc_end;
                this.heredoc_end = 0;
            }
            ++this.ruby_sourceline;
            ++this.line_count;
            this.lex_p = 0;
            this.lex_pbeg = 0;
            this.lex_pend = this.lex_p + v.length();
            this.lexb = v;
            this.flush();
            this.lex_lastline = v;
        }
        int c = this.p(this.lex_p);
        ++this.lex_p;
        if (c == 13) {
            if (this.peek(10)) {
                ++this.lex_p;
                c = 10;
            } else if (this.ruby_sourceline > this.last_cr_line) {
                this.last_cr_line = this.ruby_sourceline;
                this.warnings.warn(IRubyWarnings.ID.VOID_VALUE_EXPRESSION, this.getFile(), this.ruby_sourceline, "encountered \\r in middle of line, treated as a mere space");
                c = 32;
            }
        }
        return c;
    }

    public void heredoc_dedent(Node root) {
        int indent = this.heredoc_indent;
        if (indent <= 0 || root == null) {
            return;
        }
        if (root instanceof StrNode) {
            StrNode str = (StrNode)root;
            this.dedent_string(str.getValue(), indent);
        } else if (root instanceof ListNode) {
            ListNode list2 = (ListNode)root;
            int length2 = list2.size();
            int currentLine = -1;
            for (int i2 = 0; i2 < length2; ++i2) {
                Node child = list2.get(i2);
                if (currentLine == child.getLine()) continue;
                currentLine = child.getLine();
                if (!(child instanceof StrNode)) continue;
                this.dedent_string(((StrNode)child).getValue(), indent);
            }
        }
    }

    @Override
    public void compile_error(String message2) {
        throw new SyntaxException(SyntaxException.PID.BAD_HEX_NUMBER, this.getFile(), this.ruby_sourceline, this.lexb.toString(), message2, new Object[0]);
    }

    public void compile_error(SyntaxException.PID pid2, String message2) {
        String src = this.createAsEncodedString(this.lex_lastline.unsafeBytes(), this.lex_lastline.begin(), this.lex_lastline.length(), this.getEncoding());
        throw new SyntaxException(pid2, this.getFile(), this.ruby_sourceline, src, message2, new Object[0]);
    }

    public void heredoc_restore(HeredocTerm here) {
        ByteList line;
        this.lex_lastline = line = here.lastLine;
        this.lex_pbeg = 0;
        this.lex_pend = this.lex_pbeg + line.length();
        this.lex_p = this.lex_pbeg + here.nth;
        this.lexb = line;
        this.heredoc_end = this.ruby_sourceline;
        this.ruby_sourceline = here.line;
        this.flush();
    }

    public int nextToken() throws IOException {
        this.token = this.yylex();
        return this.token == -1 ? 0 : this.token;
    }

    public ISourcePosition getPosition(ISourcePosition startPosition) {
        if (startPosition != null) {
            return startPosition;
        }
        if (this.tokline != null && this.ruby_sourceline == this.tokline.getLine()) {
            return this.tokline;
        }
        return new SimpleSourcePosition(this.getFile(), this.ruby_sourceline);
    }

    public void setParserSupport(ParserSupport parserSupport) {
        this.parserSupport = parserSupport;
    }

    @Override
    protected void setCompileOptionFlag(String name2, ByteList value2) {
        if (this.tokenSeen) {
            this.warnings.warn(IRubyWarnings.ID.ACCESSOR_MODULE_FUNCTION, "`" + name2 + "' is ignored after any tokens");
            return;
        }
        int b2 = this.asTruth(name2, value2);
        if (b2 < 0) {
            return;
        }
        this.parserSupport.getConfiguration().setFrozenStringLiteral(b2 == 1);
    }

    protected int asTruth(String name2, ByteList value2) {
        int result2 = value2.caseInsensitiveCmp(this.TRUE);
        if (result2 == 0) {
            return 1;
        }
        result2 = value2.caseInsensitiveCmp(this.FALSE);
        if (result2 == 0) {
            return 0;
        }
        this.warnings.warn(IRubyWarnings.ID.ACCESSOR_MODULE_FUNCTION, "invalid value for " + name2 + ": " + value2);
        return -1;
    }

    @Override
    protected void setTokenInfo(String name2, ByteList value2) {
    }

    @Override
    protected void setEncoding(ByteList name2) {
        Ruby runtime = this.parserSupport.getConfiguration().getRuntime();
        Encoding newEncoding = runtime.getEncodingService().loadEncoding(name2);
        if (newEncoding == null) {
            throw runtime.newArgumentError("unknown encoding name: " + name2.toString());
        }
        if (!newEncoding.isAsciiCompatible()) {
            throw runtime.newArgumentError(name2.toString() + " is not ASCII compatible");
        }
        this.setEncoding(newEncoding);
    }

    public StrTerm getStrTerm() {
        return this.lex_strterm;
    }

    public void setStrTerm(StrTerm strterm) {
        this.lex_strterm = strterm;
    }

    public void setWarnings(IRubyWarnings warnings) {
        this.warnings = warnings;
    }

    private int considerComplex(int token, int suffix) {
        if ((suffix & 2) == 0) {
            return token;
        }
        this.yaccValue = this.newComplexNode((NumericNode)this.yaccValue);
        return 380;
    }

    private int getFloatToken(String number, int suffix) {
        double d;
        if ((suffix & 1) != 0) {
            BigDecimal bd = new BigDecimal(number);
            BigDecimal denominator2 = BigDecimal.ONE.scaleByPowerOfTen(bd.scale());
            BigDecimal numerator2 = bd.multiply(denominator2);
            try {
                this.yaccValue = new RationalNode(this.getPosition(), numerator2.longValueExact(), denominator2.longValueExact());
            }
            catch (ArithmeticException ae) {
                this.compile_error(SyntaxException.PID.RATIONAL_OUT_OF_RANGE, "Rational (" + numerator2 + "/" + denominator2 + ") out of range.");
            }
            return this.considerComplex(382, suffix);
        }
        try {
            d = SafeDoubleParser.parseDouble(number);
        }
        catch (NumberFormatException e) {
            this.warnings.warn(IRubyWarnings.ID.FLOAT_OUT_OF_RANGE, this.getPosition(), "Float " + number + " out of range.");
            d = number.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        this.yaccValue = new FloatNode(this.getPosition(), d);
        return this.considerComplex(381, suffix);
    }

    private int getIntegerToken(String value2, int radix, int suffix) {
        NumericNode literalValue;
        if ((suffix & 1) != 0) {
            literalValue = this.newRationalNode(value2, radix);
        } else {
            try {
                literalValue = this.newFixnumNode(value2, radix);
            }
            catch (NumberFormatException e) {
                literalValue = this.newBignumNode(value2, radix);
            }
        }
        this.yaccValue = literalValue;
        return this.considerComplex(379, suffix);
    }

    public StrNode createStr(ByteList buffer, int flags2) {
        Encoding bufferEncoding = buffer.getEncoding();
        int codeRange = StringSupport.codeRangeScan(bufferEncoding, buffer);
        if ((flags2 & 4) == 0 && bufferEncoding.isAsciiCompatible() && codeRange != 16 && this.getEncoding() == USASCII_ENCODING && bufferEncoding != UTF8_ENCODING) {
            codeRange = ParserSupport.associateEncoding(buffer, ASCII8BIT_ENCODING, codeRange);
        }
        StrNode newStr = new StrNode(this.getPosition(), buffer, codeRange);
        if (this.parserSupport.getConfiguration().isFrozenStringLiteral()) {
            newStr.setFrozen(true);
        }
        return newStr;
    }

    private int parseQuote(int c) throws IOException {
        int end2;
        boolean shortHand;
        int begin2;
        if (!Character.isLetterOrDigit(c)) {
            begin2 = c;
            c = 81;
            shortHand = true;
        } else {
            shortHand = false;
            begin2 = this.nextc();
            if (Character.isLetterOrDigit(begin2)) {
                this.compile_error(SyntaxException.PID.STRING_UNKNOWN_TYPE, "unknown type of %string");
            }
        }
        if (c == -1 || begin2 == -1) {
            this.compile_error(SyntaxException.PID.STRING_HITS_EOF, "unterminated quoted string meets end of file");
        }
        switch (begin2) {
            case 40: {
                end2 = 41;
                break;
            }
            case 91: {
                end2 = 93;
                break;
            }
            case 123: {
                end2 = 125;
                break;
            }
            case 60: {
                end2 = 62;
                break;
            }
            default: {
                end2 = begin2;
                begin2 = 0;
            }
        }
        switch (c) {
            case 81: {
                this.lex_strterm = new StringTerm(2, begin2, end2);
                this.yaccValue = "%" + (shortHand ? "" + end2 : "" + c + begin2);
                return 366;
            }
            case 113: {
                this.lex_strterm = new StringTerm(0, begin2, end2);
                this.yaccValue = "%" + c + begin2;
                return 366;
            }
            case 87: {
                this.lex_strterm = new StringTerm(10, begin2, end2);
                while (Character.isWhitespace(c = this.nextc())) {
                }
                this.pushback(c);
                this.yaccValue = "%" + c + begin2;
                return 369;
            }
            case 119: {
                this.lex_strterm = new StringTerm(8, begin2, end2);
                while (Character.isWhitespace(c = this.nextc())) {
                }
                this.pushback(c);
                this.yaccValue = "%" + c + begin2;
                return 370;
            }
            case 120: {
                this.lex_strterm = new StringTerm(2, begin2, end2);
                this.yaccValue = "%" + c + begin2;
                return 367;
            }
            case 114: {
                this.lex_strterm = new StringTerm(7, begin2, end2);
                this.yaccValue = "%" + c + begin2;
                return 368;
            }
            case 115: {
                this.lex_strterm = new StringTerm(16, begin2, end2);
                this.setState(128);
                this.yaccValue = "%" + c + begin2;
                return 365;
            }
            case 73: {
                this.lex_strterm = new StringTerm(10, begin2, end2);
                while (Character.isWhitespace(c = this.nextc())) {
                }
                this.pushback(c);
                this.yaccValue = "%" + c + begin2;
                return 384;
            }
            case 105: {
                this.lex_strterm = new StringTerm(8, begin2, end2);
                while (Character.isWhitespace(c = this.nextc())) {
                }
                this.pushback(c);
                this.yaccValue = "%" + c + begin2;
                return 385;
            }
        }
        this.compile_error(SyntaxException.PID.STRING_UNKNOWN_TYPE, "unknown type of %string");
        return -1;
    }

    private int hereDocumentIdentifier() throws IOException {
        ByteList markerValue;
        int term;
        int c = this.nextc();
        int func = 0;
        if (c == 45) {
            c = this.nextc();
            func = 32;
        } else if (c == 126) {
            c = this.nextc();
            func = 32;
            this.heredoc_indent = Integer.MAX_VALUE;
            this.heredoc_line_indent = 0;
        }
        if (c == 39 || c == 34 || c == 96) {
            func = c == 39 ? (func |= 0) : (c == 34 ? (func |= 2) : (func |= 2));
            this.newtok(false);
            term = c;
            while ((c = this.nextc()) != -1 && c != term) {
                if (this.tokadd_mbchar(c)) continue;
                return -1;
            }
            if (c == -1) {
                this.compile_error("unterminated here document identifier");
            }
            this.pushback(term);
            markerValue = this.createTokenByteList();
            this.nextc();
        } else {
            if (!this.isIdentifierChar(c)) {
                this.pushback(c);
                if ((func & 0x20) != 0) {
                    this.pushback(this.heredoc_indent > 0 ? 126 : 45);
                }
                return 0;
            }
            this.newtok(true);
            term = 34;
            func |= 2;
            do {
                if (this.tokadd_mbchar(c)) continue;
                return -1;
            } while ((c = this.nextc()) != -1 && this.isIdentifierChar(c));
            this.pushback(c);
            markerValue = this.createTokenByteList();
        }
        int len = this.lex_p - this.lex_pbeg;
        this.lex_goto_eol();
        this.lex_strterm = new HeredocTerm(markerValue, func, len, this.ruby_sourceline, this.lex_lastline);
        if (term == 96) {
            this.yaccValue = "`";
            this.flush();
            return 367;
        }
        this.yaccValue = "\"";
        this.flush();
        return 366;
    }

    private boolean arg_ambiguous() {
        if (this.warnings.isVerbose() && Options.PARSER_WARN_AMBIGUOUS_ARGUMENTS.load().booleanValue() && !ParserSupport.skipTruffleRubiniusWarnings(this)) {
            this.warnings.warning(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, this.getPosition(), "Ambiguous first argument; make sure.");
        }
        return true;
    }

    private void printToken(int token) {
        switch (token) {
            case 256: {
                System.err.print("yyErrorCode,");
                break;
            }
            case 257: {
                System.err.print("kClass,");
                break;
            }
            case 258: {
                System.err.print("kModule,");
                break;
            }
            case 259: {
                System.err.print("kDEF,");
                break;
            }
            case 260: {
                System.err.print("kUNDEF,");
                break;
            }
            case 261: {
                System.err.print("kBEGIN,");
                break;
            }
            case 262: {
                System.err.print("kRESCUE,");
                break;
            }
            case 263: {
                System.err.print("kENSURE,");
                break;
            }
            case 264: {
                System.err.print("kEND,");
                break;
            }
            case 265: {
                System.err.print("kIF,");
                break;
            }
            case 266: {
                System.err.print("kUNLESS,");
                break;
            }
            case 267: {
                System.err.print("kTHEN,");
                break;
            }
            case 268: {
                System.err.print("kELSIF,");
                break;
            }
            case 269: {
                System.err.print("kELSE,");
                break;
            }
            case 270: {
                System.err.print("kCASE,");
                break;
            }
            case 271: {
                System.err.print("kWHEN,");
                break;
            }
            case 272: {
                System.err.print("kWHILE,");
                break;
            }
            case 273: {
                System.err.print("kUNTIL,");
                break;
            }
            case 274: {
                System.err.print("kFOR,");
                break;
            }
            case 275: {
                System.err.print("kBREAK,");
                break;
            }
            case 276: {
                System.err.print("kNEXT,");
                break;
            }
            case 277: {
                System.err.print("kREDO,");
                break;
            }
            case 278: {
                System.err.print("kRETRY,");
                break;
            }
            case 279: {
                System.err.print("kIN,");
                break;
            }
            case 280: {
                System.err.print("kDO,");
                break;
            }
            case 281: {
                System.err.print("kDO_COND,");
                break;
            }
            case 282: {
                System.err.print("kDO_BLOCK,");
                break;
            }
            case 283: {
                System.err.print("kRETURN,");
                break;
            }
            case 284: {
                System.err.print("kYIELD,");
                break;
            }
            case 285: {
                System.err.print("kSUPER,");
                break;
            }
            case 286: {
                System.err.print("kSELF,");
                break;
            }
            case 287: {
                System.err.print("kNIL,");
                break;
            }
            case 288: {
                System.err.print("kTRUE,");
                break;
            }
            case 289: {
                System.err.print("kFALSE,");
                break;
            }
            case 290: {
                System.err.print("kAND,");
                break;
            }
            case 291: {
                System.err.print("kOR,");
                break;
            }
            case 292: {
                System.err.print("kNOT,");
                break;
            }
            case 293: {
                System.err.print("kIF_MOD,");
                break;
            }
            case 294: {
                System.err.print("kUNLESS_MOD,");
                break;
            }
            case 295: {
                System.err.print("kWHILE_MOD,");
                break;
            }
            case 296: {
                System.err.print("kUNTIL_MOD,");
                break;
            }
            case 297: {
                System.err.print("kRESCUE_MOD,");
                break;
            }
            case 298: {
                System.err.print("kALIAS,");
                break;
            }
            case 299: {
                System.err.print("kDEFINED,");
                break;
            }
            case 300: {
                System.err.print("klBEGIN,");
                break;
            }
            case 301: {
                System.err.print("klEND,");
                break;
            }
            case 302: {
                System.err.print("k__LINE__,");
                break;
            }
            case 303: {
                System.err.print("k__FILE__,");
                break;
            }
            case 304: {
                System.err.print("k__ENCODING__,");
                break;
            }
            case 305: {
                System.err.print("kDO_LAMBDA,");
                break;
            }
            case 306: {
                System.err.print("tIDENTIFIER[" + this.value() + "],");
                break;
            }
            case 307: {
                System.err.print("tFID[" + this.value() + "],");
                break;
            }
            case 308: {
                System.err.print("tGVAR[" + this.value() + "],");
                break;
            }
            case 309: {
                System.err.print("tIVAR[" + this.value() + "],");
                break;
            }
            case 310: {
                System.err.print("tCONSTANT[" + this.value() + "],");
                break;
            }
            case 311: {
                System.err.print("tCVAR,");
                break;
            }
            case 379: {
                System.err.print("tINTEGER,");
                break;
            }
            case 381: {
                System.err.print("tFLOAT,");
                break;
            }
            case 378: {
                System.err.print("tSTRING_CONTENT[" + ((StrNode)this.value()).getValue() + "],");
                break;
            }
            case 366: {
                System.err.print("tSTRING_BEG,");
                break;
            }
            case 373: {
                System.err.print("tSTRING_END,");
                break;
            }
            case 371: {
                System.err.print("tSTRING_DBEG,");
                break;
            }
            case 372: {
                System.err.print("tSTRING_DVAR,");
                break;
            }
            case 367: {
                System.err.print("tXSTRING_BEG,");
                break;
            }
            case 368: {
                System.err.print("tREGEXP_BEG,");
                break;
            }
            case 383: {
                System.err.print("tREGEXP_END,");
                break;
            }
            case 369: {
                System.err.print("tWORDS_BEG,");
                break;
            }
            case 370: {
                System.err.print("tQWORDS_BEG,");
                break;
            }
            case 377: {
                System.err.print("tBACK_REF,");
                break;
            }
            case 364: {
                System.err.print("tBACK_REF2,");
                break;
            }
            case 376: {
                System.err.print("tNTH_REF,");
                break;
            }
            case 314: {
                System.err.print("tUPLUS");
                break;
            }
            case 315: {
                System.err.print("tUMINUS,");
                break;
            }
            case 317: {
                System.err.print("tPOW,");
                break;
            }
            case 318: {
                System.err.print("tCMP,");
                break;
            }
            case 319: {
                System.err.print("tEQ,");
                break;
            }
            case 320: {
                System.err.print("tEQQ,");
                break;
            }
            case 321: {
                System.err.print("tNEQ,");
                break;
            }
            case 322: {
                System.err.print("tGEQ,");
                break;
            }
            case 323: {
                System.err.print("tLEQ,");
                break;
            }
            case 324: {
                System.err.print("tANDOP,");
                break;
            }
            case 325: {
                System.err.print("tOROP,");
                break;
            }
            case 326: {
                System.err.print("tMATCH,");
                break;
            }
            case 327: {
                System.err.print("tNMATCH,");
                break;
            }
            case 328: {
                System.err.print("tDOT,");
                break;
            }
            case 329: {
                System.err.print("tDOT2,");
                break;
            }
            case 330: {
                System.err.print("tDOT3,");
                break;
            }
            case 331: {
                System.err.print("tAREF,");
                break;
            }
            case 332: {
                System.err.print("tASET,");
                break;
            }
            case 333: {
                System.err.print("tLSHFT,");
                break;
            }
            case 334: {
                System.err.print("tRSHFT,");
                break;
            }
            case 336: {
                System.err.print("tCOLON2,");
                break;
            }
            case 337: {
                System.err.print("tCOLON3,");
                break;
            }
            case 338: {
                System.err.print("tOP_ASGN,");
                break;
            }
            case 339: {
                System.err.print("tASSOC,");
                break;
            }
            case 340: {
                System.err.print("tLPAREN,");
                break;
            }
            case 341: {
                System.err.print("tLPAREN2,");
                break;
            }
            case 343: {
                System.err.print("tLPAREN_ARG,");
                break;
            }
            case 344: {
                System.err.print("tLBRACK,");
                break;
            }
            case 345: {
                System.err.print("tRBRACK,");
                break;
            }
            case 346: {
                System.err.print("tLBRACE,");
                break;
            }
            case 347: {
                System.err.print("tLBRACE_ARG,");
                break;
            }
            case 348: {
                System.err.print("tSTAR,");
                break;
            }
            case 349: {
                System.err.print("tSTAR2,");
                break;
            }
            case 350: {
                System.err.print("tAMPER,");
                break;
            }
            case 351: {
                System.err.print("tAMPER2,");
                break;
            }
            case 365: {
                System.err.print("tSYMBEG,");
                break;
            }
            case 352: {
                System.err.print("tTILDE,");
                break;
            }
            case 353: {
                System.err.print("tPERCENT,");
                break;
            }
            case 354: {
                System.err.print("tDIVIDE,");
                break;
            }
            case 355: {
                System.err.print("tPLUS,");
                break;
            }
            case 356: {
                System.err.print("tMINUS,");
                break;
            }
            case 357: {
                System.err.print("tLT,");
                break;
            }
            case 358: {
                System.err.print("tGT,");
                break;
            }
            case 361: {
                System.err.print("tCARET,");
                break;
            }
            case 360: {
                System.err.print("tBANG,");
                break;
            }
            case 362: {
                System.err.print("tTLCURLY,");
                break;
            }
            case 363: {
                System.err.print("tRCURLY,");
                break;
            }
            case 359: {
                System.err.print("tTPIPE,");
                break;
            }
            case 374: {
                System.err.print("tLAMBDA,");
                break;
            }
            case 375: {
                System.err.print("tLAMBEG,");
                break;
            }
            case 342: {
                System.err.print("tRPAREN,");
                break;
            }
            case 312: {
                System.err.print("tLABEL(" + this.value() + ":),");
                break;
            }
            case 388: {
                System.err.print("tLABEL_END");
                break;
            }
            case 10: {
                System.err.println("NL");
                break;
            }
            case -1: {
                System.out.println("EOF");
                break;
            }
            case 386: {
                System.err.print("tDSTAR");
                break;
            }
            default: {
                System.err.print("'" + (char)token + "',");
            }
        }
    }

    private int yylex2() throws IOException {
        int currentToken = this.yylex2();
        this.printToken(currentToken);
        return currentToken;
    }

    private int yylex() throws IOException {
        int c;
        boolean spaceSeen = false;
        boolean tokenSeen = this.tokenSeen;
        if (this.lex_strterm != null) {
            int tok = this.lex_strterm.parseString(this);
            if (tok == 373 && (this.lex_strterm.getFlags() & 0x40) != 0 && (RubyLexer.isLexState(this.lex_state, 9) && !this.conditionState.isInState() || this.isARG()) && this.isLabelSuffix()) {
                this.nextc();
                tok = 388;
                this.setState(1025);
                this.lex_strterm = null;
            }
            if (tok == 373 || tok == 383) {
                this.lex_strterm = null;
                this.setState(2);
            }
            return tok;
        }
        boolean commandState = this.commandStart;
        this.commandStart = false;
        this.tokenSeen = true;
        block42: while (true) {
            this.last_state = this.lex_state;
            c = this.nextc();
            switch (c) {
                case -1: 
                case 0: 
                case 4: 
                case 26: {
                    return -1;
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    this.getPosition();
                    spaceSeen = true;
                    continue block42;
                }
                case 35: {
                    this.tokenSeen = tokenSeen;
                    if (!this.parseMagicComment(this.parserSupport.getConfiguration().getRuntime(), this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p)) && this.comment_at_top()) {
                        this.set_file_encoding(this.lex_p, this.lex_pend);
                    }
                    this.lex_p = this.lex_pend;
                }
                case 10: {
                    boolean normalArg;
                    this.tokenSeen = tokenSeen;
                    boolean bl = normalArg = RubyLexer.isLexState(this.lex_state, 897) && !RubyLexer.isLexState(this.lex_state, 2048);
                    if (normalArg || this.isLexStateAll(this.lex_state, 2064)) {
                        if (normalArg || !this.inKwarg) continue block42;
                        this.commandStart = true;
                        this.setState(1);
                        return 10;
                    }
                    boolean done = false;
                    block43: while (!done) {
                        c = this.nextc();
                        switch (c) {
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                spaceSeen = true;
                                continue block43;
                            }
                            case 38: 
                            case 46: {
                                if (this.peek(46) != (c == 38)) break;
                                this.pushback(c);
                                continue block42;
                            }
                        }
                        done = true;
                    }
                    if (c == -1) {
                        return -1;
                    }
                    this.pushback(c);
                    this.getPosition();
                    this.commandStart = true;
                    this.setState(1);
                    return 10;
                }
                case 42: {
                    return this.star(spaceSeen);
                }
                case 33: {
                    return this.bang();
                }
                case 61: {
                    if (this.was_bol() && this.strncmp(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p), BEGIN_DOC_MARKER, BEGIN_DOC_MARKER.length()) && Character.isWhitespace(this.p(this.lex_p + 5))) {
                        do {
                            this.lex_goto_eol();
                            c = this.nextc();
                            if (c != -1) continue;
                            this.compile_error("embedded document meets end of file");
                            return -1;
                        } while (c != 61 || !this.strncmp(this.lexb.makeShared(this.lex_p, this.lex_pend - this.lex_p), END_DOC_MARKER, END_DOC_MARKER.length()) || this.lex_p + 3 != this.lex_pend && !Character.isWhitespace(this.p(this.lex_p + 3)));
                        this.lex_goto_eol();
                        continue block42;
                    }
                    this.setState(this.isAfterOperator() ? 16 : 1);
                    c = this.nextc();
                    if (c == 61) {
                        c = this.nextc();
                        if (c == 61) {
                            this.yaccValue = "===";
                            return 320;
                        }
                        this.pushback(c);
                        this.yaccValue = "==";
                        return 319;
                    }
                    if (c == 126) {
                        this.yaccValue = "=~";
                        return 326;
                    }
                    if (c == 62) {
                        this.yaccValue = "=>";
                        return 339;
                    }
                    this.pushback(c);
                    this.yaccValue = "=";
                    return 61;
                }
                case 60: {
                    return this.lessThan(spaceSeen);
                }
                case 62: {
                    return this.greaterThan();
                }
                case 34: {
                    return this.doubleQuote(commandState);
                }
                case 96: {
                    return this.backtick(commandState);
                }
                case 39: {
                    return this.singleQuote(commandState);
                }
                case 63: {
                    return this.questionMark();
                }
                case 38: {
                    return this.ampersand(spaceSeen);
                }
                case 124: {
                    return this.pipe();
                }
                case 43: {
                    return this.plus(spaceSeen);
                }
                case 45: {
                    return this.minus(spaceSeen);
                }
                case 46: {
                    return this.dot();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumber(c);
                }
                case 41: {
                    return this.rightParen();
                }
                case 93: {
                    return this.rightBracket();
                }
                case 125: {
                    return this.rightCurly();
                }
                case 58: {
                    return this.colon(spaceSeen);
                }
                case 47: {
                    return this.slash(spaceSeen);
                }
                case 94: {
                    return this.caret();
                }
                case 59: {
                    this.commandStart = true;
                    this.setState(1);
                    this.yaccValue = ";";
                    return 59;
                }
                case 44: {
                    return this.comma(c);
                }
                case 126: {
                    return this.tilde();
                }
                case 40: {
                    return this.leftParen(spaceSeen);
                }
                case 91: {
                    return this.leftBracket(spaceSeen);
                }
                case 123: {
                    return this.leftCurly();
                }
                case 92: {
                    c = this.nextc();
                    if (c == 10) {
                        spaceSeen = true;
                        continue block42;
                    }
                    this.pushback(c);
                    this.yaccValue = "\\";
                    return 92;
                }
                case 37: {
                    return this.percent(spaceSeen);
                }
                case 36: {
                    return this.dollar();
                }
                case 64: {
                    return this.at();
                }
                case 95: {
                    if (this.was_bol() && this.whole_match_p(END_MARKER, false)) {
                        this.line_offset += this.lex_pend;
                        this.__end__seen = true;
                        this.eofp = true;
                        this.lex_goto_eol();
                        return -1;
                    }
                    return this.identifier(c, commandState);
                }
            }
            break;
        }
        return this.identifier(c, commandState);
    }

    private int identifierToken(int result2, String value2) {
        if (result2 == 306 && !RubyLexer.isLexState(this.last_state, 384) && this.parserSupport.getCurrentScope().isDefined(value2) >= 0) {
            this.setState(2);
        }
        this.yaccValue = value2;
        return result2;
    }

    private int ampersand(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        switch (c) {
            case 38: {
                this.setState(1);
                c = this.nextc();
                if (c == 61) {
                    this.yaccValue = "&&";
                    this.setState(1);
                    return 338;
                }
                this.pushback(c);
                this.yaccValue = "&&";
                return 324;
            }
            case 61: {
                this.yaccValue = "&";
                this.setState(1);
                return 338;
            }
            case 46: {
                this.setState(256);
                this.yaccValue = "&.";
                return 335;
            }
        }
        this.pushback(c);
        ISourcePosition tmpPosition = this.getPosition();
        if (this.isSpaceArg(c, spaceSeen)) {
            if (this.warnings.isVerbose() && Options.PARSER_WARN_ARGUMENT_PREFIX.load().booleanValue()) {
                this.warnings.warning(IRubyWarnings.ID.ARGUMENT_AS_PREFIX, tmpPosition, "`&' interpreted as argument prefix");
            }
            c = 350;
        } else if (this.isBEG()) {
            c = 350;
        } else {
            this.warn_balanced(c, spaceSeen, "&", "argument prefix");
            c = 351;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.yaccValue = "&";
        return c;
    }

    private int at() throws IOException {
        int result2;
        this.newtok(true);
        int c = this.nextc();
        if (c == 64) {
            c = this.nextc();
            result2 = 311;
        } else {
            result2 = 309;
        }
        if (c == -1 || Character.isSpaceChar(c)) {
            if (result2 == 309) {
                this.compile_error("`@' without identifiers is not allowed as an instance variable name");
            }
            this.compile_error("`@@' without identifiers is not allowed as a class variable name");
        } else if (Character.isDigit(c) || !this.isIdentifierChar(c)) {
            this.pushback(c);
            if (result2 == 309) {
                this.compile_error(SyntaxException.PID.IVAR_BAD_NAME, "`@" + (char)c + "' is not allowed as an instance variable name");
            }
            this.compile_error(SyntaxException.PID.CVAR_BAD_NAME, "`@@" + (char)c + "' is not allowed as a class variable name");
        }
        if (!this.tokadd_ident(c)) {
            return -1;
        }
        this.last_state = this.lex_state;
        this.setState(2);
        return this.tokenize_ident(result2);
    }

    private int backtick(boolean commandState) throws IOException {
        this.yaccValue = "`";
        if (RubyLexer.isLexState(this.lex_state, 128)) {
            this.setState(8);
            return 364;
        }
        if (RubyLexer.isLexState(this.lex_state, 256)) {
            this.setState(commandState ? 32 : 16);
            return 364;
        }
        this.lex_strterm = new StringTerm(2, 0, 96);
        return 367;
    }

    private int bang() throws IOException {
        int c = this.nextc();
        if (this.isAfterOperator()) {
            this.setState(16);
            if (c == 64) {
                this.yaccValue = "!";
                return 360;
            }
        } else {
            this.setState(1);
        }
        switch (c) {
            case 61: {
                this.yaccValue = "!=";
                return 321;
            }
            case 126: {
                this.yaccValue = "!~";
                return 327;
            }
        }
        this.pushback(c);
        this.yaccValue = "!";
        return 360;
    }

    private int caret() throws IOException {
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            this.yaccValue = "^";
            return 338;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.pushback(c);
        this.yaccValue = "^";
        return 361;
    }

    private int colon(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        if (c == 58) {
            if (this.isBEG() || RubyLexer.isLexState(this.lex_state, 512) || this.isARG() && spaceSeen) {
                this.setState(1);
                this.yaccValue = "::";
                return 337;
            }
            this.setState(256);
            this.yaccValue = ":";
            return 336;
        }
        if (this.isEND() || Character.isWhitespace(c) || c == 35) {
            this.pushback(c);
            this.setState(1);
            this.yaccValue = ":";
            this.warn_balanced(c, spaceSeen, ":", "symbol literal");
            return 58;
        }
        switch (c) {
            case 39: {
                this.lex_strterm = new StringTerm(16, 0, c);
                break;
            }
            case 34: {
                this.lex_strterm = new StringTerm(18, 0, c);
                break;
            }
            default: {
                this.pushback(c);
            }
        }
        this.setState(128);
        this.yaccValue = ":";
        return 365;
    }

    private int comma(int c) throws IOException {
        this.setState(1025);
        this.yaccValue = ",";
        return c;
    }

    private int doKeyword(int state2) {
        int leftParenBegin = this.getLeftParenBegin();
        if (leftParenBegin > 0 && leftParenBegin == this.parenNest) {
            this.setLeftParenBegin(0);
            --this.parenNest;
            return 305;
        }
        if (this.conditionState.isInState()) {
            return 281;
        }
        if (this.cmdArgumentState.isInState() && !RubyLexer.isLexState(state2, 32)) {
            return 282;
        }
        if (RubyLexer.isLexState(state2, 5)) {
            return 282;
        }
        return 280;
    }

    private int dollar() throws IOException {
        this.setState(2);
        this.newtok(true);
        int c = this.nextc();
        switch (c) {
            case 95: {
                c = this.nextc();
                if (this.isIdentifierChar(c)) {
                    if (!this.tokadd_ident(c)) {
                        return -1;
                    }
                    this.last_state = this.lex_state;
                    this.setState(2);
                    this.yaccValue = this.createTokenString().intern();
                    return 308;
                }
                this.pushback(c);
                c = 95;
            }
            case 33: 
            case 34: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 126: {
                this.yaccValue = "$" + (char)c;
                return 308;
            }
            case 45: {
                c = this.nextc();
                if (this.isIdentifierChar(c)) {
                    if (!this.tokadd_mbchar(c)) {
                        return -1;
                    }
                } else {
                    this.pushback(c);
                    this.pushback(45);
                    return 36;
                }
                this.yaccValue = this.createTokenString().intern();
                return 308;
            }
            case 38: 
            case 39: 
            case 43: 
            case 96: {
                if (RubyLexer.isLexState(this.last_state, 128)) {
                    this.yaccValue = "$" + (char)c;
                    return 308;
                }
                this.yaccValue = new BackRefNode(this.getPosition(), c);
                return 377;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int ref;
                while (Character.isDigit(c = this.nextc())) {
                }
                this.pushback(c);
                if (RubyLexer.isLexState(this.last_state, 128)) {
                    this.yaccValue = this.createTokenString().intern();
                    return 308;
                }
                String refAsString = this.createTokenString();
                try {
                    ref = Integer.parseInt(refAsString.substring(1).intern());
                }
                catch (NumberFormatException e) {
                    this.warnings.warn(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, "`" + refAsString + "' is too big for a number variable, always nil");
                    ref = 0;
                }
                this.yaccValue = new NthRefNode(this.getPosition(), ref);
                return 376;
            }
            case 48: {
                this.setState(2);
                return this.identifierToken(308, ("$" + (char)c).intern());
            }
        }
        if (!this.isIdentifierChar(c)) {
            if (c == -1 || Character.isSpaceChar(c)) {
                this.compile_error(SyntaxException.PID.CVAR_BAD_NAME, "`$' without identifiers is not allowed as a global variable name");
            } else {
                this.pushback(c);
                this.compile_error(SyntaxException.PID.CVAR_BAD_NAME, "`$" + (char)c + "' is not allowed as a global variable name");
            }
        }
        this.last_state = this.lex_state;
        this.setState(2);
        this.tokadd_ident(c);
        return this.identifierToken(308, this.createTokenString().intern());
    }

    private int dot() throws IOException {
        this.setState(1);
        int c = this.nextc();
        if (c == 46) {
            c = this.nextc();
            if (c == 46) {
                this.yaccValue = "...";
                return 330;
            }
            this.pushback(c);
            this.yaccValue = "..";
            return 329;
        }
        this.pushback(c);
        if (Character.isDigit(c)) {
            this.compile_error(SyntaxException.PID.FLOAT_MISSING_ZERO, "no .<digit> floating literal anymore; put 0 before dot");
        }
        this.setState(256);
        this.yaccValue = ".";
        return 328;
    }

    private int doubleQuote(boolean commandState) throws IOException {
        int label2 = this.isLabelPossible(commandState) ? 64 : 0;
        this.lex_strterm = new StringTerm(2 | label2, 0, 34);
        this.yaccValue = "\"";
        return 366;
    }

    private int greaterThan() throws IOException {
        this.setState(this.isAfterOperator() ? 16 : 1);
        int c = this.nextc();
        switch (c) {
            case 61: {
                this.yaccValue = ">=";
                return 322;
            }
            case 62: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = ">>";
                    return 338;
                }
                this.pushback(c);
                this.yaccValue = ">>";
                return 334;
            }
        }
        this.pushback(c);
        this.yaccValue = ">";
        return 358;
    }

    private int identifier(int c, boolean commandState) throws IOException {
        Keyword keyword;
        String tempVal;
        if (!this.isIdentifierChar(c)) {
            String badChar = "\\" + Integer.toOctalString(c & 0xFF);
            this.compile_error(SyntaxException.PID.CHARACTER_BAD, "Invalid char `" + badChar + "' ('" + (char)c + "') in expression");
        }
        this.newtok(true);
        do {
            if (this.tokadd_mbchar(c)) continue;
            return -1;
        } while (this.isIdentifierChar(c = this.nextc()));
        boolean lastBangOrPredicate = false;
        if (c == 33 || c == 63) {
            if (!this.peek(61)) {
                lastBangOrPredicate = true;
            } else {
                this.pushback(c);
            }
        } else {
            this.pushback(c);
        }
        int result2 = 0;
        this.last_state = this.lex_state;
        if (lastBangOrPredicate) {
            result2 = 307;
            tempVal = this.createTokenString();
        } else {
            if (RubyLexer.isLexState(this.lex_state, 128)) {
                c = this.nextc();
                if (c == 61) {
                    int c2 = this.nextc();
                    if (c2 != 126 && c2 != 62 && (c2 != 61 || this.peek(62))) {
                        result2 = 306;
                        this.pushback(c2);
                    } else {
                        this.pushback(c2);
                        this.pushback(c);
                    }
                } else {
                    this.pushback(c);
                }
            }
            tempVal = this.createTokenString();
            result2 = result2 == 0 && Character.isUpperCase(tempVal.charAt(0)) ? 310 : 306;
        }
        if (this.isLabelPossible(commandState) && this.isLabelSuffix()) {
            this.setState(2064);
            this.nextc();
            this.yaccValue = tempVal.intern();
            return 312;
        }
        if (this.lex_state != 256 && (keyword = RubyLexer.getKeyword(tempVal)) != null) {
            int state2 = this.lex_state;
            this.setState(keyword.state);
            if (RubyLexer.isLexState(state2, 128)) {
                this.yaccValue = keyword.name;
                return keyword.id0;
            }
            this.yaccValue = this.getPosition();
            if (RubyLexer.isLexState(this.lex_state, 1)) {
                this.commandStart = true;
            }
            if (keyword.id0 == 280) {
                return this.doKeyword(state2);
            }
            if (RubyLexer.isLexState(state2, 2049)) {
                return keyword.id0;
            }
            if (keyword.id0 != keyword.id1) {
                this.setState(1025);
            }
            return keyword.id1;
        }
        if (RubyLexer.isLexState(this.lex_state, 881)) {
            this.setState(commandState ? 32 : 16);
        } else if (this.lex_state == 128) {
            this.setState(8);
        } else {
            this.setState(2);
        }
        return this.identifierToken(result2, tempVal.intern());
    }

    private int leftBracket(boolean spaceSeen) throws IOException {
        ++this.parenNest;
        int c = 91;
        if (this.isAfterOperator()) {
            this.setState(16);
            c = this.nextc();
            if (c == 93) {
                if (this.peek(61)) {
                    this.nextc();
                    this.yaccValue = "[]=";
                    return 332;
                }
                this.yaccValue = "[]";
                return 331;
            }
            this.pushback(c);
            this.setState(this.getState() | 0x400);
            this.yaccValue = "[";
            return 91;
        }
        if (this.isBEG() || this.isARG() && (spaceSeen || RubyLexer.isLexState(this.lex_state, 2048))) {
            c = 344;
        }
        this.setState(1025);
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.yaccValue = "[";
        return c;
    }

    private int leftCurly() {
        ++this.braceNest;
        int leftParenBegin = this.getLeftParenBegin();
        if (leftParenBegin > 0 && leftParenBegin == this.parenNest) {
            this.setState(1);
            this.setLeftParenBegin(0);
            --this.parenNest;
            this.conditionState.stop();
            this.cmdArgumentState.stop();
            this.yaccValue = "{";
            return 375;
        }
        int c = RubyLexer.isLexState(this.lex_state, 2048) ? 346 : (RubyLexer.isLexState(this.lex_state, 58) ? 362 : (RubyLexer.isLexState(this.lex_state, 4) ? 347 : 346));
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.setState(1);
        if (c != 347) {
            this.setState(this.getState() | 0x400);
        }
        if (c != 346) {
            this.commandStart = true;
        }
        this.yaccValue = this.getPosition();
        return c;
    }

    private int leftParen(boolean spaceSeen) throws IOException {
        int result2 = this.isBEG() ? 340 : (this.isSpaceArg(40, spaceSeen) ? 343 : 341);
        ++this.parenNest;
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.setState(1025);
        this.yaccValue = this.getPosition();
        return result2;
    }

    private int lessThan(boolean spaceSeen) throws IOException {
        int tok;
        this.last_state = this.lex_state;
        int c = this.nextc();
        if (!(c != 60 || RubyLexer.isLexState(this.lex_state, 768) || this.isEND() || this.isARG() && !RubyLexer.isLexState(this.lex_state, 2048) && !spaceSeen || (tok = this.hereDocumentIdentifier()) == 0)) {
            return tok;
        }
        if (this.isAfterOperator()) {
            this.setState(16);
        } else {
            if (RubyLexer.isLexState(this.lex_state, 512)) {
                this.commandStart = true;
            }
            this.setState(1);
        }
        switch (c) {
            case 61: {
                c = this.nextc();
                if (c == 62) {
                    this.yaccValue = "<=>";
                    return 318;
                }
                this.pushback(c);
                this.yaccValue = "<=";
                return 323;
            }
            case 60: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = "<<";
                    return 338;
                }
                this.pushback(c);
                this.yaccValue = "<<";
                this.warn_balanced(c, spaceSeen, "<<", "here document");
                return 333;
            }
        }
        this.yaccValue = "<";
        this.pushback(c);
        return 357;
    }

    private int minus(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        if (this.isAfterOperator()) {
            this.setState(16);
            if (c == 64) {
                this.yaccValue = "-@";
                return 315;
            }
            this.pushback(c);
            this.yaccValue = "-";
            return 356;
        }
        if (c == 61) {
            this.setState(1);
            this.yaccValue = "-";
            return 338;
        }
        if (c == 62) {
            this.setState(8);
            this.yaccValue = "->";
            return 374;
        }
        if (this.isBEG() || this.isSpaceArg(c, spaceSeen) && this.arg_ambiguous()) {
            this.setState(1);
            this.pushback(c);
            this.yaccValue = "-";
            if (Character.isDigit(c)) {
                return 316;
            }
            return 315;
        }
        this.setState(1);
        this.pushback(c);
        this.yaccValue = "-";
        this.warn_balanced(c, spaceSeen, "-", "unary operator");
        return 356;
    }

    private int percent(boolean spaceSeen) throws IOException {
        if (this.isBEG()) {
            return this.parseQuote(this.nextc());
        }
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            this.yaccValue = "%";
            return 338;
        }
        if (this.isSpaceArg(c, spaceSeen)) {
            return this.parseQuote(c);
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.pushback(c);
        this.yaccValue = "%";
        this.warn_balanced(c, spaceSeen, "%", "string literal");
        return 353;
    }

    private int pipe() throws IOException {
        int c = this.nextc();
        switch (c) {
            case 124: {
                this.setState(1);
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = "||";
                    return 338;
                }
                this.pushback(c);
                this.yaccValue = "||";
                return 325;
            }
            case 61: {
                this.setState(1);
                this.yaccValue = "|";
                return 338;
            }
        }
        this.setState(this.isAfterOperator() ? 16 : 1025);
        this.pushback(c);
        this.yaccValue = "|";
        return 359;
    }

    private int plus(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        if (this.isAfterOperator()) {
            this.setState(16);
            if (c == 64) {
                this.yaccValue = "+@";
                return 314;
            }
            this.pushback(c);
            this.yaccValue = "+";
            return 355;
        }
        if (c == 61) {
            this.setState(1);
            this.yaccValue = "+";
            return 338;
        }
        if (this.isBEG() || this.isSpaceArg(c, spaceSeen) && this.arg_ambiguous()) {
            this.setState(1);
            this.pushback(c);
            if (Character.isDigit(c)) {
                c = 43;
                return this.parseNumber(c);
            }
            this.yaccValue = "+";
            return 314;
        }
        this.setState(1);
        this.pushback(c);
        this.yaccValue = "+";
        this.warn_balanced(c, spaceSeen, "+", "unary operator");
        return 355;
    }

    private int questionMark() throws IOException {
        if (this.isEND()) {
            this.setState(1);
            this.yaccValue = "?";
            return 63;
        }
        int c = this.nextc();
        if (c == -1) {
            this.compile_error(SyntaxException.PID.INCOMPLETE_CHAR_SYNTAX, "incomplete character syntax");
        }
        if (Character.isWhitespace(c)) {
            if (!this.isARG()) {
                int c2 = 0;
                switch (c) {
                    case 32: {
                        c2 = 115;
                        break;
                    }
                    case 10: {
                        c2 = 110;
                        break;
                    }
                    case 9: {
                        c2 = 116;
                        break;
                    }
                    case 13: {
                        c2 = 114;
                        break;
                    }
                    case 12: {
                        c2 = 102;
                    }
                }
                if (c2 != 0) {
                    this.warnings.warn(IRubyWarnings.ID.INVALID_CHAR_SEQUENCE, this.getPosition(), "invalid character syntax; use ?\\" + c2);
                }
            }
            this.pushback(c);
            this.setState(1);
            this.yaccValue = "?";
            return 63;
        }
        if (!this.isASCII(c)) {
            if (!this.tokadd_mbchar(c)) {
                return -1;
            }
        } else {
            if (this.isIdentifierChar(c) && !this.peek(10) && this.isNext_identchar()) {
                this.newtok(true);
                this.pushback(c);
                this.setState(1);
                this.yaccValue = "?";
                return 63;
            }
            if (c == 92) {
                if (this.peek(117)) {
                    this.nextc();
                    ByteList oneCharBL = new ByteList(2);
                    oneCharBL.setEncoding(this.getEncoding());
                    c = this.readUTFEscape(oneCharBL, false, false);
                    if (c >= 128) {
                        this.tokaddmbc(c, oneCharBL);
                    } else {
                        oneCharBL.append(c);
                    }
                    this.setState(2);
                    this.yaccValue = new StrNode(this.getPosition(), oneCharBL);
                    return 313;
                }
                c = this.readEscape();
            } else {
                this.newtok(true);
            }
        }
        ByteList oneCharBL = new ByteList(1);
        oneCharBL.append(c);
        this.yaccValue = new StrNode(this.getPosition(), oneCharBL);
        this.setState(2);
        return 313;
    }

    private int rightBracket() {
        --this.parenNest;
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(4);
        this.yaccValue = "]";
        return 345;
    }

    private int rightCurly() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(4);
        this.yaccValue = "}";
        int tok = this.braceNest == 0 ? 387 : 363;
        --this.braceNest;
        return tok;
    }

    private int rightParen() {
        --this.parenNest;
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.setState(8);
        this.yaccValue = ")";
        return 342;
    }

    private int singleQuote(boolean commandState) throws IOException {
        int label2 = this.isLabelPossible(commandState) ? 64 : 0;
        this.lex_strterm = new StringTerm(0 | label2, 0, 39);
        this.yaccValue = "'";
        return 366;
    }

    private int slash(boolean spaceSeen) throws IOException {
        if (this.isBEG()) {
            this.lex_strterm = new StringTerm(7, 0, 47);
            this.yaccValue = "/";
            return 368;
        }
        int c = this.nextc();
        if (c == 61) {
            this.setState(1);
            this.yaccValue = "/";
            return 338;
        }
        this.pushback(c);
        if (this.isSpaceArg(c, spaceSeen)) {
            this.arg_ambiguous();
            this.lex_strterm = new StringTerm(7, 0, 47);
            this.yaccValue = "/";
            return 368;
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        this.yaccValue = "/";
        this.warn_balanced(c, spaceSeen, "/", "regexp literal");
        return 354;
    }

    private int star(boolean spaceSeen) throws IOException {
        int c = this.nextc();
        switch (c) {
            case 42: {
                c = this.nextc();
                if (c == 61) {
                    this.setState(1);
                    this.yaccValue = "**";
                    return 338;
                }
                this.pushback(c);
                this.yaccValue = "**";
                if (this.isSpaceArg(c, spaceSeen)) {
                    if (this.warnings.isVerbose() && Options.PARSER_WARN_ARGUMENT_PREFIX.load().booleanValue()) {
                        this.warnings.warning(IRubyWarnings.ID.ARGUMENT_AS_PREFIX, this.getPosition(), "`**' interpreted as argument prefix");
                    }
                    c = 386;
                    break;
                }
                if (this.isBEG()) {
                    c = 386;
                    break;
                }
                this.warn_balanced(c, spaceSeen, "**", "argument prefix");
                c = 317;
                break;
            }
            case 61: {
                this.setState(1);
                this.yaccValue = "*";
                return 338;
            }
            default: {
                this.pushback(c);
                if (this.isSpaceArg(c, spaceSeen)) {
                    if (this.warnings.isVerbose() && Options.PARSER_WARN_ARGUMENT_PREFIX.load().booleanValue() && !ParserSupport.skipTruffleRubiniusWarnings(this)) {
                        this.warnings.warning(IRubyWarnings.ID.ARGUMENT_AS_PREFIX, this.getPosition(), "`*' interpreted as argument prefix");
                    }
                    c = 348;
                } else if (this.isBEG()) {
                    c = 348;
                } else {
                    this.warn_balanced(c, spaceSeen, "*", "argument prefix");
                    c = 349;
                }
                this.yaccValue = "*";
            }
        }
        this.setState(this.isAfterOperator() ? 16 : 1);
        return c;
    }

    private int tilde() throws IOException {
        if (this.isAfterOperator()) {
            int c = this.nextc();
            if (c != 64) {
                this.pushback(c);
            }
            this.setState(16);
        } else {
            this.setState(1);
        }
        this.yaccValue = "~";
        return 352;
    }

    private int parseNumber(int c) throws IOException {
        this.setState(2);
        this.newtok(true);
        this.numberBuffer.setRealSize(0);
        if (c == 45) {
            this.numberBuffer.append((char)c);
            c = this.nextc();
        } else if (c == 43) {
            c = this.nextc();
        }
        int nondigit = 0;
        if (c == 48) {
            int startLen = this.numberBuffer.length();
            c = this.nextc();
            switch (c) {
                case 88: 
                case 120: {
                    c = this.nextc();
                    if (RubyLexer.isHexChar(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!RubyLexer.isHexChar(c)) break;
                                nondigit = 0;
                                this.numberBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.length() == startLen) {
                        this.compile_error(SyntaxException.PID.BAD_HEX_NUMBER, "Hexadecimal number without hex-digits.");
                    } else if (nondigit != 0) {
                        this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                    }
                    return this.getIntegerToken(this.numberBuffer.toString(), 16, this.numberLiteralSuffix(3));
                }
                case 66: 
                case 98: {
                    c = this.nextc();
                    if (c == 48 || c == 49) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (c != 48 && c != 49) break;
                                nondigit = 0;
                                this.numberBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.length() == startLen) {
                        this.compile_error(SyntaxException.PID.EMPTY_BINARY_NUMBER, "Binary number without digits.");
                    } else if (nondigit != 0) {
                        this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                    }
                    return this.getIntegerToken(this.numberBuffer.toString(), 2, this.numberLiteralSuffix(3));
                }
                case 68: 
                case 100: {
                    c = this.nextc();
                    if (Character.isDigit(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!Character.isDigit(c)) break;
                                nondigit = 0;
                                this.numberBuffer.append((char)c);
                            }
                            c = this.nextc();
                        }
                    }
                    this.pushback(c);
                    if (this.numberBuffer.length() == startLen) {
                        this.compile_error(SyntaxException.PID.EMPTY_BINARY_NUMBER, "Binary number without digits.");
                    } else if (nondigit != 0) {
                        this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                    }
                    return this.getIntegerToken(this.numberBuffer.toString(), 10, this.numberLiteralSuffix(3));
                }
                case 79: 
                case 111: {
                    c = this.nextc();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 95: {
                    while (true) {
                        if (c == 95) {
                            if (nondigit != 0) break;
                            nondigit = c;
                        } else {
                            if (c < 48 || c > 55) break;
                            nondigit = 0;
                            this.numberBuffer.append((char)c);
                        }
                        c = this.nextc();
                    }
                    if (this.numberBuffer.length() > startLen) {
                        this.pushback(c);
                        if (nondigit != 0) {
                            this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                        }
                        return this.getIntegerToken(this.numberBuffer.toString(), 8, this.numberLiteralSuffix(3));
                    }
                }
                case 56: 
                case 57: {
                    this.compile_error(SyntaxException.PID.BAD_OCTAL_DIGIT, "Illegal octal digit.");
                }
                case 46: 
                case 69: 
                case 101: {
                    this.numberBuffer.append(48);
                    break;
                }
                default: {
                    this.pushback(c);
                    this.numberBuffer.append(48);
                    return this.getIntegerToken(this.numberBuffer.toString(), 10, this.numberLiteralSuffix(3));
                }
            }
        }
        boolean seen_point = false;
        boolean seen_e = false;
        while (true) {
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    nondigit = 0;
                    this.numberBuffer.append((char)c);
                    break;
                }
                case 46: {
                    if (nondigit != 0) {
                        this.pushback(c);
                        this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                        break;
                    }
                    if (seen_point || seen_e) {
                        this.pushback(c);
                        return this.getNumberToken(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    int c2 = this.nextc();
                    if (!Character.isDigit(c2)) {
                        this.pushback(c2);
                        this.pushback(46);
                        if (c == 95) break;
                        return this.getIntegerToken(this.numberBuffer.toString(), 10, this.numberLiteralSuffix(3));
                    }
                    this.numberBuffer.append(46);
                    this.numberBuffer.append((char)c2);
                    seen_point = true;
                    nondigit = 0;
                    break;
                }
                case 69: 
                case 101: {
                    if (nondigit != 0) {
                        this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                        break;
                    }
                    if (seen_e) {
                        this.pushback(c);
                        return this.getNumberToken(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                    }
                    this.numberBuffer.append((char)c);
                    seen_e = true;
                    nondigit = c;
                    c = this.nextc();
                    if (c == 45 || c == 43) {
                        this.numberBuffer.append((char)c);
                        nondigit = c;
                        break;
                    }
                    this.pushback(c);
                    break;
                }
                case 95: {
                    if (nondigit != 0) {
                        this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
                    }
                    nondigit = c;
                    break;
                }
                default: {
                    this.pushback(c);
                    return this.getNumberToken(this.numberBuffer.toString(), seen_e, seen_point, nondigit);
                }
            }
            c = this.nextc();
        }
    }

    private int getNumberToken(String number, boolean seen_e, boolean seen_point, int nondigit) throws IOException {
        boolean isFloat;
        boolean bl = isFloat = seen_e || seen_point;
        if (nondigit != 0) {
            this.compile_error(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, "Trailing '_' in number.");
        } else if (isFloat) {
            int suffix = this.numberLiteralSuffix(seen_e ? 2 : 3);
            return this.getFloatToken(number, suffix);
        }
        return this.getIntegerToken(number, 10, this.numberLiteralSuffix(3));
    }

    public void readUTFEscapeRegexpLiteral(ByteList buffer) throws IOException {
        buffer.append(92);
        buffer.append(117);
        if (this.peek(123)) {
            do {
                buffer.append(this.nextc());
                if (this.scanHexLiteral(buffer, 6, false, "invalid Unicode escape") <= '\u10ffff') continue;
                this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "invalid Unicode codepoint (too large)");
            } while (this.peek(32) || this.peek(9));
            int c = this.nextc();
            if (c != 125) {
                this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "unterminated Unicode escape");
            }
            buffer.append((char)c);
        } else {
            this.scanHexLiteral(buffer, 4, true, "Invalid Unicode escape");
        }
    }

    public int readUTFEscape(ByteList buffer, boolean stringLiteral, boolean symbolLiteral) throws IOException {
        int codepoint;
        if (this.peek(123)) {
            do {
                this.nextc();
                codepoint = this.scanHex(6, false, "invalid Unicode escape");
                if (codepoint > 0x10FFFF) {
                    this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "invalid Unicode codepoint (too large)");
                }
                if (buffer == null) continue;
                this.readUTF8EscapeIntoBuffer(codepoint, buffer, stringLiteral);
            } while (this.peek(32) || this.peek(9));
            int c = this.nextc();
            if (c != 125) {
                this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "unterminated Unicode escape");
            }
        } else {
            codepoint = this.scanHex(4, true, "Invalid Unicode escape");
            if (buffer != null) {
                this.readUTF8EscapeIntoBuffer(codepoint, buffer, stringLiteral);
            }
        }
        return codepoint;
    }

    private void readUTF8EscapeIntoBuffer(int codepoint, ByteList buffer, boolean stringLiteral) throws IOException {
        if (codepoint >= 128) {
            buffer.setEncoding(UTF8_ENCODING);
            if (stringLiteral) {
                this.tokaddmbc(codepoint, buffer);
            }
        } else if (stringLiteral) {
            buffer.append((char)codepoint);
        }
    }

    public int readEscape() throws IOException {
        int c = this.nextc();
        switch (c) {
            case 92: {
                return c;
            }
            case 110: {
                return 10;
            }
            case 116: {
                return 9;
            }
            case 114: {
                return 13;
            }
            case 102: {
                return 12;
            }
            case 118: {
                return 11;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.pushback(c);
                return this.scanOct(3);
            }
            case 120: {
                return this.scanHex(2, false, "Invalid escape character syntax");
            }
            case 98: {
                return 8;
            }
            case 115: {
                return 32;
            }
            case 77: {
                c = this.nextc();
                if (c != 45) {
                    this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "Invalid escape character syntax");
                } else {
                    c = this.nextc();
                    if (c == 92) {
                        return (char)(this.readEscape() | 0x80);
                    }
                    if (c == -1) {
                        this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "Invalid escape character syntax");
                    }
                }
                return (char)(c & 0xFF | 0x80);
            }
            case 67: {
                if (this.nextc() != 45) {
                    this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "Invalid escape character syntax");
                }
            }
            case 99: {
                c = this.nextc();
                if (c == 92) {
                    c = this.readEscape();
                } else {
                    if (c == 63) {
                        return 127;
                    }
                    if (c == -1) {
                        this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "Invalid escape character syntax");
                    }
                }
                return (char)(c & 0x9F);
            }
            case -1: {
                this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, "Invalid escape character syntax");
            }
        }
        return c;
    }

    private char scanHexLiteral(ByteList buffer, int count2, boolean strict, String errorMessage) throws IOException {
        int i2;
        char hexValue = '\u0000';
        for (i2 = 0; i2 < count2; ++i2) {
            int h1 = this.nextc();
            if (!RubyLexer.isHexChar(h1)) {
                this.pushback(h1);
                break;
            }
            buffer.append(h1);
            hexValue = (char)(hexValue << 4);
            hexValue = (char)(hexValue | Integer.parseInt(String.valueOf((char)h1), 16) & 0xF);
        }
        if (i2 == 0 || strict && count2 != i2) {
            this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, errorMessage);
        }
        return hexValue;
    }

    private int scanHex(int count2, boolean strict, String errorMessage) throws IOException {
        int i2;
        int hexValue = 0;
        for (i2 = 0; i2 < count2; ++i2) {
            int h1 = this.nextc();
            if (!RubyLexer.isHexChar(h1)) {
                this.pushback(h1);
                break;
            }
            hexValue <<= 4;
            hexValue |= Integer.parseInt("" + (char)h1, 16) & 0xF;
        }
        if (i2 == 0 || strict && count2 != i2) {
            this.compile_error(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, errorMessage);
        }
        return hexValue;
    }

    static {
        map.put("end", Keyword.END);
        map.put("else", Keyword.ELSE);
        map.put("case", Keyword.CASE);
        map.put("ensure", Keyword.ENSURE);
        map.put("module", Keyword.MODULE);
        map.put("elsif", Keyword.ELSIF);
        map.put("def", Keyword.DEF);
        map.put("rescue", Keyword.RESCUE);
        map.put("not", Keyword.NOT);
        map.put("then", Keyword.THEN);
        map.put("yield", Keyword.YIELD);
        map.put("for", Keyword.FOR);
        map.put("self", Keyword.SELF);
        map.put("false", Keyword.FALSE);
        map.put("retry", Keyword.RETRY);
        map.put("return", Keyword.RETURN);
        map.put("true", Keyword.TRUE);
        map.put("if", Keyword.IF);
        map.put("defined?", Keyword.DEFINED_P);
        map.put("super", Keyword.SUPER);
        map.put("undef", Keyword.UNDEF);
        map.put("break", Keyword.BREAK);
        map.put("in", Keyword.IN);
        map.put("do", Keyword.DO);
        map.put("nil", Keyword.NIL);
        map.put("until", Keyword.UNTIL);
        map.put("unless", Keyword.UNLESS);
        map.put("or", Keyword.OR);
        map.put("next", Keyword.NEXT);
        map.put("when", Keyword.WHEN);
        map.put("redo", Keyword.REDO);
        map.put("and", Keyword.AND);
        map.put("begin", Keyword.BEGIN);
        map.put("__LINE__", Keyword.__LINE__);
        map.put("class", Keyword.CLASS);
        map.put("__FILE__", Keyword.__FILE__);
        map.put("END", Keyword.LEND);
        map.put("BEGIN", Keyword.LBEGIN);
        map.put("while", Keyword.WHILE);
        map.put("alias", Keyword.ALIAS);
        map.put("__ENCODING__", Keyword.__ENCODING__);
    }

    public static enum Keyword {
        END("end", 264, 264, 2),
        ELSE("else", 269, 269, 1),
        CASE("case", 270, 270, 1),
        ENSURE("ensure", 263, 263, 1),
        MODULE("module", 258, 258, 1),
        ELSIF("elsif", 268, 268, 1),
        DEF("def", 259, 259, 128),
        RESCUE("rescue", 262, 297, 64),
        NOT("not", 292, 292, 16),
        THEN("then", 267, 267, 1),
        YIELD("yield", 284, 284, 16),
        FOR("for", 274, 274, 1),
        SELF("self", 286, 286, 2),
        FALSE("false", 289, 289, 2),
        RETRY("retry", 278, 278, 2),
        RETURN("return", 283, 283, 64),
        TRUE("true", 288, 288, 2),
        IF("if", 265, 293, 1),
        DEFINED_P("defined?", 299, 299, 16),
        SUPER("super", 285, 285, 16),
        UNDEF("undef", 260, 260, 128),
        BREAK("break", 275, 275, 64),
        IN("in", 279, 279, 1),
        DO("do", 280, 280, 1),
        NIL("nil", 287, 287, 2),
        UNTIL("until", 273, 296, 1),
        UNLESS("unless", 266, 294, 1),
        OR("or", 291, 291, 1),
        NEXT("next", 276, 276, 64),
        WHEN("when", 271, 271, 1),
        REDO("redo", 277, 277, 2),
        AND("and", 290, 290, 1),
        BEGIN("begin", 261, 261, 1),
        __LINE__("__LINE__", 302, 302, 2),
        CLASS("class", 257, 257, 512),
        __FILE__("__FILE__", 303, 303, 2),
        LEND("END", 301, 301, 2),
        LBEGIN("BEGIN", 300, 300, 2),
        WHILE("while", 272, 295, 1),
        ALIAS("alias", 298, 298, 128),
        __ENCODING__("__ENCODING__", 304, 304, 2);

        public final String name;
        public final int id0;
        public final int id1;
        public final int state;

        private Keyword(String name2, int id0, int id1, int state2) {
            this.name = name2;
            this.id0 = id0;
            this.id1 = id1;
            this.state = state2;
        }
    }
}

