/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.constants;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;

public class WriteConstantNode
extends RubyNode {
    private final String name;
    @Node.Child
    private RubyNode moduleNode;
    @Node.Child
    private RubyNode valueNode;
    private final ConditionProfile moduleProfile = ConditionProfile.createBinaryProfile();

    public WriteConstantNode(String name, RubyNode moduleNode, RubyNode valueNode) {
        this.name = name;
        this.moduleNode = moduleNode;
        this.valueNode = valueNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value = this.valueNode.execute(frame);
        Object moduleObject = this.moduleNode.execute(frame);
        if (!this.moduleProfile.profile(RubyGuards.isRubyModule(moduleObject))) {
            throw new RaiseException(this.coreExceptions().typeErrorIsNotAClassModule(moduleObject, this));
        }
        Layouts.MODULE.getFields((DynamicObject)moduleObject).setConstant(this.getContext(), this, this.name, value);
        return value;
    }
}

