/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.IsFrozenNode;
import org.jruby.truffle.language.objects.IsFrozenNodeGen;
import org.jruby.truffle.language.objects.IsTaintedNode;
import org.jruby.truffle.language.objects.IsTaintedNodeGen;
import org.jruby.truffle.language.objects.WriteObjectFieldNode;
import org.jruby.truffle.language.objects.WriteObjectFieldNodeGen;

@NodeChild(value="child", type=RubyNode.class)
public abstract class TaintNode
extends RubyNode {
    @Node.Child
    private IsFrozenNode isFrozenNode;
    @Node.Child
    private IsTaintedNode isTaintedNode;

    public TaintNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeTaint(Object var1);

    @Specialization
    public Object taint(boolean object) {
        return object;
    }

    @Specialization
    public Object taint(int object) {
        return object;
    }

    @Specialization
    public Object taint(long object) {
        return object;
    }

    @Specialization
    public Object taint(double object) {
        return object;
    }

    @Specialization(guards={"isRubySymbol(object) || isNil(object)"})
    public Object taintNilOrSymbol(DynamicObject object) {
        return object;
    }

    @Specialization(guards={"!isRubySymbol(object)", "!isNil(object)"})
    public Object taint(DynamicObject object, @Cached(value="createWriteTaintNode()") WriteObjectFieldNode writeTaintNode) {
        if (this.isTaintedNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isTaintedNode = this.insert(IsTaintedNodeGen.create(this.getContext(), this.getSourceSection(), null));
        }
        if (!this.isTaintedNode.executeIsTainted(object)) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isFrozenNode = this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if (this.isFrozenNode.executeIsFrozen(object)) {
                throw new RaiseException(this.coreExceptions().frozenError(object, this));
            }
        }
        writeTaintNode.execute(object, true);
        return object;
    }

    protected WriteObjectFieldNode createWriteTaintNode() {
        return WriteObjectFieldNodeGen.create(Layouts.TAINTED_IDENTIFIER);
    }
}

