/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterListElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.ParameterListElement");
    private static final TokenSet PARAMETER_SET = TokenSet.create(JavaElementType.PARAMETER, JavaElementType.RECEIVER_PARAMETER);

    public ParameterListElement() {
        super(PARAMETER_LIST);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor2, Boolean before) {
        if (anchor2 == null) {
            if (before == null || before.booleanValue()) {
                anchor2 = this.findChildByRole(25);
                before = Boolean.TRUE;
            } else {
                anchor2 = this.findChildByRole(24);
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor2, before);
        if (first == last && PARAMETER_SET.contains(first.getElementType())) {
            JavaSourceUtil.addSeparatingComma(this, first, PARAMETER_SET);
        }
        try {
            CodeStyleManager.getInstance(this.getManager().getProject()).reformat(this.getPsi());
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        TreeElement newFirstNodeInsideParens;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/tree/java/ParameterListElement", "deleteChildInternal"));
        }
        TreeElement oldLastNodeInsideParens = this.getLastNodeInsideParens();
        TreeElement oldFirstNodeInsideParens = this.getFirstNodeInsideParens();
        if (PARAMETER_SET.contains(child.getElementType())) {
            JavaSourceUtil.deleteSeparatingComma(this, child);
        }
        super.deleteChildInternal(child);
        TreeElement newLastNodeInsideParens = this.getLastNodeInsideParens();
        if (newLastNodeInsideParens != null && oldLastNodeInsideParens != null && newLastNodeInsideParens.getElementType() == WHITE_SPACE) {
            if (oldLastNodeInsideParens.getElementType() != WHITE_SPACE) {
                this.deleteChildInternal(newLastNodeInsideParens);
            } else {
                this.replaceChild(newLastNodeInsideParens, (ASTNode)oldLastNodeInsideParens.clone());
            }
        }
        if ((newFirstNodeInsideParens = this.getFirstNodeInsideParens()) != null && newFirstNodeInsideParens.getElementType() == WHITE_SPACE) {
            if (oldFirstNodeInsideParens == null || oldFirstNodeInsideParens.getElementType() != WHITE_SPACE) {
                this.deleteChildInternal(newFirstNodeInsideParens);
            } else {
                this.replaceChild(newFirstNodeInsideParens, (ASTNode)oldFirstNodeInsideParens.clone());
            }
        }
        try {
            CodeStyleManager.getInstance(this.getManager().getProject()).reformat(this.getPsi());
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 24: {
                TreeElement firstNode = this.getFirstChildNode();
                return firstNode.getElementType() == LPARENTH ? firstNode : null;
            }
            case 25: 
        }
        TreeElement lastNode = this.getLastChildNode();
        return lastNode.getElementType() == RPARENTH ? lastNode : null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (PARAMETER_SET.contains(i)) {
            return 15;
        }
        if (i == COMMA) {
            return 23;
        }
        if (i == LPARENTH) {
            return this.getChildRole(child, 24);
        }
        if (i == RPARENTH) {
            return this.getChildRole(child, 25);
        }
        return 0;
    }

    @Nullable
    private TreeElement getLastNodeInsideParens() {
        TreeElement lastNode = this.getLastChildNode();
        return lastNode.getElementType() == RPARENTH ? lastNode.getTreePrev() : null;
    }

    @Nullable
    private TreeElement getFirstNodeInsideParens() {
        TreeElement firstNode = this.getFirstChildNode();
        return firstNode.getElementType() == LPARENTH ? firstNode.getTreeNext() : null;
    }
}

