/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedQualifiedTypeReference
extends ArrayQualifiedTypeReference {
    public TypeReference[][] typeArguments;

    public ParameterizedQualifiedTypeReference(char[][] cArray, TypeReference[][] typeReferenceArray, int n, long[] lArray) {
        super(cArray, n, lArray);
        this.typeArguments = typeReferenceArray;
        block0: for (TypeReference[] typeReferenceArray2 : typeReferenceArray) {
            if (typeReferenceArray2 == null) continue;
            int n2 = typeReferenceArray2.length;
            for (int i = 0; i < n2; ++i) {
                if ((typeReferenceArray2[i].bits & 0x100000) == 0) continue;
                this.bits |= 0x100000;
                break block0;
            }
        }
    }

    public ParameterizedQualifiedTypeReference(char[][] cArray, TypeReference[][] typeReferenceArray, int n, Annotation[][] annotationArray, long[] lArray) {
        this(cArray, typeReferenceArray, n, lArray);
        this.setAnnotationsOnDimensions(annotationArray);
        if (annotationArray != null) {
            this.bits |= 0x100000;
        }
    }

    @Override
    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        this.checkBounds((ReferenceBinding)this.resolvedType.leafComponentType(), scope, this.typeArguments.length - 1);
    }

    public void checkBounds(ReferenceBinding referenceBinding, Scope scope, int n) {
        ParameterizedTypeBinding parameterizedTypeBinding;
        ReferenceBinding referenceBinding2;
        TypeVariableBinding[] typeVariableBindingArray;
        if (n > 0 && referenceBinding.enclosingType() != null) {
            this.checkBounds(referenceBinding.enclosingType(), scope, n - 1);
        }
        if (referenceBinding.isParameterizedTypeWithActualArguments() && (typeVariableBindingArray = (referenceBinding2 = (parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding).genericType()).typeVariables()) != null) {
            parameterizedTypeBinding.boundCheck(scope, this.typeArguments[n]);
        }
    }

    @Override
    public TypeReference augmentTypeWithAdditionalDimensions(int n, Annotation[][] annotationArray, boolean bl) {
        int n2 = this.dimensions() + n;
        Annotation[][] annotationArray2 = this.getMergedAnnotationsOnDimensions(n, annotationArray);
        ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference = new ParameterizedQualifiedTypeReference(this.tokens, this.typeArguments, n2, annotationArray2, this.sourcePositions);
        parameterizedQualifiedTypeReference.annotations = this.annotations;
        parameterizedQualifiedTypeReference.bits |= this.bits & 0x100000;
        if (!bl) {
            parameterizedQualifiedTypeReference.extendedDimensions = n;
        }
        return parameterizedQualifiedTypeReference;
    }

    @Override
    public boolean isParameterizedTypeReference() {
        return true;
    }

    @Override
    public boolean hasNullTypeAnnotation(TypeReference.AnnotationPosition annotationPosition) {
        if (super.hasNullTypeAnnotation(annotationPosition)) {
            return true;
        }
        if (annotationPosition == TypeReference.AnnotationPosition.ANY) {
            if (this.resolvedType != null && !this.resolvedType.hasNullTypeAnnotations()) {
                return false;
            }
            if (this.typeArguments != null) {
                for (int i = 0; i < this.typeArguments.length; ++i) {
                    TypeReference[] typeReferenceArray = this.typeArguments[i];
                    if (typeReferenceArray == null) continue;
                    for (int j = 0; j < typeReferenceArray.length; ++j) {
                        if (!typeReferenceArray[j].hasNullTypeAnnotation(annotationPosition)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public char[][] getParameterizedTypeName() {
        int n;
        Object[] objectArray;
        int n2;
        int n3 = this.tokens.length;
        char[][] cArrayArray = new char[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray = this.typeArguments[n2];
            if (objectArray == null) {
                cArrayArray[n2] = this.tokens[n2];
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(5);
            stringBuffer.append(this.tokens[n2]);
            stringBuffer.append('<');
            int n4 = objectArray.length;
            for (n = 0; n < n4; ++n) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(CharOperation.concatWith(objectArray[n].getParameterizedTypeName(), '.'));
            }
            stringBuffer.append('>');
            n = stringBuffer.length();
            cArrayArray[n2] = new char[n];
            stringBuffer.getChars(0, n, cArrayArray[n2], 0);
        }
        n2 = this.dimensions;
        if (n2 > 0) {
            objectArray = new char[n2 * 2];
            for (int i = 0; i < n2; ++i) {
                n = i * 2;
                objectArray[n] = (TypeReference)91;
                objectArray[n + 1] = (TypeReference)93;
            }
            cArrayArray[n3 - 1] = CharOperation.concat(cArrayArray[n3 - 1], (char[])objectArray);
        }
        return cArrayArray;
    }

    @Override
    public TypeReference[][] getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, boolean bl, int n) {
        this.constant = Constant.NotAConstant;
        if ((this.bits & 0x40000) != 0 && this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    TypeBinding typeBinding = this.resolvedType.closestMatch();
                    return typeBinding;
                }
            }
            return null;
        }
        this.bits |= 0x40000;
        TypeBinding typeBinding = this.internalResolveLeafType(scope, bl);
        this.createArrayType(scope);
        this.resolveAnnotations(scope, n);
        if (this.typeArguments != null) {
            this.checkIllegalNullAnnotations(scope, this.typeArguments[this.typeArguments.length - 1]);
        }
        return typeBinding == null ? typeBinding : this.resolvedType;
    }

    private TypeBinding internalResolveLeafType(Scope scope, boolean bl) {
        boolean bl2 = scope.kind == 3;
        Binding binding = scope.getPackage(this.tokens);
        if (binding != null && !binding.isValidBinding()) {
            this.resolvedType = (ReferenceBinding)binding;
            this.reportInvalidType(scope);
            int n = this.tokens.length;
            for (int i = 0; i < n; ++i) {
                TypeReference[] typeReferenceArray = this.typeArguments[i];
                if (typeReferenceArray == null) continue;
                for (TypeReference typeReference : typeReferenceArray) {
                    if (bl2) {
                        typeReference.resolveType((ClassScope)scope);
                        continue;
                    }
                    typeReference.resolveType((BlockScope)scope, bl);
                }
            }
            return null;
        }
        PackageBinding packageBinding = binding == null ? null : (PackageBinding)binding;
        this.rejectAnnotationsOnPackageQualifiers(scope, packageBinding);
        boolean bl3 = true;
        Object object = null;
        int n = this.tokens.length;
        for (int i = packageBinding == null ? 0 : packageBinding.compoundName.length; i < n; ++i) {
            Object object2;
            Object object3;
            this.findNextTypeBinding(i, scope, packageBinding);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(scope);
                for (int j = i; j < n; ++j) {
                    object3 = this.typeArguments[j];
                    if (object3 == null) continue;
                    for (Object object4 : object3) {
                        if (bl2) {
                            ((TypeReference)object4).resolveType((ClassScope)scope);
                            continue;
                        }
                        ((TypeReference)object4).resolveType((BlockScope)scope);
                    }
                }
                return null;
            }
            ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
            if (object == null) {
                object = referenceBinding.enclosingType();
                if (object != null) {
                    object = referenceBinding.isStatic() ? (ReferenceBinding)scope.environment().convertToRawType((TypeBinding)object, false) : scope.environment().convertToParameterizedType((ReferenceBinding)object);
                }
            } else {
                if (this.annotations != null) {
                    ParameterizedQualifiedTypeReference.rejectAnnotationsOnStaticMemberQualififer(scope, referenceBinding, this.annotations[i - 1]);
                }
                if (bl3 && referenceBinding.isStatic() && (((TypeBinding)object).isParameterizedTypeWithActualArguments() || ((TypeBinding)object).isGenericType())) {
                    scope.problemReporter().staticMemberOfParameterizedType(this, scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)object), i);
                    bl3 = false;
                }
                if ((object3 = referenceBinding.enclosingType()) != null && TypeBinding.notEquals(((TypeBinding)object3).erasure(), ((TypeBinding)object).erasure())) {
                    object = object3;
                }
            }
            if ((object3 = this.typeArguments[i]) != null) {
                TypeVariableBinding[] typeVariableBindingArray;
                Object object5;
                int n2;
                object2 = null;
                if (bl2) {
                    object2 = ((ClassScope)scope).superTypeReference;
                    ((ClassScope)scope).superTypeReference = null;
                }
                boolean bl4 = (n2 = ((Object)object3).length) == 0 && i == n - 1 && (this.bits & 0x80000) != 0;
                TypeBinding[] typeBindingArray = new TypeBinding[n2];
                boolean bl5 = false;
                ReferenceBinding referenceBinding2 = (ReferenceBinding)referenceBinding.original();
                for (int j = 0; j < n2; ++j) {
                    TypeBinding typeBinding;
                    object5 = object3[j];
                    TypeBinding typeBinding2 = typeBinding = bl2 ? ((TypeReference)object5).resolveTypeArgument((ClassScope)scope, referenceBinding2, j) : ((TypeReference)object5).resolveTypeArgument((BlockScope)scope, referenceBinding2, j);
                    if (typeBinding == null) {
                        bl5 = true;
                        continue;
                    }
                    typeBindingArray[j] = typeBinding;
                }
                if (bl5) {
                    return null;
                }
                if (bl2) {
                    ((ClassScope)scope).superTypeReference = object2;
                    if (((ClassScope)scope).detectHierarchyCycle(referenceBinding2, this)) {
                        return null;
                    }
                }
                if ((typeVariableBindingArray = referenceBinding2.typeVariables()) == Binding.NO_TYPE_VARIABLES) {
                    if (scope.compilerOptions().originalSourceLevel >= 0x310000L) {
                        scope.problemReporter().nonGenericTypeCannotBeParameterized(i, this, referenceBinding, typeBindingArray);
                        return null;
                    }
                    this.resolvedType = object != null && ((TypeBinding)object).isParameterizedType() ? scope.environment().createParameterizedType(referenceBinding2, null, (ReferenceBinding)object) : referenceBinding;
                    return this.resolvedType;
                }
                if (n2 != typeVariableBindingArray.length && !bl4) {
                    scope.problemReporter().incorrectArityForParameterizedType(this, referenceBinding, typeBindingArray, i);
                    return null;
                }
                if (bl3 && !referenceBinding.isStatic() && (object5 = referenceBinding.enclosingType()) != null && ((TypeBinding)object5).isRawType()) {
                    scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType(referenceBinding2, (ReferenceBinding)object5), typeBindingArray);
                    bl3 = false;
                }
                object5 = scope.environment().createParameterizedType(referenceBinding2, typeBindingArray, (ReferenceBinding)object);
                if (!bl4) {
                    if (bl) {
                        ((ParameterizedTypeBinding)object5).boundCheck(scope, (TypeReference[])object3);
                    } else {
                        scope.deferBoundCheck(this);
                    }
                } else {
                    ((ParameterizedTypeBinding)object5).arguments = ParameterizedSingleTypeReference.DIAMOND_TYPE_ARGUMENTS;
                }
                object = object5;
            } else {
                object2 = (ReferenceBinding)referenceBinding.original();
                if (bl2 && ((ClassScope)scope).detectHierarchyCycle((TypeBinding)object2, this)) {
                    return null;
                }
                if (((TypeBinding)object2).isGenericType()) {
                    if (bl3 && object != null && ((TypeBinding)object).isParameterizedType() && !((ReferenceBinding)object2).isStatic()) {
                        scope.problemReporter().parameterizedMemberTypeMissingArguments(this, scope.environment().createParameterizedType((ReferenceBinding)object2, null, (ReferenceBinding)object), i);
                        bl3 = false;
                    }
                    object = scope.environment().createRawType((ReferenceBinding)object2, (ReferenceBinding)object);
                } else {
                    Object object6 = object = object != null && ((TypeBinding)object).isParameterizedType() ? scope.environment().createParameterizedType((ReferenceBinding)object2, null, (ReferenceBinding)object) : referenceBinding;
                }
            }
            if (this.isTypeUseDeprecated((TypeBinding)object, scope)) {
                this.reportDeprecatedType((TypeBinding)object, scope, i);
            }
            this.resolvedType = object;
            this.recordResolution(scope.environment(), this.resolvedType);
        }
        return this.resolvedType;
    }

    private void createArrayType(Scope scope) {
        if (this.dimensions > 0) {
            if (this.dimensions > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArrayType(this.resolvedType, this.dimensions);
        }
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        int n2;
        int n3;
        int n4 = this.tokens.length;
        for (int i = 0; i < n4 - 1; ++i) {
            if (this.annotations != null && this.annotations[i] != null) {
                ParameterizedQualifiedTypeReference.printAnnotations(this.annotations[i], stringBuffer);
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.tokens[i]);
            TypeReference[] typeReferenceArray = this.typeArguments[i];
            if (typeReferenceArray != null) {
                stringBuffer.append('<');
                n3 = typeReferenceArray.length;
                if (n3 > 0) {
                    n2 = n3 - 1;
                    for (int j = 0; j < n2; ++j) {
                        typeReferenceArray[j].print(0, stringBuffer);
                        stringBuffer.append(", ");
                    }
                    typeReferenceArray[n2].print(0, stringBuffer);
                }
                stringBuffer.append('>');
            }
            stringBuffer.append('.');
        }
        if (this.annotations != null && this.annotations[n4 - 1] != null) {
            stringBuffer.append(" ");
            ParameterizedQualifiedTypeReference.printAnnotations(this.annotations[n4 - 1], stringBuffer);
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.tokens[n4 - 1]);
        TypeReference[] typeReferenceArray = this.typeArguments[n4 - 1];
        if (typeReferenceArray != null) {
            stringBuffer.append('<');
            int n5 = typeReferenceArray.length;
            if (n5 > 0) {
                n3 = n5 - 1;
                for (n2 = 0; n2 < n3; ++n2) {
                    typeReferenceArray[n2].print(0, stringBuffer);
                    stringBuffer.append(", ");
                }
                typeReferenceArray[n3].print(0, stringBuffer);
            }
            stringBuffer.append('>');
        }
        Annotation[][] annotationArray = this.getAnnotationsOnDimensions();
        if ((this.bits & 0x4000) != 0) {
            for (n3 = 0; n3 < this.dimensions - 1; ++n3) {
                if (annotationArray != null && annotationArray[n3] != null) {
                    stringBuffer.append(" ");
                    ParameterizedQualifiedTypeReference.printAnnotations(annotationArray[n3], stringBuffer);
                    stringBuffer.append(" ");
                }
                stringBuffer.append("[]");
            }
            if (annotationArray != null && annotationArray[this.dimensions - 1] != null) {
                stringBuffer.append(" ");
                ParameterizedQualifiedTypeReference.printAnnotations(annotationArray[this.dimensions - 1], stringBuffer);
                stringBuffer.append(" ");
            }
            stringBuffer.append("...");
        } else {
            for (n3 = 0; n3 < this.dimensions; ++n3) {
                if (annotationArray != null && annotationArray[n3] != null) {
                    stringBuffer.append(" ");
                    ParameterizedQualifiedTypeReference.printAnnotations(annotationArray[n3], stringBuffer);
                    stringBuffer.append(" ");
                }
                stringBuffer.append("[]");
            }
        }
        return stringBuffer;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope, boolean bl, int n) {
        return this.internalResolveType(blockScope, bl, n);
    }

    @Override
    public TypeBinding resolveType(ClassScope classScope, int n) {
        return this.internalResolveType(classScope, false, n);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            Annotation[][] annotationArray;
            int n2;
            int n3;
            if (this.annotations != null) {
                int n4 = this.annotations.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = this.annotations[n3] == null ? 0 : this.annotations[n3].length;
                    for (int i = 0; i < n2; ++i) {
                        this.annotations[n3][i].traverse(aSTVisitor, blockScope);
                    }
                }
            }
            if ((annotationArray = this.getAnnotationsOnDimensions(true)) != null) {
                for (Annotation[] annotationArray2 : annotationArray) {
                    int n5;
                    int n6 = n5 = annotationArray2 == null ? 0 : annotationArray2.length;
                    for (n = 0; n < n5; ++n) {
                        Annotation annotation = annotationArray2[n];
                        annotation.traverse(aSTVisitor, blockScope);
                    }
                }
            }
            n2 = this.typeArguments.length;
            for (n3 = 0; n3 < n2; ++n3) {
                if (this.typeArguments[n3] == null) continue;
                n = this.typeArguments[n3].length;
                for (int i = 0; i < n; ++i) {
                    this.typeArguments[n3][i].traverse(aSTVisitor, blockScope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            Annotation[][] annotationArray;
            int n2;
            int n3;
            if (this.annotations != null) {
                int n4 = this.annotations.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = this.annotations[n3] == null ? 0 : this.annotations[n3].length;
                    for (int i = 0; i < n2; ++i) {
                        this.annotations[n3][i].traverse(aSTVisitor, classScope);
                    }
                }
            }
            if ((annotationArray = this.getAnnotationsOnDimensions(true)) != null) {
                for (Annotation[] annotationArray2 : annotationArray) {
                    int n5;
                    int n6 = n5 = annotationArray2 == null ? 0 : annotationArray2.length;
                    for (n = 0; n < n5; ++n) {
                        Annotation annotation = annotationArray2[n];
                        annotation.traverse(aSTVisitor, classScope);
                    }
                }
            }
            n2 = this.typeArguments.length;
            for (n3 = 0; n3 < n2; ++n3) {
                if (this.typeArguments[n3] == null) continue;
                n = this.typeArguments[n3].length;
                for (int i = 0; i < n; ++i) {
                    this.typeArguments[n3][i].traverse(aSTVisitor, classScope);
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

