/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class AnalyzeRequest
extends SingleShardRequest<AnalyzeRequest> {
    private String[] text;
    private String analyzer;
    private String tokenizer;
    private String[] tokenFilters = Strings.EMPTY_ARRAY;
    private String[] charFilters = Strings.EMPTY_ARRAY;
    private String field;
    private boolean explain = false;
    private String[] attributes = Strings.EMPTY_ARRAY;

    public AnalyzeRequest() {
    }

    public AnalyzeRequest(String index) {
        this.index(index);
    }

    public String[] text() {
        return this.text;
    }

    public AnalyzeRequest text(String ... text) {
        this.text = text;
        return this;
    }

    public AnalyzeRequest analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public AnalyzeRequest tokenizer(String tokenizer) {
        this.tokenizer = tokenizer;
        return this;
    }

    public String tokenizer() {
        return this.tokenizer;
    }

    public AnalyzeRequest tokenFilters(String ... tokenFilters) {
        if (tokenFilters == null) {
            throw new IllegalArgumentException("token filters must not be null");
        }
        this.tokenFilters = tokenFilters;
        return this;
    }

    public String[] tokenFilters() {
        return this.tokenFilters;
    }

    public AnalyzeRequest charFilters(String ... charFilters) {
        if (charFilters == null) {
            throw new IllegalArgumentException("char filters must not be null");
        }
        this.charFilters = charFilters;
        return this;
    }

    public String[] charFilters() {
        return this.charFilters;
    }

    public AnalyzeRequest field(String field) {
        this.field = field;
        return this;
    }

    public String field() {
        return this.field;
    }

    public AnalyzeRequest explain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public boolean explain() {
        return this.explain;
    }

    public AnalyzeRequest attributes(String ... attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes must not be null");
        }
        this.attributes = attributes;
        return this;
    }

    public String[] attributes() {
        return this.attributes;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.text == null || this.text.length == 0) {
            validationException = ValidateActions.addValidationError("text is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.text = in.readStringArray();
        this.analyzer = in.readOptionalString();
        this.tokenizer = in.readOptionalString();
        this.tokenFilters = in.readStringArray();
        this.charFilters = in.readStringArray();
        this.field = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_2_2_0)) {
            this.explain = in.readBoolean();
            this.attributes = in.readStringArray();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.text);
        out.writeOptionalString(this.analyzer);
        out.writeOptionalString(this.tokenizer);
        out.writeStringArray(this.tokenFilters);
        out.writeStringArray(this.charFilters);
        out.writeOptionalString(this.field);
        if (out.getVersion().onOrAfter(Version.V_2_2_0)) {
            out.writeBoolean(this.explain);
            out.writeStringArray(this.attributes);
        }
    }
}

