/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanNearQueryBuilder
extends SpanQueryBuilder
implements BoostableQueryBuilder<SpanNearQueryBuilder> {
    private ArrayList<SpanQueryBuilder> clauses = new ArrayList();
    private Integer slop = null;
    private Boolean inOrder;
    private Boolean collectPayloads;
    private float boost = -1.0f;
    private String queryName;

    public SpanNearQueryBuilder clause(SpanQueryBuilder clause) {
        this.clauses.add(clause);
        return this;
    }

    public SpanNearQueryBuilder slop(int slop) {
        this.slop = slop;
        return this;
    }

    public SpanNearQueryBuilder inOrder(boolean inOrder) {
        this.inOrder = inOrder;
        return this;
    }

    public SpanNearQueryBuilder collectPayloads(boolean collectPayloads) {
        this.collectPayloads = collectPayloads;
        return this;
    }

    @Override
    public SpanNearQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public SpanNearQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.clauses.isEmpty()) {
            throw new IllegalArgumentException("Must have at least one clause when building a spanNear query");
        }
        if (this.slop == null) {
            throw new IllegalArgumentException("Must set the slop when building a spanNear query");
        }
        builder.startObject("span_near");
        builder.startArray("clauses");
        for (SpanQueryBuilder clause : this.clauses) {
            clause.toXContent(builder, params);
        }
        builder.endArray();
        builder.field("slop", (int)this.slop);
        if (this.inOrder != null) {
            builder.field("in_order", (Object)this.inOrder);
        }
        if (this.collectPayloads != null) {
            builder.field("collect_payloads", (Object)this.collectPayloads);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

