/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.rhino;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.process.JavaExecSpec;
import org.gradle.util.CollectionUtils;

public class RhinoShellExec
extends JavaExec {
    private List<Object> rhinoOptions = new LinkedList<Object>();
    private List<Object> scriptArgs = new LinkedList<Object>();
    private Object script;

    @Input
    public List<String> getRhinoOptions() {
        return CollectionUtils.stringize(this.rhinoOptions);
    }

    public void setRhinoOptions(Object ... rhinoOptions) {
        this.rhinoOptions = new LinkedList<Object>(Arrays.asList(rhinoOptions));
    }

    public void rhinoOptions(Object ... rhinoOptions) {
        this.rhinoOptions.addAll(Arrays.asList(rhinoOptions));
    }

    @Internal(value="Represented as part of args")
    public List<String> getScriptArgs() {
        return CollectionUtils.stringize(this.scriptArgs);
    }

    public void setScriptArgs(Object ... scriptArgs) {
        this.scriptArgs = new LinkedList<Object>(Arrays.asList(scriptArgs));
    }

    public void scriptArgs(Object ... scriptArgs) {
        this.scriptArgs.addAll(Arrays.asList(scriptArgs));
    }

    @InputFile
    @Optional
    public File getScript() {
        return this.script == null ? null : this.getProject().file(this.script);
    }

    public void setScript(Object script) {
        this.script = script;
    }

    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>(this.rhinoOptions.size() + 1 + this.scriptArgs.size());
        args.addAll(this.getRhinoOptions());
        File script = this.getScript();
        if (script != null) {
            args.add(script.getAbsolutePath());
        }
        args.addAll(this.getScriptArgs());
        return args;
    }

    public JavaExec setArgs(Iterable<?> applicationArgs) {
        throw this.argsUnsupportOperationException();
    }

    public JavaExec args(Object ... args) {
        throw this.argsUnsupportOperationException();
    }

    public JavaExecSpec args(Iterable<?> args) {
        throw this.argsUnsupportOperationException();
    }

    private UnsupportedOperationException argsUnsupportOperationException() {
        return new UnsupportedOperationException("Cannot set args directly on RhinoExec, use rhinoOptions, scriptArgs and/or script");
    }

    public void exec() {
        super.setArgs(this.getArgs());
        super.exec();
    }
}

