/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataSerializer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class ModuleMetadataStore {
    private final PathKeyFileStore metaDataStore;
    private final ModuleMetadataSerializer moduleMetadataSerializer;

    public ModuleMetadataStore(PathKeyFileStore metaDataStore, ModuleMetadataSerializer moduleMetadataSerializer) {
        this.metaDataStore = metaDataStore;
        this.moduleMetadataSerializer = moduleMetadataSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableModuleComponentResolveMetadata getModuleDescriptor(ModuleComponentRepository repository, ModuleComponentIdentifier moduleComponentIdentifier) {
        String filePath = this.getFilePath(repository, moduleComponentIdentifier);
        LocallyAvailableResource resource = this.metaDataStore.get(filePath);
        if (resource != null) {
            MutableModuleComponentResolveMetadata mutableModuleComponentResolveMetadata;
            KryoBackedDecoder decoder = new KryoBackedDecoder((InputStream)new FileInputStream(resource.getFile()));
            try {
                mutableModuleComponentResolveMetadata = this.moduleMetadataSerializer.read((Decoder)decoder);
            }
            catch (Throwable throwable) {
                try {
                    decoder.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not load module metadata from " + resource.getDisplayName(), e);
                }
            }
            decoder.close();
            return mutableModuleComponentResolveMetadata;
        }
        return null;
    }

    public LocallyAvailableResource putModuleDescriptor(ModuleComponentRepository repository, final ModuleComponentResolveMetadata metadata) {
        String filePath = this.getFilePath(repository, metadata.getComponentId());
        return this.metaDataStore.add(filePath, (Action)new Action<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(File moduleDescriptorFile) {
                try {
                    KryoBackedEncoder encoder = new KryoBackedEncoder((OutputStream)new FileOutputStream(moduleDescriptorFile));
                    try {
                        ModuleMetadataStore.this.moduleMetadataSerializer.write((Encoder)encoder, metadata);
                    }
                    finally {
                        encoder.close();
                    }
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        });
    }

    private String getFilePath(ModuleComponentRepository repository, ModuleComponentIdentifier moduleComponentIdentifier) {
        return moduleComponentIdentifier.getGroup() + "/" + moduleComponentIdentifier.getModule() + "/" + moduleComponentIdentifier.getVersion() + "/" + repository.getId() + "/descriptor.bin";
    }
}

