/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.internal.component.external.descriptor.Artifact;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ConfigurationNotFoundException;
import org.gradle.internal.component.model.DefaultDependencyMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.Exclude;

public class IvyDependencyMetadata
extends DefaultDependencyMetadata {
    private final String dynamicConstraintVersion;
    private final boolean force;
    private final boolean changing;
    private final boolean transitive;
    private final SetMultimap<String, String> confs;
    private final List<Exclude> excludes;

    public IvyDependencyMetadata(ModuleVersionSelector requested, String dynamicConstraintVersion, boolean force, boolean changing, boolean transitive, Multimap<String, String> confMappings, List<Artifact> artifacts, List<Exclude> excludes) {
        super(requested, artifacts);
        this.dynamicConstraintVersion = dynamicConstraintVersion;
        this.force = force;
        this.changing = changing;
        this.transitive = transitive;
        this.confs = ImmutableSetMultimap.copyOf(confMappings);
        this.excludes = ImmutableList.copyOf(excludes);
    }

    public IvyDependencyMetadata(ModuleVersionSelector requested, ListMultimap<String, String> confMappings) {
        this(requested, requested.getVersion(), false, false, true, (Multimap<String, String>)confMappings, Collections.emptyList(), Collections.emptyList());
    }

    public String toString() {
        return "dependency: " + this.getRequested() + ", confs: " + this.confs;
    }

    @Override
    protected DependencyMetadata withRequested(ModuleVersionSelector newRequested) {
        return new IvyDependencyMetadata(newRequested, this.dynamicConstraintVersion, this.force, this.changing, this.transitive, (Multimap<String, String>)this.confs, this.getDependencyArtifacts(), this.excludes);
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public String getDynamicConstraintVersion() {
        return this.dynamicConstraintVersion;
    }

    @Override
    public Set<String> getModuleConfigurations() {
        return this.confs.keySet();
    }

    public SetMultimap<String, String> getConfMappings() {
        return this.confs;
    }

    @Override
    public Set<ConfigurationMetadata> selectConfigurations(ComponentResolveMetadata fromComponent, ConfigurationMetadata fromConfiguration, ComponentResolveMetadata targetComponent) {
        Set wildcardPatterns;
        LinkedHashSet targets = Sets.newLinkedHashSet();
        boolean matched = false;
        String fromConfigName = fromConfiguration.getName();
        for (String config : fromConfiguration.getHierarchy()) {
            Set targetPatterns = this.confs.get((Object)config);
            if (!targetPatterns.isEmpty()) {
                matched = true;
            }
            for (String targetPattern : targetPatterns) {
                this.findMatches(fromComponent, targetComponent, fromConfigName, config, targetPattern, targets);
            }
        }
        if (!matched) {
            for (String targetPattern : this.confs.get((Object)"%")) {
                this.findMatches(fromComponent, targetComponent, fromConfigName, fromConfigName, targetPattern, targets);
            }
        }
        if (!(wildcardPatterns = this.confs.get((Object)"*")).isEmpty()) {
            boolean excludeWildcards = false;
            for (String confName : fromConfiguration.getHierarchy()) {
                if (!this.confs.containsKey((Object)("!" + confName))) continue;
                excludeWildcards = true;
                break;
            }
            if (!excludeWildcards) {
                for (String targetPattern : wildcardPatterns) {
                    this.findMatches(fromComponent, targetComponent, fromConfigName, fromConfigName, targetPattern, targets);
                }
            }
        }
        return targets;
    }

    private void findMatches(ComponentResolveMetadata fromComponent, ComponentResolveMetadata targetComponent, String fromConfiguration, String patternConfiguration, String targetPattern, Set<ConfigurationMetadata> targetConfigurations) {
        int startFallback = targetPattern.indexOf(40);
        if (startFallback >= 0 && targetPattern.endsWith(")")) {
            String preferred = targetPattern.substring(0, startFallback);
            ConfigurationMetadata configuration = targetComponent.getConfiguration(preferred);
            if (configuration != null) {
                targetConfigurations.add(configuration);
                return;
            }
            targetPattern = targetPattern.substring(startFallback + 1, targetPattern.length() - 1);
        }
        if (targetPattern.equals("*")) {
            for (String targetName : targetComponent.getConfigurationNames()) {
                ConfigurationMetadata configuration = targetComponent.getConfiguration(targetName);
                if (!configuration.isVisible()) continue;
                targetConfigurations.add(configuration);
            }
            return;
        }
        if (targetPattern.equals("@")) {
            targetPattern = patternConfiguration;
        } else if (targetPattern.equals("#")) {
            targetPattern = fromConfiguration;
        }
        ConfigurationMetadata configuration = targetComponent.getConfiguration(targetPattern);
        if (configuration == null) {
            throw new ConfigurationNotFoundException(fromComponent.getComponentId(), fromConfiguration, targetPattern, targetComponent.getComponentId());
        }
        targetConfigurations.add(configuration);
    }

    public List<Exclude> getDependencyExcludes() {
        return this.excludes;
    }

    @Override
    public ModuleExclusion getExclusions(ConfigurationMetadata fromConfiguration) {
        return this.excludes.isEmpty() ? ModuleExclusions.excludeNone() : ModuleExclusions.excludeAny(this.getExcludes(fromConfiguration.getHierarchy()));
    }

    private List<Exclude> getExcludes(Collection<String> configurations) {
        ArrayList rules = Lists.newArrayList();
        for (Exclude exclude : this.excludes) {
            Set<String> ruleConfigurations = exclude.getConfigurations();
            if (!this.include(ruleConfigurations, configurations)) continue;
            rules.add(exclude);
        }
        return rules;
    }
}

