/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindExclude;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScopeImpl;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;
import kotlin.reflect.jvm.internal.impl.utils.Printer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubpackagesScope
extends MemberScopeImpl {
    private final ModuleDescriptor moduleDescriptor;
    private final FqName fqName;

    @Nullable
    protected final PackageViewDescriptor getPackage(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (name.isSpecial()) {
            return null;
        }
        FqName fqName2 = this.fqName.child(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"fqName.child(name)");
        PackageViewDescriptor packageViewDescriptor = this.moduleDescriptor.getPackage(fqName2);
        if (packageViewDescriptor.isEmpty()) {
            return null;
        }
        return packageViewDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkParameterIsNotNull((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkParameterIsNotNull(nameFilter, (String)"nameFilter");
        if (!kindFilter.acceptsKinds(DescriptorKindFilter.Companion.getPACKAGES_MASK())) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        if (this.fqName.isRoot() && kindFilter.getExcludes().contains(DescriptorKindExclude.TopLevelPackages.INSTANCE)) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        Collection<FqName> subFqNames = this.moduleDescriptor.getSubPackagesOf(this.fqName, nameFilter);
        ArrayList result = new ArrayList(subFqNames.size());
        for (FqName subFqName : subFqNames) {
            Name shortName;
            Name name = shortName = subFqName.shortName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"shortName");
            if (!((Boolean)nameFilter.invoke((Object)name)).booleanValue()) continue;
            Collection collection = result;
            Name name2 = shortName;
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"shortName");
            CollectionsKt.addIfNotNull(collection, this.getPackage(name2));
        }
        return result;
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        p.println(this.getClass().getSimpleName(), " {");
        p.pushIndent();
        p.popIndent();
        p.println("}");
    }

    public SubpackagesScope(@NotNull ModuleDescriptor moduleDescriptor, @NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        this.moduleDescriptor = moduleDescriptor;
        this.fqName = fqName2;
    }
}

