/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.asJava.FilteredJvmDiagnostics;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.output.outputUtils.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CliLightClassGenerationSupport;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.GenerationStateEventCallback;
import org.jetbrains.kotlin.codegen.state.GenerationStateKt;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.JarUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.modules.JavaRootPath;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.modules.TargetIdKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0005J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u001b\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ%\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\u0006\u0010\n\u001a\u00020\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0082\bJ\u001c\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\"J\u001c\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J$\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020'H\u0002J \u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019H\u0002J8\u0010/\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u00100\u001a\u00020\t2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\b\u00102\u001a\u0004\u0018\u00010)H\u0002J\u001e\u00103\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00102\u001a\u00020)H\u0002J\u0010\u00104\u001a\u00020%2\u0006\u00105\u001a\u000206H\u0002J\u001e\u00107\u001a\u00020%2\u0006\u0010\u0003\u001a\u00020\u00042\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019H\u0002J$\u00109\u001a\u0004\u0018\u00010\u00012\n\u0010:\u001a\u0006\u0012\u0002\b\u00030\u001f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002J$\u0010;\u001a\u0004\u0018\u00010\u00012\n\u0010:\u001a\u0006\u0012\u0002\b\u00030\u001f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0007J\"\u0010<\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010-H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinToJVMBytecodeCompiler;", "", "()V", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getMessageCollector", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "analyze", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "environment", "targetDescription", "", "analyzeAndGenerate", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "checkKotlinPackageUsage", "", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "compileAndExecuteScript", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "scriptArgs", "", "compileBunchOfSources", "compileModules", "directory", "Ljava/io/File;", "compileScript", "Ljava/lang/Class;", "makeParentClassLoader", "Lkotlin/Function0;", "Ljava/lang/ClassLoader;", "parentClassLoader", "configureSourceRoots", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "chunk", "Lorg/jetbrains/kotlin/modules/Module;", "createOutputFilesFlushingCallbackIfPossible", "Lorg/jetbrains/kotlin/codegen/state/GenerationStateEventCallback;", "findMainClass", "Lorg/jetbrains/kotlin/name/FqName;", "generationState", "generate", "result", "sourceFiles", "module", "getAbsolutePaths", "reportExceptionFromScript", "exception", "", "reportRuntimeConflicts", "jvmClasspathRoots", "tryConstructClass", "scriptClass", "tryConstructClassPub", "writeOutput", "outputFiles", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "mainClass", "kotlin-compiler"})
public final class KotlinToJVMBytecodeCompiler {
    public static final KotlinToJVMBytecodeCompiler INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final List<String> getAbsolutePaths(File directory, Module module) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = module.getSourceFiles();
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void sourceFile;
            String string = (String)item$iv$iv;
            void var9_9 = destination$iv$iv;
            File source = new File((String)sourceFile);
            if (!source.isAbsolute()) {
                source = new File(directory, (String)sourceFile);
            }
            String string2 = source.getAbsolutePath();
            var9_9.add(string2);
        }
        return (List)destination$iv$iv;
    }

    private final void writeOutput(CompilerConfiguration configuration, OutputFileCollection outputFiles, FqName mainClass) {
        File jarPath = configuration.get(JVMConfigurationKeys.OUTPUT_JAR);
        if (jarPath != null) {
            Boolean includeRuntime = configuration.get(JVMConfigurationKeys.INCLUDE_RUNTIME, false);
            CompileEnvironmentUtil.writeToJar(jarPath, includeRuntime, mainClass, outputFiles);
            return;
        }
        File file2 = configuration.get(JVMConfigurationKeys.OUTPUT_DIRECTORY);
        if (file2 == null) {
            file2 = new File(".");
        }
        File outputDir2 = file2;
        MessageCollector messageCollector = configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
        File file3 = outputDir2;
        Intrinsics.checkExpressionValueIsNotNull(file3, "outputDir");
        MessageCollector messageCollector2 = messageCollector;
        Intrinsics.checkExpressionValueIsNotNull(messageCollector2, "messageCollector");
        OutputUtilsKt.writeAll(outputFiles, file3, messageCollector2);
    }

    private final GenerationStateEventCallback createOutputFilesFlushingCallbackIfPossible(CompilerConfiguration configuration) {
        if (configuration.get(JVMConfigurationKeys.OUTPUT_DIRECTORY) == null) {
            return GenerationStateEventCallback.Companion.getDO_NOTHING();
        }
        return GenerationStateKt.GenerationStateEventCallback((Function1<? super GenerationState, Unit>)new Function1<GenerationState, Unit>(configuration){
            final /* synthetic */ CompilerConfiguration $configuration;

            public final void invoke(@NotNull GenerationState state2) {
                Intrinsics.checkParameterIsNotNull(state2, "state");
                List<OutputFile> list2 = state2.getFactory().getCurrentOutput();
                Intrinsics.checkExpressionValueIsNotNull(list2, "state.factory.currentOutput");
                SimpleOutputFileCollection currentOutput = new SimpleOutputFileCollection(list2);
                KotlinToJVMBytecodeCompiler.access$writeOutput(KotlinToJVMBytecodeCompiler.INSTANCE, this.$configuration, currentOutput, null);
                if (!this.$configuration.get(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, false).booleanValue()) {
                    state2.getFactory().releaseGeneratedOutput();
                }
            }
            {
                this.$configuration = compilerConfiguration;
                super(1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compileModules(@NotNull KotlinCoreEnvironment environment2, @NotNull File directory) {
        Object moduleConfiguration;
        Object object;
        Object ktFiles2;
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(directory, "directory");
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance(environment2.getProject());
        CompilerConfiguration projectConfiguration = environment2.getConfiguration();
        List<Module> chunk = projectConfiguration.getNotNull(JVMConfigurationKeys.MODULES);
        Iterator<Module> iterator2 = chunk.iterator();
        while (iterator2.hasNext()) {
            Module module;
            Module module2 = module = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(module2, "module");
            moduleVisibilityManager.addModule(module2);
        }
        List friendPaths = environment2.getConfiguration().getList(JVMConfigurationKeys.FRIEND_PATHS);
        Iterator iterator3 = friendPaths.iterator();
        while (iterator3.hasNext()) {
            String path;
            String string = path = (String)iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull(string, "path");
            moduleVisibilityManager.addFriendPath(string);
        }
        String targetDescription2 = "in targets [" + CollectionsKt.joinToString$default(chunk, null, null, null, 0, null, compileModules.targetDescription.1.INSTANCE, 31, null) + "]";
        AnalysisResult result2 = this.analyze(environment2, targetDescription2);
        if (result2 == null || !result2.getShouldGenerateCode()) {
            return false;
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        result2.throwIfError();
        LinkedHashMap outputs = org.jetbrains.kotlin.utils.CollectionsKt.newLinkedHashMapWithExpectedSize(chunk.size());
        for (Module entry : chunk) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            Project project = environment2.getProject();
            Module module = entry;
            Intrinsics.checkExpressionValueIsNotNull(module, "module");
            ktFiles2 = CompileEnvironmentUtil.getKtFiles(project, (Collection<String>)this.getAbsolutePaths(directory, module), projectConfiguration, compileModules.ktFiles.1.INSTANCE);
            Collection collection = (Collection)ktFiles2;
            Intrinsics.checkExpressionValueIsNotNull(collection, "ktFiles");
            if (!this.checkKotlinPackageUsage(environment2, collection)) {
                return false;
            }
            object = projectConfiguration.copy();
            Object $receiver = (CompilerConfiguration)object;
            ((CompilerConfiguration)$receiver).put(JVMConfigurationKeys.OUTPUT_DIRECTORY, new File(entry.getOutputDirectory()));
            moduleConfiguration = (CompilerConfiguration)object;
            object = outputs;
            Module module3 = entry;
            Intrinsics.checkExpressionValueIsNotNull(module3, "module");
            $receiver = module3;
            Object object2 = moduleConfiguration;
            Intrinsics.checkExpressionValueIsNotNull(object2, "moduleConfiguration");
            Object object3 = ktFiles2;
            Intrinsics.checkExpressionValueIsNotNull(object3, "ktFiles");
            GenerationState $i$a$1$apply = this.generate(environment2, (CompilerConfiguration)object2, result2, (List<? extends KtFile>)object3, entry);
            object.put($receiver, $i$a$1$apply);
        }
        try {
            ktFiles2 = outputs;
            for (Map.Entry entry : ktFiles2.entrySet()) {
                moduleConfiguration = entry;
                Module module = (Module)moduleConfiguration.getKey();
                object = entry;
                GenerationState state2 = (GenerationState)object.getValue();
                ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
                this.writeOutput(state2.getConfiguration(), state2.getFactory(), null);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Iterable $receiver$iv;
            Iterable iterable = outputs.values();
            for (Object element$iv : $receiver$iv) {
                GenerationState p1 = (GenerationState)element$iv;
                p1.destroy();
            }
        }
    }

    public final void configureSourceRoots(@NotNull CompilerConfiguration configuration, @NotNull List<? extends Module> chunk, @NotNull File directory) {
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(chunk, "chunk");
        Intrinsics.checkParameterIsNotNull(directory, "directory");
        for (Module module : chunk) {
            ContentRootsKt.addKotlinSourceRoots(configuration, this.getAbsolutePaths(directory, module));
        }
        for (Module module : chunk) {
            for (JavaRootPath javaRootPath : module.getJavaSourceRoots()) {
                JvmContentRootsKt.addJavaSourceRoot(configuration, new File(javaRootPath.getPath()), javaRootPath.getPackagePrefix());
            }
        }
        for (Module module : chunk) {
            for (String classpathRoot : module.getClasspathRoots()) {
                JvmContentRootsKt.addJvmClasspathRoot(configuration, new File(classpathRoot));
            }
        }
        configuration.addAll(JVMConfigurationKeys.MODULES, (Collection)chunk);
    }

    /*
     * WARNING - void declaration
     */
    private final FqName findMainClass(GenerationState generationState, List<? extends KtFile> files) {
        Object v0;
        block2: {
            void $receiver$iv;
            MainFunctionDetector mainFunctionDetector = new MainFunctionDetector(generationState.getBindingContext());
            Sequence sequence2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)files), (Function1)new Function1<KtFile, FqName>(mainFunctionDetector){
                final /* synthetic */ MainFunctionDetector $mainFunctionDetector;

                @Nullable
                public final FqName invoke(@NotNull KtFile file2) {
                    Intrinsics.checkParameterIsNotNull(file2, "file");
                    List<KtDeclaration> list2 = file2.getDeclarations();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "file.declarations");
                    return this.$mainFunctionDetector.hasMain(list2) ? JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFacadeClassFqName() : (FqName)null;
                }
                {
                    this.$mainFunctionDetector = mainFunctionDetector;
                    super(1);
                }
            });
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                FqName it = (FqName)element$iv;
                if (!(it != null)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compileBunchOfSources(@NotNull KotlinCoreEnvironment environment2) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance(environment2.getProject());
        List friendPaths = environment2.getConfiguration().getList(JVMConfigurationKeys.FRIEND_PATHS);
        Iterator iterator2 = friendPaths.iterator();
        while (iterator2.hasNext()) {
            String path;
            String string = path = (String)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(string, "path");
            moduleVisibilityManager.addFriendPath(string);
        }
        if (!this.checkKotlinPackageUsage(environment2, (Collection<? extends KtFile>)environment2.getSourceFiles())) {
            return false;
        }
        GenerationState generationState = this.analyzeAndGenerate(environment2);
        if (generationState == null) {
            return false;
        }
        GenerationState generationState2 = generationState;
        FqName mainClass = this.findMainClass(generationState2, environment2.getSourceFiles());
        try {
            this.writeOutput(environment2.getConfiguration(), generationState2.getFactory(), mainClass);
            boolean bl = true;
            return bl;
        }
        finally {
            generationState2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ExitCode compileAndExecuteScript(@NotNull KotlinCoreEnvironment environment2, @NotNull KotlinPaths paths, @NotNull List<String> scriptArgs) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(paths, "paths");
        Intrinsics.checkParameterIsNotNull(scriptArgs, "scriptArgs");
        Class<?> clazz = this.compileScript(environment2, paths);
        if (clazz == null) {
            return ExitCode.COMPILATION_ERROR;
        }
        Class<?> scriptClass = clazz;
        try {
            try {
                if (this.tryConstructClass(scriptClass, scriptArgs) == null) {
                    throw (Throwable)new RuntimeException("unable to find appropriate constructor for class " + scriptClass.getName() + " accepting arguments " + scriptArgs + "\n");
                }
            }
            finally {
                System.out.flush();
                System.err.flush();
            }
        }
        catch (Throwable e) {
            this.reportExceptionFromScript(e);
            return ExitCode.SCRIPT_EXECUTION_ERROR;
        }
        return ExitCode.OK;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportExceptionFromScript(Throwable exception) {
        PrintStream stream2 = System.err;
        Throwable cause = exception.getCause();
        if (!(exception instanceof InvocationTargetException) || cause == null) {
            exception.printStackTrace(stream2);
            return;
        }
        stream2.println(cause);
        StackTraceElement[] fullTrace = cause.getStackTrace();
        int relevantEntries = ((Object[])fullTrace).length - ((Object[])((InvocationTargetException)exception).getStackTrace()).length;
        int n = 0;
        int n2 = relevantEntries - 1;
        if (n <= n2) {
            while (true) {
                void i;
                stream2.println("\tat " + fullTrace[i]);
                if (i == n2) break;
                ++i;
            }
        }
    }

    @Nullable
    public final Object tryConstructClassPub(@NotNull Class<?> scriptClass, @NotNull List<String> scriptArgs) {
        Intrinsics.checkParameterIsNotNull(scriptClass, "scriptClass");
        Intrinsics.checkParameterIsNotNull(scriptArgs, "scriptArgs");
        return this.tryConstructClass(scriptClass, scriptArgs);
    }

    /*
     * WARNING - void declaration
     */
    private final Object tryConstructClass(Class<?> scriptClass, List<String> scriptArgs) {
        tryConstructClass.1 convertPrimitive$ = tryConstructClass.1.INSTANCE;
        tryConstructClass.2 convertArray$ = tryConstructClass.2.INSTANCE;
        tryConstructClass.3 foldingFunc$ = tryConstructClass.3.INSTANCE;
        try {
            void elements$iv;
            Object[] objectArray;
            Object[] $receiver$iv;
            Object[] objectArray2;
            Collection collection = scriptArgs;
            int n = 0;
            Object[] objectArray3 = objectArray2 = new Object[1];
            Constructor<?> constructor = scriptClass.getConstructor(String[].class);
            void v0 = $receiver$iv;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v0;
            String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            objectArray2[n] = objectArray = (Object[])stringArray;
            $receiver$iv = objectArray3;
            objectArray3 = (Object[])elements$iv;
            return constructor.newInstance(Arrays.copyOf(objectArray3, objectArray3.length));
        }
        catch (NoSuchMethodException e) {
            for (KFunction<?> ctor : JvmClassMappingKt.getKotlinClass(scriptClass).getConstructors()) {
                void other$iv;
                void scriptArgsLeft;
                void ctorArgs;
                KParameter p2;
                Pair p1;
                Iterable $receiver$iv;
                Iterable initial$iv;
                Iterable iterable = ctor.getParameters();
                Pair pair = new Pair(CollectionsKt.emptyList(), scriptArgs);
                Pair<List<Object>, List<String>> accumulator$iv = initial$iv;
                for (Object element$iv : $receiver$iv) {
                    KParameter kParameter = (KParameter)element$iv;
                    p1 = accumulator$iv;
                    accumulator$iv = tryConstructClass.3.INSTANCE.invoke(p1, p2);
                }
                Pair pair2 = accumulator$iv;
                List list2 = (List)pair2.component1();
                List list3 = (List)pair2.component2();
                pair2 = null;
                if (ctorArgs.size() > ctor.getParameters().size() || scriptArgsLeft != null && !scriptArgsLeft.isEmpty()) continue;
                $receiver$iv = (Iterable)ctorArgs;
                initial$iv = ctor.getParameters();
                Iterator first$iv = $receiver$iv.iterator();
                Iterator second$iv = other$iv.iterator();
                ArrayList<Pair<void, void>> list$iv = new ArrayList<Pair<void, void>>(Math.min(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10), CollectionsKt.collectionSizeOrDefault(other$iv, 10)));
                while (first$iv.hasNext() && second$iv.hasNext()) {
                    void a;
                    void p;
                    p2 = (KParameter)second$iv.next();
                    p1 = first$iv.next();
                    ArrayList<Pair<void, void>> arrayList = list$iv;
                    Pair<void, void> pair3 = new Pair<void, void>(p, a);
                    arrayList.add(pair3);
                }
                Map argsMap = MapsKt.toMap((Iterable)list$iv);
                try {
                    return ctor.callBy(argsMap);
                }
                catch (Exception e2) {
                }
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Class<?> compileScript(@NotNull KotlinCoreEnvironment environment2, @NotNull KotlinPaths paths) {
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(paths, "paths");
        KotlinToJVMBytecodeCompiler this_$iv = this;
        GenerationState generationState = this_$iv.analyzeAndGenerate(environment2);
        if (generationState == null) {
            clazz = null;
        } else {
            GenerationState state$iv = generationState;
            try {
                URLClassLoader uRLClassLoader;
                Object object;
                Object object2;
                Collection $receiver$iv;
                GeneratedClassLoader generatedClassLoader;
                ClassFileFactory classFileFactory = state$iv.getFactory();
                GeneratedClassLoader generatedClassLoader2 = generatedClassLoader;
                GeneratedClassLoader generatedClassLoader3 = generatedClassLoader;
                ArrayList<URL> classPaths = CollectionsKt.arrayListOf(paths.getRuntimePath().toURI().toURL());
                Object object3 = JvmContentRootsKt.getJvmClasspathRoots(environment2.getConfiguration());
                for (Object item$iv : $receiver$iv) {
                    void it;
                    File file2 = (File)item$iv;
                    object2 = classPaths;
                    object = it.toURI().toURL();
                    object2.add(object);
                }
                $receiver$iv = classPaths;
                object = uRLClassLoader;
                object2 = uRLClassLoader;
                Collection collection = $receiver$iv;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[thisCollection$iv.size()]);
                if (uRLArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Object[] objectArray = uRLArray;
                ((URLClassLoader)object)((URL[])objectArray);
                Object object4 = object2;
                generatedClassLoader2(classFileFactory, (ClassLoader)object4, new URL[]{null});
                GeneratedClassLoader classLoader$iv = generatedClassLoader3;
                KtScript ktScript = environment2.getSourceFiles().get(0).getScript();
                if (ktScript == null) {
                    object3 = "Script must be parsed";
                    throw (Throwable)new IllegalStateException(object3.toString());
                }
                KtScript script$iv = ktScript;
                clazz = classLoader$iv.loadClass(script$iv.getFqName().asString());
            }
            catch (Exception e$iv) {
                throw (Throwable)new RuntimeException("Failed to evaluate script: " + e$iv, e$iv);
            }
        }
        return clazz;
    }

    @Nullable
    public final Class<?> compileScript(@NotNull KotlinCoreEnvironment environment2, @NotNull ClassLoader parentClassLoader) {
        Class<?> clazz;
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        Intrinsics.checkParameterIsNotNull(parentClassLoader, "parentClassLoader");
        KotlinToJVMBytecodeCompiler this_$iv = this;
        GenerationState generationState = this_$iv.analyzeAndGenerate(environment2);
        if (generationState == null) {
            clazz = null;
        } else {
            GenerationState state$iv = generationState;
            try {
                GeneratedClassLoader generatedClassLoader;
                ClassFileFactory classFileFactory = state$iv.getFactory();
                GeneratedClassLoader generatedClassLoader2 = generatedClassLoader;
                GeneratedClassLoader generatedClassLoader3 = generatedClassLoader;
                ClassLoader classLoader = parentClassLoader;
                generatedClassLoader2(classFileFactory, classLoader, new URL[]{null});
                GeneratedClassLoader classLoader$iv = generatedClassLoader3;
                KtScript ktScript = environment2.getSourceFiles().get(0).getScript();
                if (ktScript == null) {
                    String string = "Script must be parsed";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                KtScript script$iv = ktScript;
                clazz = classLoader$iv.loadClass(script$iv.getFqName().asString());
            }
            catch (Exception e$iv) {
                throw (Throwable)new RuntimeException("Failed to evaluate script: " + e$iv, e$iv);
            }
        }
        return clazz;
    }

    @Nullable
    public final GenerationState analyzeAndGenerate(@NotNull KotlinCoreEnvironment environment2) {
        Intrinsics.checkParameterIsNotNull(environment2, "environment");
        AnalysisResult analysisResult = this.analyze(environment2, null);
        if (analysisResult == null) {
            return null;
        }
        AnalysisResult result2 = analysisResult;
        if (!result2.getShouldGenerateCode()) {
            return null;
        }
        result2.throwIfError();
        return this.generate(environment2, environment2.getConfiguration(), result2, environment2.getSourceFiles(), null);
    }

    private final AnalysisResult analyze(KotlinCoreEnvironment environment2, String targetDescription2) {
        MessageCollector collector2 = this.getMessageCollector(environment2);
        long analysisStart = PerformanceCounter.Companion.currentTime();
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(collector2);
        analyzerWithCompilerReport.analyzeAndReport((Collection<? extends KtFile>)environment2.getSourceFiles(), new AnalyzerWithCompilerReport.Analyzer(environment2, collector2){
            final /* synthetic */ KotlinCoreEnvironment $environment;
            final /* synthetic */ MessageCollector $collector;

            @NotNull
            public AnalysisResult analyze() {
                CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace sharedTrace = new CliLightClassGenerationSupport.NoScopeRecordCliBindingTrace();
                MutableModuleContext moduleContext = TopDownAnalyzerFacadeForJVM.createContextWithSealedModule(this.$environment.getProject(), this.$environment.getConfiguration());
                AnalysisResult analysisResult = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(moduleContext, (Collection<KtFile>)this.$environment.getSourceFiles(), sharedTrace, this.$environment.getConfiguration(), new JvmPackagePartProvider(this.$environment));
                Intrinsics.checkExpressionValueIsNotNull(analysisResult, "TopDownAnalyzerFacadeFor\u2026onment)\n                )");
                return analysisResult;
            }

            public void reportEnvironmentErrors() {
                KotlinToJVMBytecodeCompiler.access$reportRuntimeConflicts(KotlinToJVMBytecodeCompiler.INSTANCE, this.$collector, JvmContentRootsKt.getJvmClasspathRoots(this.$environment.getConfiguration()));
            }
            {
                this.$environment = $captured_local_variable$0;
                this.$collector = $captured_local_variable$1;
            }
        });
        long analysisNanos = PerformanceCounter.Companion.currentTime() - analysisStart;
        int sourceLinesOfCode2 = environment2.getSourceLinesOfCode();
        int numberOfFiles = environment2.getSourceFiles().size();
        long time = TimeUnit.NANOSECONDS.toMillis(analysisNanos);
        float speed = (float)sourceLinesOfCode2 * (float)1000 / (float)time;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder().append("ANALYZE: ").append(numberOfFiles).append(" files (").append(sourceLinesOfCode2).append(" lines) ");
        String string = targetDescription2;
        if (string == null) {
            string = "";
        }
        String string2 = "%.3f";
        Object[] objectArray = new Object[]{Float.valueOf(speed)};
        StringBuilder stringBuilder3 = new StringBuilder().append("in ").append(time).append(" ms - ");
        StringBuilder stringBuilder4 = stringBuilder.append(stringBuilder2.append(string).toString());
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
        String string4 = string3;
        String message = stringBuilder4.append(stringBuilder3.append(string4).append(" loc/s").toString()).toString();
        K2JVMCompiler.Companion.reportPerf(environment2.getConfiguration(), message);
        return analyzerWithCompilerReport.hasErrors() ? (AnalysisResult)null : analyzerWithCompilerReport.getAnalysisResult();
    }

    private final GenerationState generate(KotlinCoreEnvironment environment2, CompilerConfiguration configuration, AnalysisResult result2, List<? extends KtFile> sourceFiles, Module module) {
        File file2;
        String string;
        String string2;
        Module it;
        TargetId targetId;
        TargetId targetId2;
        Object object;
        Object object2;
        Project project;
        ClassBuilderFactory classBuilderFactory;
        ModuleDescriptor moduleDescriptor;
        BindingContext bindingContext;
        List<? extends KtFile> list2;
        CompilerConfiguration compilerConfiguration;
        GenerationState.GenerateClassFilter generateClassFilter2;
        Module module2;
        GenerationState generationState;
        GenerationState generationState2 = generationState;
        GenerationState generationState3 = generationState;
        Project project2 = environment2.getProject();
        ClassBuilderFactory classBuilderFactory2 = ClassBuilderFactories.BINARIES;
        ClassBuilderFactory classBuilderFactory3 = classBuilderFactory2;
        Intrinsics.checkExpressionValueIsNotNull(classBuilderFactory2, "ClassBuilderFactories.BINARIES");
        ModuleDescriptor moduleDescriptor2 = result2.getModuleDescriptor();
        BindingContext bindingContext2 = result2.getBindingContext();
        List<? extends KtFile> list3 = sourceFiles;
        CompilerConfiguration compilerConfiguration2 = configuration;
        GenerationState.GenerateClassFilter generateClassFilter3 = GenerationState.GenerateClassFilter.GENERATE_ALL;
        Module module3 = module;
        if (module3 != null) {
            module2 = module3;
            generateClassFilter2 = generateClassFilter3;
            compilerConfiguration = compilerConfiguration2;
            list2 = list3;
            bindingContext = bindingContext2;
            moduleDescriptor = moduleDescriptor2;
            classBuilderFactory = classBuilderFactory3;
            project = project2;
            object2 = generationState2;
            object = generationState3;
            Module p1 = module2;
            targetId2 = TargetIdKt.TargetId(p1);
            generationState3 = object;
            generationState2 = object2;
            project2 = project;
            classBuilderFactory3 = classBuilderFactory;
            moduleDescriptor2 = moduleDescriptor;
            bindingContext2 = bindingContext;
            list3 = list2;
            compilerConfiguration2 = compilerConfiguration;
            generateClassFilter3 = generateClassFilter2;
            targetId = targetId2;
        } else {
            targetId = null;
        }
        Module module4 = module;
        if (module4 != null) {
            module2 = module4;
            targetId2 = targetId;
            generateClassFilter2 = generateClassFilter3;
            compilerConfiguration = compilerConfiguration2;
            list2 = list3;
            bindingContext = bindingContext2;
            moduleDescriptor = moduleDescriptor2;
            classBuilderFactory = classBuilderFactory3;
            project = project2;
            object2 = generationState2;
            object = generationState3;
            it = module2;
            string2 = it.getModuleName();
            generationState3 = object;
            generationState2 = object2;
            project2 = project;
            classBuilderFactory3 = classBuilderFactory;
            moduleDescriptor2 = moduleDescriptor;
            bindingContext2 = bindingContext;
            list3 = list2;
            compilerConfiguration2 = compilerConfiguration;
            generateClassFilter3 = generateClassFilter2;
            targetId = targetId2;
            string = string2;
        } else {
            string = null;
        }
        Module module5 = module;
        if (module5 != null) {
            module2 = module5;
            string2 = string;
            targetId2 = targetId;
            generateClassFilter2 = generateClassFilter3;
            compilerConfiguration = compilerConfiguration2;
            list2 = list3;
            bindingContext = bindingContext2;
            moduleDescriptor = moduleDescriptor2;
            classBuilderFactory = classBuilderFactory3;
            project = project2;
            object2 = generationState2;
            object = generationState3;
            it = module2;
            File file3 = new File(it.getOutputDirectory());
            generationState3 = object;
            generationState2 = object2;
            project2 = project;
            classBuilderFactory3 = classBuilderFactory;
            moduleDescriptor2 = moduleDescriptor;
            bindingContext2 = bindingContext;
            list3 = list2;
            compilerConfiguration2 = compilerConfiguration;
            generateClassFilter3 = generateClassFilter2;
            targetId = targetId2;
            string = string2;
            file2 = file3;
        } else {
            file2 = null;
        }
        generationState2(project2, classBuilderFactory3, moduleDescriptor2, bindingContext2, list3, compilerConfiguration2, generateClassFilter3, targetId, string, file2, this.createOutputFilesFlushingCallbackIfPossible(configuration));
        GenerationState generationState4 = generationState3;
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        long generationStart = PerformanceCounter.Companion.currentTime();
        KotlinCodegenFacade.compileCorrectFiles(generationState4, CompilationErrorHandler.THROW_EXCEPTION);
        long generationNanos = PerformanceCounter.Companion.currentTime() - generationStart;
        String desc = module != null ? "target " + module.getModuleName() + "-" + module.getModuleType() + " " : "";
        int numberOfSourceFiles = sourceFiles.size();
        int numberOfLines = environment2.countLinesOfCode(sourceFiles);
        long time = TimeUnit.NANOSECONDS.toMillis(generationNanos);
        float speed = (float)numberOfLines * (float)1000 / (float)time;
        String string3 = "%.3f";
        Object[] objectArray = new Object[]{Float.valueOf(speed)};
        object = new StringBuilder().append("GENERATE: ").append(numberOfSourceFiles).append(" files (").append(numberOfLines).append(" lines) ").append(desc).append("in ").append(time).append(" ms - ");
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string4, "java.lang.String.format(this, *args)");
        object2 = string4;
        String message = ((StringBuilder)object).append((String)object2).append(" loc/s").toString();
        K2JVMCompiler.Companion.reportPerf(environment2.getConfiguration(), message);
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        Diagnostics diagnostics2 = generationState4.getCollectedExtraJvmDiagnostics();
        Diagnostics diagnostics3 = result2.getBindingContext().getDiagnostics();
        Intrinsics.checkExpressionValueIsNotNull(diagnostics3, "result.bindingContext.diagnostics");
        AnalyzerWithCompilerReport.Companion.reportDiagnostics(new FilteredJvmDiagnostics(diagnostics2, diagnostics3), this.getMessageCollector(environment2));
        BindingContext bindingContext3 = generationState4.getExtraJvmDiagnosticsTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext3, "generationState.extraJvm\u2026sticsTrace.bindingContext");
        AnalyzerWithCompilerReport.Companion.reportBytecodeVersionErrors(bindingContext3, this.getMessageCollector(environment2));
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        return generationState4;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkKotlinPackageUsage(KotlinCoreEnvironment environment2, Collection<? extends KtFile> files) {
        void $receiver$iv;
        if (environment2.getConfiguration().getBoolean(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE)) {
            return true;
        }
        MessageCollector messageCollector = environment2.getConfiguration().get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.NONE);
        FqName kotlinPackage = FqName.topLevel(Name.identifier("kotlin"));
        Iterable iterable = files;
        for (Object element$iv : $receiver$iv) {
            KtFile it = (KtFile)element$iv;
            FqName fqName2 = it.getPackageFqName();
            FqName fqName3 = kotlinPackage;
            Intrinsics.checkExpressionValueIsNotNull(fqName3, "kotlinPackage");
            if (!FqNamesUtilKt.isSubpackageOf(fqName2, fqName3)) continue;
            KtPackageDirective ktPackageDirective = it.getPackageDirective();
            if (ktPackageDirective == null) {
                Intrinsics.throwNpe();
            }
            messageCollector.report(CompilerMessageSeverity.ERROR, "Only the Kotlin standard library is allowed to use the 'kotlin' package", MessageUtil.psiElementToMessageLocation(ktPackageDirective));
            return false;
        }
        return true;
    }

    private final MessageCollector getMessageCollector(@NotNull KotlinCoreEnvironment $receiver) {
        MessageCollector messageCollector = $receiver.getConfiguration().getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull(messageCollector, "configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        return messageCollector;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportRuntimeConflicts(MessageCollector messageCollector, List<? extends File> jvmClasspathRoots) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Object object;
        File it;
        void var10_10;
        Collection destination$iv$iv2;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        reportRuntimeConflicts.1 removeIdeaVersionSuffix$ = reportRuntimeConflicts.1.INSTANCE;
        Iterable iterable = jvmClasspathRoots;
        void var5_5 = $receiver$iv2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            File file2;
            File file3 = (File)item$iv$iv;
            var10_10 = destination$iv$iv2;
            try {
                file2 = it.getCanonicalFile();
            }
            catch (IOException e) {
                file2 = it;
            }
            object = file2;
            var10_10.add(object);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (File)element$iv$iv;
            if (!(Intrinsics.areEqual(it.getName(), "kotlin-runtime.jar") && it.exists())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List runtimes = (List)destination$iv$iv2;
        $receiver$iv$iv2 = runtimes;
        destination$iv$iv2 = $receiver$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            File $i$a$2$filter = (File)item$iv$iv;
            var10_10 = destination$iv$iv;
            String string = JarUtil.getJarAttribute((File)it2, Attributes.Name.IMPLEMENTATION_VERSION);
            reportRuntimeConflicts.1 var15_16 = reportRuntimeConflicts.1.INSTANCE;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            String string3 = string2;
            object = var15_16.invoke(string3);
            var10_10.add(object);
        }
        List runtimeVersions = (List)destination$iv$iv;
        if (CollectionsKt.toSet(runtimeVersions).size() > 1) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Conflicting versions of Kotlin runtime on classpath: " + CollectionsKt.joinToString$default(runtimes, null, null, null, 0, null, reportRuntimeConflicts.2.INSTANCE, 31, null), CompilerMessageLocation.NO_LOCATION);
        }
    }

    private KotlinToJVMBytecodeCompiler() {
        INSTANCE = this;
    }

    static {
        new KotlinToJVMBytecodeCompiler();
    }

    public static final /* synthetic */ void access$writeOutput(KotlinToJVMBytecodeCompiler $this, @NotNull CompilerConfiguration configuration, @NotNull OutputFileCollection outputFiles, @Nullable FqName mainClass) {
        $this.writeOutput(configuration, outputFiles, mainClass);
    }

    public static final /* synthetic */ void access$reportRuntimeConflicts(KotlinToJVMBytecodeCompiler $this, @NotNull MessageCollector messageCollector, @NotNull List jvmClasspathRoots) {
        $this.reportRuntimeConflicts(messageCollector, jvmClasspathRoots);
    }
}

