/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTTokenNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class TreeBackedLighterAST
extends LighterAST {
    private final FileASTNode myRoot;

    public TreeBackedLighterAST(@NotNull FileASTNode root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/lang/TreeBackedLighterAST", "<init>"));
        }
        super(root.getCharTable());
        this.myRoot = root;
    }

    @Override
    @NotNull
    public LighterASTNode getRoot() {
        LighterASTNode lighterASTNode = TreeBackedLighterAST.wrap(this.myRoot);
        if (lighterASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/TreeBackedLighterAST", "getRoot"));
        }
        return lighterASTNode;
    }

    @Override
    public LighterASTNode getParent(@NotNull LighterASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/lang/TreeBackedLighterAST", "getParent"));
        }
        return TreeBackedLighterAST.wrap(((NodeWrapper)node).myNode.getTreeParent());
    }

    @Override
    @NotNull
    public List<LighterASTNode> getChildren(@NotNull LighterASTNode parent2) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/lang/TreeBackedLighterAST", "getChildren"));
        }
        ASTNode[] children = ((NodeWrapper)parent2).myNode.getChildren(null);
        if (children.length == 0) {
            List<LighterASTNode> list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/TreeBackedLighterAST", "getChildren"));
            }
            return list2;
        }
        ArrayList<LighterASTNode> result2 = new ArrayList<LighterASTNode>(children.length);
        for (ASTNode child : children) {
            result2.add(TreeBackedLighterAST.wrap(child));
        }
        ArrayList<LighterASTNode> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/TreeBackedLighterAST", "getChildren"));
        }
        return arrayList;
    }

    @Override
    public void disposeChildren(@NotNull List<LighterASTNode> children) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "org/jetbrains/kotlin/com/intellij/lang/TreeBackedLighterAST", "disposeChildren"));
        }
    }

    @NotNull
    private static LighterASTNode wrap(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/lang/TreeBackedLighterAST", "wrap"));
        }
        NodeWrapper nodeWrapper = node.getFirstChildNode() == null && node.getTextLength() > 0 ? new TokenNodeWrapper(node) : new NodeWrapper(node);
        if (nodeWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/TreeBackedLighterAST", "wrap"));
        }
        return nodeWrapper;
    }

    @NotNull
    public ASTNode unwrap(@NotNull LighterASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/lang/TreeBackedLighterAST", "unwrap"));
        }
        ASTNode aSTNode = ((NodeWrapper)node).myNode;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/TreeBackedLighterAST", "unwrap"));
        }
        return aSTNode;
    }

    private static class TokenNodeWrapper
    extends NodeWrapper
    implements LighterASTTokenNode {
        public TokenNodeWrapper(ASTNode node) {
            super(node);
        }

        @Override
        public CharSequence getText() {
            return this.myNode.getText();
        }

        @Override
        public String toString() {
            return "token wrapper[" + this.myNode + "]";
        }
    }

    private static class NodeWrapper
    implements LighterASTNode {
        protected final ASTNode myNode;

        public NodeWrapper(ASTNode node) {
            this.myNode = node;
        }

        @Override
        @NotNull
        public IElementType getTokenType() {
            IElementType iElementType = this.myNode.getElementType();
            if (iElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/TreeBackedLighterAST$NodeWrapper", "getTokenType"));
            }
            return iElementType;
        }

        @Override
        public int getStartOffset() {
            return this.myNode.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            return this.myNode.getStartOffset() + this.myNode.getTextLength();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NodeWrapper)) {
                return false;
            }
            NodeWrapper that = (NodeWrapper)o;
            return !(this.myNode != null ? !this.myNode.equals(that.myNode) : that.myNode != null);
        }

        public int hashCode() {
            return this.myNode.hashCode();
        }

        public String toString() {
            return "node wrapper[" + this.myNode + "]";
        }
    }
}

