/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.TypeAliasExpansion;
import org.jetbrains.kotlin.resolve.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeAliasExpander;", "", "reportStrategy", "Lorg/jetbrains/kotlin/resolve/TypeAliasExpansionReportStrategy;", "(Lorg/jetbrains/kotlin/resolve/TypeAliasExpansionReportStrategy;)V", "checkTypeArgumentsSubstitution", "", "unsubstitutedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "substitutedType", "expand", "Lorg/jetbrains/kotlin/types/SimpleType;", "typeAliasExpansion", "Lorg/jetbrains/kotlin/resolve/TypeAliasExpansion;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "expandNonArgumentTypeProjection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "originalProjection", "recursionDepth", "", "expandRecursively", "withAbbreviatedType", "", "expandTypeProjection", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "expandWithoutAbbreviation", "Companion", "kotlin-compiler"})
public final class TypeAliasExpander {
    private final TypeAliasExpansionReportStrategy reportStrategy;
    private static final int MAX_RECURSION_DEPTH = 100;
    @NotNull
    private static final TypeAliasExpander NON_REPORTING;
    public static final Companion Companion;

    @NotNull
    public final SimpleType expand(@NotNull TypeAliasExpansion typeAliasExpansion, @NotNull Annotations annotations2) {
        Intrinsics.checkParameterIsNotNull(typeAliasExpansion, "typeAliasExpansion");
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        return this.expandRecursively(typeAliasExpansion, annotations2, 0, true);
    }

    @NotNull
    public final SimpleType expandWithoutAbbreviation(@NotNull TypeAliasExpansion typeAliasExpansion, @NotNull Annotations annotations2) {
        Intrinsics.checkParameterIsNotNull(typeAliasExpansion, "typeAliasExpansion");
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        return this.expandRecursively(typeAliasExpansion, annotations2, 0, false);
    }

    private final SimpleType expandRecursively(TypeAliasExpansion typeAliasExpansion, Annotations annotations2, int recursionDepth, boolean withAbbreviatedType) {
        SimpleType simpleType2;
        TypeProjectionImpl originalProjection = new TypeProjectionImpl(Variance.INVARIANT, typeAliasExpansion.getDescriptor().getUnderlyingType());
        TypeProjection expandedProjection = this.expandTypeProjection(originalProjection, typeAliasExpansion, null, recursionDepth);
        SimpleType expandedType = TypeSubstitutionKt.asSimpleType(expandedProjection.getType());
        if (expandedType.isError()) {
            return expandedType;
        }
        boolean bl = Intrinsics.areEqual((Object)expandedProjection.getProjectionKind(), (Object)Variance.INVARIANT);
        if (_Assertions.ENABLED && !bl) {
            String string = "Type alias expansion: result for " + typeAliasExpansion.getDescriptor() + " is " + (Object)((Object)expandedProjection.getProjectionKind()) + ", should be invariant";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (withAbbreviatedType) {
            TypeConstructor typeConstructor2 = typeAliasExpansion.getDescriptor().getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "typeAliasExpansion.descriptor.typeConstructor");
            SimpleType abbreviatedType = KotlinTypeFactory.simpleType(annotations2, typeConstructor2, typeAliasExpansion.getArguments(), originalProjection.getType().isMarkedNullable(), MemberScope.Empty.INSTANCE);
            simpleType2 = SpecialTypesKt.withAbbreviation(expandedType, abbreviatedType);
        } else {
            simpleType2 = expandedType;
        }
        return simpleType2;
    }

    private final TypeProjection expandTypeProjection(TypeProjection originalProjection, TypeAliasExpansion typeAliasExpansion, TypeParameterDescriptor typeParameterDescriptor, int recursionDepth) {
        Variance substitutedVariance;
        Variance variance;
        TypeAliasExpander.Companion.assertRecursionDepth(recursionDepth, typeAliasExpansion.getDescriptor());
        KotlinType originalType = originalProjection.getType();
        TypeProjection typeAliasArgument = typeAliasExpansion.getReplacement(originalType.getConstructor());
        if (typeAliasArgument == null) {
            return this.expandNonArgumentTypeProjection(originalProjection, typeAliasExpansion, recursionDepth);
        }
        Variance originalVariance = Intrinsics.areEqual((Object)originalProjection.getProjectionKind(), (Object)Variance.INVARIANT) ^ true ? originalProjection.getProjectionKind() : (typeParameterDescriptor != null ? typeParameterDescriptor.getVariance() : Variance.INVARIANT);
        Variance argumentVariance = typeAliasArgument.getProjectionKind();
        if (Intrinsics.areEqual((Object)argumentVariance, (Object)Variance.INVARIANT)) {
            variance = originalVariance;
        } else if (Intrinsics.areEqual((Object)originalVariance, (Object)Variance.INVARIANT) || Intrinsics.areEqual((Object)originalVariance, (Object)argumentVariance)) {
            variance = argumentVariance;
        } else if (typeAliasArgument.isStarProjection()) {
            variance = argumentVariance;
        } else {
            if (Intrinsics.areEqual((Object)originalVariance, (Object)argumentVariance) ^ true && !typeAliasArgument.isStarProjection()) {
                TypeAliasDescriptor typeAliasDescriptor = typeAliasExpansion.getDescriptor();
                KotlinType kotlinType = typeAliasArgument.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "typeAliasArgument.type");
                this.reportStrategy.conflictingProjection(typeAliasDescriptor, typeParameterDescriptor, kotlinType);
            }
            variance = substitutedVariance = argumentVariance;
        }
        if (typeAliasArgument.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            if (typeParameterDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            TypeProjection typeProjection = TypeUtils.makeStarProjection(typeParameterDescriptor2);
            Intrinsics.checkExpressionValueIsNotNull(typeProjection, "TypeUtils.makeStarProjec\u2026ypeParameterDescriptor!!)");
            return typeProjection;
        }
        KotlinType substitutedType = TypeUtils.makeNullableIfNeeded(typeAliasArgument.getType(), originalType.isMarkedNullable());
        return new TypeProjectionImpl(substitutedVariance, substitutedType);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeProjection expandNonArgumentTypeProjection(TypeProjection originalProjection, TypeAliasExpansion typeAliasExpansion, int recursionDepth) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        SimpleType type2 = TypeSubstitutionKt.asSimpleType(originalProjection.getType());
        if (type2.isError() || !TypeUtilsKt.requiresTypeAliasExpansion(type2)) {
            return originalProjection;
        }
        TypeConstructor typeConstructor2 = type2.getConstructor();
        ClassifierDescriptor typeDescriptor = typeConstructor2.getDeclarationDescriptor();
        boolean bl = typeConstructor2.getParameters().size() == type2.getArguments().size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Unexpected malformed type: " + type2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ClassifierDescriptor classifierDescriptor = typeDescriptor;
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            return originalProjection;
        }
        if (classifierDescriptor instanceof TypeAliasDescriptor) {
            void destination$iv$iv2;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            if (typeAliasExpansion.isRecursion((TypeAliasDescriptor)typeDescriptor)) {
                this.reportStrategy.recursiveTypeAlias((TypeAliasDescriptor)typeDescriptor);
                return new TypeProjectionImpl(Variance.INVARIANT, ErrorUtils.createErrorType("Recursive type alias: " + ((TypeAliasDescriptor)typeDescriptor).getName()));
            }
            Iterable iterable = type2.getArguments();
            void var9_12 = $receiver$iv2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void i;
                void typeAliasArgument;
                int n = index$iv$iv++;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                int n2 = n;
                void var16_26 = destination$iv$iv2;
                TypeProjection typeProjection2 = this.expandTypeProjection((TypeProjection)typeAliasArgument, typeAliasExpansion, typeConstructor2.getParameters().get((int)i), recursionDepth + 1);
                var16_26.add(typeProjection2);
            }
            List expandedArguments = (List)destination$iv$iv2;
            TypeAliasExpansion nestedExpansion = TypeAliasExpansion.Companion.create(typeAliasExpansion, (TypeAliasDescriptor)typeDescriptor, expandedArguments);
            SimpleType expandedType = this.expandRecursively(nestedExpansion, type2.getAnnotations(), recursionDepth + 1, false);
            SimpleType typeWithAbbreviation = DynamicTypesKt.isDynamic(expandedType) ? expandedType : SpecialTypesKt.withAbbreviation(expandedType, type2);
            return new TypeProjectionImpl(originalProjection.getProjectionKind(), typeWithAbbreviation);
        }
        Iterable nestedExpansion = type2.getArguments();
        void expandedType = $receiver$iv;
        Collection typeWithAbbreviation = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void originalArgument;
            int n = index$iv$iv++;
            TypeProjection typeAliasArgument = (TypeProjection)item$iv$iv;
            int i = n;
            void var16_27 = destination$iv$iv;
            TypeProjection typeProjection = this.expandTypeProjection((TypeProjection)originalArgument, typeAliasExpansion, typeConstructor2.getParameters().get(i), recursionDepth + 1);
            var16_27.add(typeProjection);
        }
        List substitutedArguments = (List)destination$iv$iv;
        SimpleType substitutedType = TypeSubstitutionKt.replace$default(type2, substitutedArguments, null, 2, null);
        this.checkTypeArgumentsSubstitution(type2, substitutedType);
        return new TypeProjectionImpl(originalProjection.getProjectionKind(), substitutedType);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeArgumentsSubstitution(KotlinType unsubstitutedType, KotlinType substitutedType) {
        void $receiver$iv;
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(substitutedType);
        Iterable iterable = substitutedType.getArguments();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void substitutedArgument;
            int n = index$iv++;
            TypeProjection typeProjection = (TypeProjection)item$iv;
            int i = n;
            if (substitutedArgument.isStarProjection() || TypeUtilsKt.containsTypeAliasParameters(substitutedArgument.getType())) continue;
            TypeProjection unsubstitutedArgument = unsubstitutedType.getArguments().get(i);
            TypeParameterDescriptor typeParameter = unsubstitutedType.getConstructor().getParameters().get(i);
            DescriptorResolver.checkBoundsInTypeAlias(this.reportStrategy, unsubstitutedArgument.getType(), substitutedArgument.getType(), typeParameter, typeSubstitutor2);
        }
    }

    public TypeAliasExpander(@NotNull TypeAliasExpansionReportStrategy reportStrategy) {
        Intrinsics.checkParameterIsNotNull(reportStrategy, "reportStrategy");
        this.reportStrategy = reportStrategy;
    }

    static {
        Companion = new Companion(null);
        NON_REPORTING = new TypeAliasExpander(TypeAliasExpansionReportStrategy.DO_NOTHING.INSTANCE);
    }

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeAliasExpander$Companion;", "", "()V", "MAX_RECURSION_DEPTH", "", "NON_REPORTING", "Lorg/jetbrains/kotlin/resolve/TypeAliasExpander;", "getNON_REPORTING", "()Lorg/jetbrains/kotlin/resolve/TypeAliasExpander;", "assertRecursionDepth", "", "recursionDepth", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "kotlin-compiler"})
    public static final class Companion {
        private final void assertRecursionDepth(int recursionDepth, TypeAliasDescriptor typeAliasDescriptor) {
            if (recursionDepth > MAX_RECURSION_DEPTH) {
                throw (Throwable)((Object)new AssertionError((Object)("Too deep recursion while expanding type alias " + typeAliasDescriptor.getName())));
            }
        }

        @NotNull
        public final TypeAliasExpander getNON_REPORTING() {
            return NON_REPORTING;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

