/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import com.google.common.collect.Iterables;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.internal.Factory;
import org.gradle.plugin.repository.PluginRepository;
import org.gradle.plugin.repository.internal.PluginRepositoryInternal;
import org.gradle.plugin.repository.internal.PluginRepositoryRegistry;
import org.gradle.plugin.use.resolve.internal.CompositePluginResolver;
import org.gradle.plugin.use.resolve.internal.CorePluginResolver;
import org.gradle.plugin.use.resolve.internal.NoopPluginResolver;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.service.internal.InjectedClasspathPluginResolver;
import org.gradle.plugin.use.resolve.service.internal.PluginResolutionServiceResolver;

class PluginResolverFactory
implements Factory<PluginResolver> {
    private final PluginRegistry pluginRegistry;
    private final DocumentationRegistry documentationRegistry;
    private final PluginResolutionServiceResolver pluginResolutionServiceResolver;
    private final PluginRepositoryRegistry pluginRepositoryRegistry;
    private final InjectedClasspathPluginResolver injectedClasspathPluginResolver;

    PluginResolverFactory(PluginRegistry pluginRegistry, DocumentationRegistry documentationRegistry, PluginResolutionServiceResolver pluginResolutionServiceResolver, PluginRepositoryRegistry pluginRepositoryRegistry, InjectedClasspathPluginResolver injectedClasspathPluginResolver) {
        this.pluginRegistry = pluginRegistry;
        this.documentationRegistry = documentationRegistry;
        this.pluginResolutionServiceResolver = pluginResolutionServiceResolver;
        this.pluginRepositoryRegistry = pluginRepositoryRegistry;
        this.injectedClasspathPluginResolver = injectedClasspathPluginResolver;
    }

    public PluginResolver create() {
        LinkedList<PluginResolver> resolvers = new LinkedList<PluginResolver>();
        this.addDefaultResolvers(resolvers);
        return new CompositePluginResolver(resolvers);
    }

    private void addDefaultResolvers(List<PluginResolver> resolvers) {
        resolvers.add(new NoopPluginResolver(this.pluginRegistry));
        resolvers.add(new CorePluginResolver(this.documentationRegistry, this.pluginRegistry));
        if (!this.injectedClasspathPluginResolver.isClasspathEmpty()) {
            resolvers.add(this.injectedClasspathPluginResolver);
        }
        this.pluginRepositoryRegistry.lock();
        for (PluginRepository pluginRepository : this.pluginRepositoryRegistry.getPluginRepositories()) {
            PluginResolver resolver = ((PluginRepositoryInternal)pluginRepository).asResolver();
            resolvers.add(resolver);
        }
        if (Iterables.isEmpty((Iterable)this.pluginRepositoryRegistry.getPluginRepositories())) {
            resolvers.add(this.pluginResolutionServiceResolver);
        }
    }
}

