/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.service.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.internal.Factory;
import org.gradle.internal.Transformers;
import org.gradle.plugin.internal.PluginId;
import org.gradle.plugin.use.internal.PluginRequest;
import org.gradle.plugin.use.resolve.service.internal.ClientStatus;
import org.gradle.plugin.use.resolve.service.internal.PluginResolutionServiceClient;
import org.gradle.plugin.use.resolve.service.internal.PluginUseMetaData;

public class InMemoryCachingPluginResolutionServiceClient
implements PluginResolutionServiceClient {
    private final Cache<Key<PluginIdentity>, PluginResolutionServiceClient.Response<PluginUseMetaData>> pluginMetadataCache = CacheBuilder.newBuilder().build();
    private final Cache<Key<String>, PluginResolutionServiceClient.Response<ClientStatus>> statusCache = CacheBuilder.newBuilder().build();
    private final PluginResolutionServiceClient delegate;

    public InMemoryCachingPluginResolutionServiceClient(PluginResolutionServiceClient delegate) {
        this.delegate = delegate;
    }

    @Override
    public PluginResolutionServiceClient.Response<PluginUseMetaData> queryPluginMetadata(final String portalUrl, final boolean shouldValidate, final PluginRequest pluginRequest) {
        Key<PluginIdentity> key = new Key<PluginIdentity>(portalUrl, new PluginIdentity(pluginRequest.getId(), pluginRequest.getVersion()));
        return this.getResponse(key, this.pluginMetadataCache, new Factory<PluginResolutionServiceClient.Response<PluginUseMetaData>>(){

            public PluginResolutionServiceClient.Response<PluginUseMetaData> create() {
                return InMemoryCachingPluginResolutionServiceClient.this.delegate.queryPluginMetadata(portalUrl, shouldValidate, pluginRequest);
            }
        }, Transformers.constant(key));
    }

    @Override
    public PluginResolutionServiceClient.Response<ClientStatus> queryClientStatus(final String portalUrl, final boolean shouldValidate, final @Nullable String checksum) {
        return this.getResponse(checksum == null ? null : new Key<String>(portalUrl, checksum), this.statusCache, new Factory<PluginResolutionServiceClient.Response<ClientStatus>>(){

            public PluginResolutionServiceClient.Response<ClientStatus> create() {
                return InMemoryCachingPluginResolutionServiceClient.this.delegate.queryClientStatus(portalUrl, shouldValidate, checksum);
            }
        }, new Transformer<Key<String>, PluginResolutionServiceClient.Response<ClientStatus>>(){

            public Key<String> transform(PluginResolutionServiceClient.Response<ClientStatus> original) {
                return new Key<String>(portalUrl, original.getClientStatusChecksum());
            }
        });
    }

    private <K, V> PluginResolutionServiceClient.Response<V> getResponse(Key<K> key, Cache<Key<K>, PluginResolutionServiceClient.Response<V>> cache, Factory<PluginResolutionServiceClient.Response<V>> responseFactory, Transformer<Key<K>, ? super PluginResolutionServiceClient.Response<V>> keyGenerator) {
        PluginResolutionServiceClient.Response response;
        PluginResolutionServiceClient.Response response2 = response = key == null ? null : (PluginResolutionServiceClient.Response)cache.getIfPresent(key);
        if (response != null) {
            return response;
        }
        response = (PluginResolutionServiceClient.Response)responseFactory.create();
        if (!response.isError()) {
            Key actualKey = (Key)keyGenerator.transform((Object)response);
            cache.put((Object)actualKey, (Object)response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        finally {
            this.pluginMetadataCache.invalidateAll();
            this.statusCache.invalidateAll();
        }
    }

    public static class Key<T> {
        final String portalUrl;
        final T value;

        public Key(String portalUrl, T value) {
            this.portalUrl = portalUrl;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.portalUrl.equals(key.portalUrl)) {
                return false;
            }
            return this.value.equals(key.value);
        }

        public int hashCode() {
            int result = this.portalUrl.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }

    public static class PluginIdentity {
        final PluginId pluginId;
        final String pluginVersion;

        public PluginIdentity(PluginId pluginId, String pluginVersion) {
            this.pluginId = pluginId;
            this.pluginVersion = pluginVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginIdentity that = (PluginIdentity)o;
            if (!this.pluginId.equals((Object)that.pluginId)) {
                return false;
            }
            return this.pluginVersion.equals(that.pluginVersion);
        }

        public int hashCode() {
            int result = this.pluginId.hashCode();
            result = 31 * result + this.pluginVersion.hashCode();
            return result;
        }
    }
}

