/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.tasks.cache.TaskCacheKeyBuilder;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesCollectionSnapshot
implements FileCollectionSnapshot {
    private final Map<String, Boolean> roots;
    private final FileCollectionSnapshot filesSnapshot;

    OutputFilesCollectionSnapshot(Map<String, Boolean> roots, FileCollectionSnapshot filesSnapshot) {
        this.roots = roots;
        this.filesSnapshot = filesSnapshot;
    }

    @Override
    public Collection<File> getFiles() {
        return this.filesSnapshot.getFiles();
    }

    @Override
    public Map<String, NormalizedFileSnapshot> getSnapshots() {
        return this.filesSnapshot.getSnapshots();
    }

    @Override
    public boolean isEmpty() {
        return this.filesSnapshot.isEmpty();
    }

    @Override
    public Iterator<TaskStateChange> iterateContentChangesSince(FileCollectionSnapshot oldSnapshot, String fileType) {
        OutputFilesCollectionSnapshot other = (OutputFilesCollectionSnapshot)oldSnapshot;
        Iterator<TaskStateChange> rootFileIdIterator = this.iterateRootFileIdChanges(other, fileType);
        Iterator<TaskStateChange> fileIterator = this.filesSnapshot.iterateContentChangesSince(other.filesSnapshot, fileType);
        return Iterators.concat(rootFileIdIterator, fileIterator);
    }

    @VisibleForTesting
    Map<String, Boolean> getRoots() {
        return this.roots;
    }

    FileCollectionSnapshot getFilesSnapshot() {
        return this.filesSnapshot;
    }

    private Iterator<TaskStateChange> iterateRootFileIdChanges(OutputFilesCollectionSnapshot other, final String fileType) {
        HashMap<String, Boolean> added = new HashMap<String, Boolean>(this.roots);
        added.keySet().removeAll(other.roots.keySet());
        final Iterator addedIterator = added.keySet().iterator();
        HashMap<String, Boolean> removed = new HashMap<String, Boolean>(other.roots);
        removed.keySet().removeAll(this.roots.keySet());
        final Iterator removedIterator = removed.keySet().iterator();
        HashSet<String> changed = new HashSet<String>();
        for (Map.Entry<String, Boolean> current : this.roots.entrySet()) {
            Boolean otherValue = other.roots.get(current.getKey());
            if (otherValue == null || !otherValue.booleanValue() || otherValue.equals(current.getValue())) continue;
            changed.add(current.getKey());
        }
        final Iterator changedIterator = changed.iterator();
        return new AbstractIterator<TaskStateChange>(){

            protected TaskStateChange computeNext() {
                if (addedIterator.hasNext()) {
                    return new FileChange((String)addedIterator.next(), ChangeType.ADDED, fileType);
                }
                if (removedIterator.hasNext()) {
                    return new FileChange((String)removedIterator.next(), ChangeType.REMOVED, fileType);
                }
                if (changedIterator.hasNext()) {
                    return new FileChange((String)changedIterator.next(), ChangeType.MODIFIED, fileType);
                }
                return (TaskStateChange)this.endOfData();
            }
        };
    }

    @Override
    public void appendToCacheKey(TaskCacheKeyBuilder builder) {
        this.filesSnapshot.appendToCacheKey(builder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SerializerImpl
    implements Serializer<OutputFilesCollectionSnapshot> {
        private final Serializer<FileCollectionSnapshot> serializer;
        private final StringInterner stringInterner;

        public SerializerImpl(Serializer<FileCollectionSnapshot> serializer, StringInterner stringInterner) {
            this.serializer = serializer;
            this.stringInterner = stringInterner;
        }

        public OutputFilesCollectionSnapshot read(Decoder decoder) throws Exception {
            HashMap<String, Boolean> roots = new HashMap<String, Boolean>();
            int rootFileIdsCount = decoder.readSmallInt();
            for (int i = 0; i < rootFileIdsCount; ++i) {
                String path = this.stringInterner.intern(decoder.readString());
                boolean exists = decoder.readBoolean();
                roots.put(path, exists);
            }
            FileCollectionSnapshot snapshot = (FileCollectionSnapshot)this.serializer.read(decoder);
            return new OutputFilesCollectionSnapshot(roots, snapshot);
        }

        public void write(Encoder encoder, OutputFilesCollectionSnapshot value) throws Exception {
            int roots = value.roots.size();
            encoder.writeSmallInt(roots);
            for (Map.Entry entry : value.roots.entrySet()) {
                String path = (String)entry.getKey();
                Boolean exists = (Boolean)entry.getValue();
                encoder.writeString((CharSequence)path);
                encoder.writeBoolean(exists.booleanValue());
            }
            this.serializer.write(encoder, (Object)value.filesSnapshot);
        }
    }
}

