/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.output;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.foundation.output.definitions.ExtensionFileLinkDefinition;
import org.gradle.foundation.output.definitions.FileLinkDefinition;
import org.gradle.foundation.output.definitions.OptionalLineNumberFileLinkDefinition;
import org.gradle.foundation.output.definitions.PrefixedFileLinkDefinition;
import org.gradle.foundation.output.definitions.TestReportFileLinkDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLinkDefinitionLord {
    private List<String> extensions = new ArrayList<String>();
    private Map<Pattern, FileLinkDefinition> complexFileLinkDefinitions = new LinkedHashMap<Pattern, FileLinkDefinition>();
    private Map<Pattern, FileLinkDefinition> extensionFileLinkDefinitions = new LinkedHashMap<Pattern, FileLinkDefinition>();
    private Pattern combinedSearchPattern;

    public FileLinkDefinitionLord() {
        this.addFileExtension(".java", ":");
        this.addFileExtension(".groovy", ":");
        this.addFileExtension(".gradle", ":");
        this.addFileExtension(".xml", ":");
        this.addFileExtension(".html", ":");
        this.addFileExtension(".htm", ":");
        this.addPrefixedFileLink("Ant Compiler Error", "[ant:javac]", ".java", ":");
        this.addPrefixedFileLink("Compiler Warning", "Note:", ".java", null);
        this.addCustomComplexFileLink(new OptionalLineNumberFileLinkDefinition("Build File Errors", "Build file '", ".gradle", "line:"));
        this.addPrefixedFileLink("Ant Checkstyle Error/Warning", "[ant:checkstyle]", ".java", ":");
        this.addPrefixedFileLink("Checkstyle Error (report xml)", "See the report at", ".xml", null);
        this.addPrefixedFileLink("Codenarc Error", "See the report at", ".html", null);
        this.addCustomComplexFileLink(new TestReportFileLinkDefinition());
    }

    public void addFileExtension(String extension, String lineNumberDelimiter) {
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        if (this.extensions.contains(extension = extension.toLowerCase())) {
            return;
        }
        this.extensions.add(extension);
        String name = extension + " Files";
        ExtensionFileLinkDefinition linkDefinition = new ExtensionFileLinkDefinition(name, extension, lineNumberDelimiter);
        this.addToMap(this.extensionFileLinkDefinitions, linkDefinition);
    }

    public void addPrefixedFileLink(String name, String prefix, String extension, String lineNumberDelimiter) {
        PrefixedFileLinkDefinition linkDefinition = new PrefixedFileLinkDefinition(name, prefix, extension, lineNumberDelimiter);
        this.addToMap(this.complexFileLinkDefinitions, linkDefinition);
    }

    private void addCustomComplexFileLink(FileLinkDefinition fileLinkDefinition) {
        this.addToMap(this.complexFileLinkDefinitions, fileLinkDefinition);
    }

    private void addToMap(Map<Pattern, FileLinkDefinition> destinationMap, FileLinkDefinition fileLinkDefinition) {
        this.combinedSearchPattern = null;
        String searchExpression = fileLinkDefinition.getSearchExpression();
        Pattern pattern = Pattern.compile(searchExpression, this.getSearchPatternFlags());
        destinationMap.put(pattern, fileLinkDefinition);
    }

    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public List<FileLinkDefinition> getFileLinkDefinitions() {
        ArrayList<FileLinkDefinition> fileLinkDefinitions = new ArrayList<FileLinkDefinition>();
        fileLinkDefinitions.addAll(this.complexFileLinkDefinitions.values());
        fileLinkDefinitions.addAll(this.extensionFileLinkDefinitions.values());
        return Collections.unmodifiableList(fileLinkDefinitions);
    }

    private int getSearchPatternFlags() {
        return 2;
    }

    public FileLinkDefinition getMatchingFileLinkDefinition(String text) {
        FileLinkDefinition fileLinkDefinition = FileLinkDefinitionLord.getMatchingFileLinkDefinition(text, this.complexFileLinkDefinitions);
        if (fileLinkDefinition == null) {
            fileLinkDefinition = FileLinkDefinitionLord.getMatchingFileLinkDefinition(text, this.extensionFileLinkDefinitions);
        }
        return fileLinkDefinition;
    }

    private static FileLinkDefinition getMatchingFileLinkDefinition(String text, Map<Pattern, FileLinkDefinition> map) {
        for (Pattern pattern : map.keySet()) {
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find(0)) continue;
            return map.get(pattern);
        }
        return null;
    }

    public Pattern getSearchPattern() {
        if (this.combinedSearchPattern == null) {
            this.combinedSearchPattern = this.buildSearchPattern();
        }
        return this.combinedSearchPattern;
    }

    private Pattern buildSearchPattern() {
        StringBuilder criteria = new StringBuilder();
        Iterator<FileLinkDefinition> iterator = this.getFileLinkDefinitions().iterator();
        while (iterator.hasNext()) {
            FileLinkDefinition fileLinkDefinition = iterator.next();
            String searchExpression = fileLinkDefinition.getSearchExpression();
            criteria.append("(").append(searchExpression).append(")");
            if (!iterator.hasNext()) continue;
            criteria.append("|");
        }
        return Pattern.compile(criteria.toString(), this.getSearchPatternFlags());
    }
}

