/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.foundation;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.filechooser.FileFilter;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.gradleplugin.foundation.ExtensionFileFilter;
import org.gradle.gradleplugin.foundation.settings.DOM4JSettingsNode;
import org.gradle.gradleplugin.foundation.settings.SettingsSerializable;

public class DOM4JSerializer {
    private static final Logger LOGGER = Logging.getLogger(DOM4JSerializer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportToFile(String rootElementTag, ExportInteraction exportInteraction, ExtensionFileFilter fileFilter, SettingsSerializable ... serializables) {
        File file = DOM4JSerializer.promptForFile(exportInteraction, fileFilter);
        if (file == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Could not write to file: " + file.getAbsolutePath(), (Throwable)e);
            exportInteraction.reportError("Could not write to file: " + file.getAbsolutePath());
            return;
        }
        try {
            XMLWriter xmlWriter = new XMLWriter((OutputStream)fileOutputStream, OutputFormat.createPrettyPrint());
            Document document = DocumentHelper.createDocument();
            Element rootElement = document.addElement(rootElementTag);
            DOM4JSettingsNode settingsNode = new DOM4JSettingsNode(rootElement);
            for (int index = 0; index < serializables.length; ++index) {
                SettingsSerializable serializable = serializables[index];
                try {
                    serializable.serializeOut(settingsNode);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("serializing", (Throwable)e);
                }
            }
            xmlWriter.write(document);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to save", t);
            exportInteraction.reportError("Internal error. Failed to save.");
        }
        finally {
            DOM4JSerializer.closeQuietly(fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportToFile(ExportInteraction exportInteraction, ExtensionFileFilter fileFilter, DOM4JSettingsNode settingsNode) {
        File file = DOM4JSerializer.promptForFile(exportInteraction, fileFilter);
        if (file == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Could not write to file: " + file.getAbsolutePath(), (Throwable)e);
            exportInteraction.reportError("Could not write to file: " + file.getAbsolutePath());
            return;
        }
        try {
            XMLWriter xmlWriter = new XMLWriter((OutputStream)fileOutputStream, OutputFormat.createPrettyPrint());
            Element rootElement = settingsNode.getElement();
            rootElement.detach();
            Document document = DocumentHelper.createDocument((Element)rootElement);
            xmlWriter.write(document);
        }
        catch (Throwable t) {
            LOGGER.error("Internal error. Failed to save.", t);
            exportInteraction.reportError("Internal error. Failed to save.");
        }
        finally {
            DOM4JSerializer.closeQuietly(fileOutputStream);
        }
    }

    private static File promptForFile(ExportInteraction exportInteraction, ExtensionFileFilter fileFilter) {
        boolean promptAgain = false;
        File file = null;
        int counter = 0;
        do {
            promptAgain = false;
            file = exportInteraction.promptForFile(fileFilter);
            if (file == null || !(file = DOM4JSerializer.ensureFileHasCorrectExtensionAndCase(file, fileFilter.getExtension())).exists()) continue;
            promptAgain = !exportInteraction.confirmOverwritingExistingFile(file);
        } while (promptAgain && ++counter < 1000);
        return file;
    }

    public static boolean importFromFile(ImportInteraction importInteraction, FileFilter fileFilter, SettingsSerializable ... serializables) {
        DOM4JSettingsNode settings = DOM4JSerializer.readSettingsFile(importInteraction, fileFilter);
        if (settings == null) {
            return false;
        }
        for (int index = 0; index < serializables.length; ++index) {
            SettingsSerializable serializable = serializables[index];
            try {
                serializable.serializeIn(settings);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("importing file", (Throwable)e);
            }
        }
        return true;
    }

    public static DOM4JSettingsNode readSettingsFile(ImportInteraction importInteraction, FileFilter fileFilter) {
        File file = importInteraction.promptForFile(fileFilter);
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            importInteraction.reportError("File does not exist: " + file.getAbsolutePath());
            return null;
        }
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(file);
            return new DOM4JSettingsNode(document.getRootElement());
        }
        catch (Throwable t) {
            LOGGER.error("Unable to read file: " + file.getAbsolutePath(), t);
            importInteraction.reportError("Unable to read file: " + file.getAbsolutePath());
            return null;
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Closing", (Throwable)e);
        }
    }

    private static File ensureFileHasCorrectExtensionAndCase(File file, String requiredExtension) {
        String name = file.getName();
        if (!name.toLowerCase().endsWith(requiredExtension.toLowerCase())) {
            return new File(file.getParentFile(), name + requiredExtension);
        }
        return file;
    }

    public static DOM4JSettingsNode createBlankSettings() {
        Document document = DocumentHelper.createDocument();
        Element rootElement = document.addElement("root");
        DOM4JSettingsNode settings = new DOM4JSettingsNode(rootElement);
        return settings;
    }

    public static interface ImportInteraction {
        public File promptForFile(FileFilter var1);

        public void reportError(String var1);
    }

    public static interface ExportInteraction {
        public File promptForFile(FileFilter var1);

        public void reportError(String var1);

        public boolean confirmOverwritingExistingFile(File var1);
    }
}

