/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.profile.commands;

import grails.build.logging.GrailsConsole;
import grails.config.ConfigMap;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.cli.profile.Command;
import org.grails.cli.profile.CommandDescription;
import org.grails.cli.profile.ExecutionContext;
import org.grails.cli.profile.Feature;
import org.grails.cli.profile.Profile;
import org.grails.cli.profile.ProfileRepository;
import org.grails.cli.profile.ProfileRepositoryAware;
import org.grails.cli.profile.ProjectContext;
import org.grails.cli.profile.commands.ArgumentCompletingCommand;
import org.grails.config.CodeGenConfig;

public class ProfileInfoCommand
extends ArgumentCompletingCommand
implements ProfileRepositoryAware {
    public static final String NAME = "profile-info";
    private final String name;
    private final CommandDescription description;
    private ProfileRepository profileRepository;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ProfileInfoCommand() {
        MetaClass metaClass;
        CommandDescription commandDescription;
        String string;
        this.name = string = NAME;
        this.description = commandDescription = new CommandDescription(this.name, "Display information about a given profile");
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description.argument(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Profile Name", "description", "The name or coordinates of the profile", "required", true}));
    }

    @Override
    public void setProfileRepository(ProfileRepository profileRepository) {
        ProfileRepository profileRepository2;
        this.profileRepository = profileRepository2 = profileRepository;
    }

    @Override
    public boolean handle(ExecutionContext executionContext) {
        GrailsConsole console = executionContext.getConsole();
        if (this.profileRepository == null) {
            console.error("No profile repository provided");
            return false;
        }
        String profileName = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)executionContext.getCommandLine().getRemainingArgs(), (int)0));
        Profile profile = this.profileRepository.getProfile(profileName);
        if (profile == null) {
            console.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{profileName}, new String[]{"Profile not found for name [", "]"})));
        } else {
            console.log(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{profile.getName()}, new String[]{"Profile: ", ""})));
            console.log("--------------------");
            console.log(profile.getDescription());
            console.log("");
            console.log("Provided Commands:");
            console.log("--------------------");
            public class _handle_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _handle_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Command c) {
                    return c.getName();
                }

                public Object call(Command c) {
                    return this.doCall(c);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _handle_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Collection commands = DefaultGroovyMethods.toUnique(this.findCommands(profile, console), (Closure)new _handle_closure1(this, this));
            Command cmd = null;
            Iterator iterator = commands.iterator();
            while (iterator.hasNext()) {
                cmd = (Command)ScriptBytecodeAdapter.castToType(iterator.next(), Command.class);
                CommandDescription description = cmd.getDescription();
                console.log(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{description.getName(), description.getDescription()}, new String[]{"* ", " - ", ""})));
            }
            console.log("");
            console.log("Provided Features:");
            console.log("--------------------");
            Iterable<Feature> features = profile.getFeatures();
            Feature feature = null;
            Iterator<Feature> iterator2 = features.iterator();
            while (iterator2.hasNext()) {
                feature = (Feature)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), Feature.class);
                console.log(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{feature.getName(), feature.getDescription()}, new String[]{"* ", " - ", ""})));
            }
        }
        return true;
    }

    protected Iterable<Command> findCommands(Profile profile, GrailsConsole console) {
        Reference console2 = new Reference((Object)console);
        Iterable<Command> commands = profile.getCommands(new ProjectContext(this, console2){
            public /* synthetic */ Reference console;
            public /* synthetic */ ProfileInfoCommand this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                ProfileInfoCommand profileInfoCommand;
                this.this$0 = profileInfoCommand = p0;
                this.console = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public GrailsConsole getConsole() {
                return (GrailsConsole)ScriptBytecodeAdapter.castToType((Object)this.console.get(), GrailsConsole.class);
            }

            @Override
            public File getBaseDir() {
                return new File(".");
            }

            @Override
            public ConfigMap getConfig() {
                return new CodeGenConfig();
            }

            @Override
            public String navigateConfig(String ... path) {
                return ShortTypeHandling.castToString((Object)this.getConfig().navigate(path));
            }

            @Override
            public <T> T navigateConfigForType(Class<T> requiredType, String ... path) {
                return (T)this.getConfig().navigate(path);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$2(name, args);
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$2(name, val);
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$2(name);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        });
        return commands;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProfileInfoCommand.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ProfileInfoCommand.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ProfileInfoCommand.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ProfileInfoCommand.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public final CommandDescription getDescription() {
        return this.description;
    }

    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }
}

