/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli;

import java.util.ServiceLoader;
import org.springframework.boot.cli.command.CommandFactory;
import org.springframework.boot.cli.command.CommandRunner;
import org.springframework.boot.cli.command.core.HelpCommand;
import org.springframework.boot.cli.command.core.HintCommand;
import org.springframework.boot.cli.command.core.VersionCommand;
import org.springframework.boot.cli.command.shell.ShellCommand;
import org.springframework.boot.loader.tools.LogbackInitializer;

public final class SpringCli {
    private SpringCli() {
    }

    public static void main(String ... args) {
        System.setProperty("java.awt.headless", Boolean.toString(true));
        LogbackInitializer.initialize();
        CommandRunner runner = new CommandRunner("spring");
        runner.addCommand(new HelpCommand(runner));
        SpringCli.addServiceLoaderCommands(runner);
        runner.addCommand(new ShellCommand());
        runner.addCommand(new HintCommand(runner));
        runner.setOptionCommands(HelpCommand.class, VersionCommand.class);
        runner.setHiddenCommands(HintCommand.class);
        int exitCode = runner.runAndHandleErrors(args);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    private static void addServiceLoaderCommands(CommandRunner runner) {
        ServiceLoader<CommandFactory> factories = ServiceLoader.load(CommandFactory.class, runner.getClass().getClassLoader());
        for (CommandFactory factory : factories) {
            runner.addCommands(factory.getCommands());
        }
    }
}

