/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnContainer;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.SwitchRegion;
import jadx.core.dex.regions.SynchronizedRegion;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.regions.AbstractRegionVisitor;
import jadx.core.dex.visitors.regions.CleanRegions;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.ProcessTryCatchRegions;
import jadx.core.dex.visitors.regions.RegionMaker;
import jadx.core.dex.visitors.regions.RegionStack;
import jadx.core.utils.InstructionRemover;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionMakerVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(RegionMakerVisitor.class);
    private static final PostRegionVisitor POST_REGION_VISITOR = new PostRegionVisitor();

    @Override
    public void visit(MethodNode mth) throws JadxException {
        if (mth.isNoCode()) {
            return;
        }
        RegionMaker rm = new RegionMaker(mth);
        RegionStack state = new RegionStack(mth);
        mth.setRegion(rm.makeRegion(mth.getEnterBlock(), state));
        if (!mth.isNoExceptionHandlers()) {
            rm.processTryCatchBlocks(mth);
        }
        RegionMakerVisitor.postProcessRegions(mth);
    }

    private static void postProcessRegions(MethodNode mth) {
        ProcessTryCatchRegions.process(mth);
        DepthRegionTraversal.traverse(mth, POST_REGION_VISITOR);
        CleanRegions.process(mth);
        if (mth.getAccessFlags().isSynchronized()) {
            RegionMakerVisitor.removeSynchronized(mth);
        }
    }

    private static void processSwitch(MethodNode mth, SwitchRegion sw) {
        for (IContainer c : sw.getBranches()) {
            if (!(c instanceof Region)) continue;
            HashSet<IBlock> blocks = new HashSet<IBlock>();
            RegionUtils.getAllRegionBlocks(c, blocks);
            if (blocks.isEmpty()) {
                RegionMakerVisitor.addBreakToContainer((Region)c);
                continue;
            }
            block1: for (IBlock block : blocks) {
                if (!(block instanceof BlockNode)) continue;
                BlockNode bn = (BlockNode)block;
                for (BlockNode s : bn.getCleanSuccessors()) {
                    if (blocks.contains(s) || bn.contains(AFlag.SKIP) || s.contains(AFlag.FALL_THROUGH)) continue;
                    RegionMakerVisitor.addBreak(mth, c, bn);
                    continue block1;
                }
            }
        }
    }

    private static void addBreak(MethodNode mth, IContainer c, BlockNode bn) {
        IContainer blockContainer = RegionUtils.getBlockContainer(c, bn);
        if (blockContainer instanceof Region) {
            RegionMakerVisitor.addBreakToContainer((Region)blockContainer);
        } else if (c instanceof Region) {
            RegionMakerVisitor.addBreakToContainer((Region)c);
        } else {
            LOG.warn("Can't insert break, container: {}, block: {}, mth: {}", new Object[]{blockContainer, bn, mth});
        }
    }

    private static void addBreakToContainer(Region c) {
        if (RegionUtils.hasExitEdge(c)) {
            return;
        }
        ArrayList<InsnNode> insns = new ArrayList<InsnNode>(1);
        insns.add(new InsnNode(InsnType.BREAK, 0));
        c.add(new InsnContainer(insns));
    }

    private static void removeSynchronized(MethodNode mth) {
        Region startRegion = mth.getRegion();
        List<IContainer> subBlocks = startRegion.getSubBlocks();
        if (!subBlocks.isEmpty() && subBlocks.get(0) instanceof SynchronizedRegion) {
            SynchronizedRegion synchRegion = (SynchronizedRegion)subBlocks.get(0);
            InsnNode synchInsn = synchRegion.getEnterInsn();
            if (!synchInsn.getArg(0).isThis()) {
                LOG.warn("In synchronized method {}, top region not synchronized by 'this' {}", (Object)mth, (Object)synchInsn);
                return;
            }
            startRegion.getSubBlocks().set(0, synchRegion.getRegion());
            InstructionRemover.remove(mth, synchInsn);
            for (InsnNode exit : synchRegion.getExitInsns()) {
                InstructionRemover.remove(mth, exit);
            }
            CleanRegions.process(mth);
        }
    }

    private static final class PostRegionVisitor
    extends AbstractRegionVisitor {
        private PostRegionVisitor() {
        }

        @Override
        public void leaveRegion(MethodNode mth, IRegion region) {
            if (region instanceof LoopRegion) {
                LoopRegion loop = (LoopRegion)region;
                loop.mergePreCondition();
            } else if (region instanceof SwitchRegion) {
                RegionMakerVisitor.processSwitch(mth, (SwitchRegion)region);
            }
        }
    }
}

