/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class HistoryFile {
    private Properties properties = new Properties();
    File file;
    String header;

    public HistoryFile(File file, String header) {
        this.file = file;
        this.header = header;
        this.load();
    }

    public void addProperties(Properties properties) {
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            this.addProperty(key, value);
        }
        this.save();
    }

    public Properties getProperties() {
        return new Properties(this.properties);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public boolean addProperty(String key, String value) {
        boolean modified = false;
        Object oldValue = this.properties.setProperty(key, value);
        if (!value.equals(oldValue)) {
            modified = true;
        }
        return modified;
    }

    public Point getWindowPosition(String name) {
        Point result = null;
        if (name != null) {
            try {
                String x = this.getProperty("Jmol.window." + name + ".x", null);
                String y = this.getProperty("Jmol.window." + name + ".y", null);
                if (x != null && y != null) {
                    int posX = Integer.parseInt(x);
                    int posY = Integer.parseInt(y);
                    result = new Point(posX, posY);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public Point getWindowBorder(String name) {
        Point result = null;
        try {
            String x = this.getProperty("Jmol.windowBorder." + name + ".x", null);
            String y = this.getProperty("Jmol.windowBorder." + name + ".y", null);
            if (x != null && y != null) {
                int X = Integer.parseInt(x);
                int Y = Integer.parseInt(y);
                result = new Point(X, Y);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Dimension getWindowSize(String name) {
        Dimension result = null;
        if (name != null) {
            try {
                String w = this.getProperty("Jmol.window." + name + ".w", null);
                String h = this.getProperty("Jmol.window." + name + ".h", null);
                if (w != null && h != null) {
                    int dimW = Integer.parseInt(w);
                    int dimH = Integer.parseInt(h);
                    result = new Dimension(dimW, dimH);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private Boolean getWindowVisibility(String name) {
        Boolean result = null;
        if (name != null) {
            try {
                String v = this.getProperty("Jmol.window." + name + ".visible", null);
                if (v != null) {
                    result = Boolean.valueOf(v);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean addWindowPosition(String name, Point position) {
        boolean modified = false;
        if (name != null && position != null) {
            modified |= this.addProperty("Jmol.window." + name + ".x", "" + position.x);
            modified |= this.addProperty("Jmol.window." + name + ".y", "" + position.y);
        }
        return modified;
    }

    private boolean addWindowBorder(String name, Point border) {
        boolean modified = false;
        if (name != null && border != null) {
            modified |= this.addProperty("Jmol.windowBorder." + name + ".x", "" + border.x);
            modified |= this.addProperty("Jmol.windowBorder." + name + ".y", "" + border.y);
        }
        return modified;
    }

    private boolean addWindowSize(String name, Dimension size) {
        boolean modified = false;
        if (name != null && size != null) {
            modified |= this.addProperty("Jmol.window." + name + ".w", "" + size.width);
            modified |= this.addProperty("Jmol.window." + name + ".h", "" + size.height);
        }
        return modified;
    }

    private boolean addWindowVisibility(String name, boolean visible) {
        boolean modified = false;
        if (name != null) {
            modified |= this.addProperty("Jmol.window." + name + ".visible", "" + visible);
        }
        return modified;
    }

    public void addWindowInfo(String name, Component window, Point border) {
        if (window != null) {
            boolean modified = false;
            modified |= this.addWindowPosition(name, window.getLocation());
            modified |= this.addWindowSize(name, window.getSize());
            modified |= this.addWindowBorder(name, border);
            if (modified |= this.addWindowVisibility(name, window.isVisible())) {
                this.save();
            }
        }
    }

    public void repositionWindow(String name, Component window, int minWidth, int minHeight, boolean allowVisible) {
        if (window != null) {
            Point position = this.getWindowPosition(name);
            Dimension size = this.getWindowSize(name);
            Boolean visible = this.getWindowVisibility(name);
            if (position != null) {
                window.setLocation(position);
            }
            if (size != null) {
                if (size.width < minWidth) {
                    size.width = minWidth;
                }
                if (size.height < minHeight) {
                    size.height = minHeight;
                }
                window.setSize(size);
            }
            if (allowVisible && visible != null && visible.booleanValue()) {
                window.setVisible(true);
            }
        }
    }

    public void repositionWindow(String name, Component window) {
        this.repositionWindow(name, window, 10, 10, true);
    }

    public File getFile() {
        return this.file;
    }

    private void load() {
        if (this.file == null) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(this.file);
            this.properties.load(input);
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save() {
        if (this.file == null) {
            return;
        }
        try {
            FileOutputStream output = new FileOutputStream(this.file);
            this.properties.store(output, this.header);
            output.close();
        }
        catch (IOException ex) {
            System.err.println("Error saving history: " + ex);
        }
    }

    public void clear() {
        if (this.file == null) {
            return;
        }
        try {
            FileOutputStream output = new FileOutputStream(this.file);
            output.close();
        }
        catch (IOException ex) {
            System.err.println("Error clearing history: " + ex);
        }
    }
}

