/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import javajs.util.DF;
import javajs.util.SB;
import jspecview.common.Coordinate;
import jspecview.export.Exporter;
import org.jmol.util.Logger;

class JDXCompressor {
    static final String spaces = "                    ";

    JDXCompressor() {
    }

    static String compressDIF(Coordinate[] coordinateArray, int n, int n2, int n3, double d, double d2, boolean bl) {
        SB sB = new SB();
        SB sB2 = new SB();
        for (int i = n; i != n2; i += n3) {
            sB2.append(JDXCompressor.fixIntNoExponent(coordinateArray[i].getXVal() / d));
            sB.setLength(0);
            if (Logger.debugging) {
                Logger.info("" + i + '\t' + coordinateArray[i].getXVal() + '\t' + coordinateArray[i].getYVal());
            }
            long l = Math.round(coordinateArray[i].getYVal() / d2);
            sB.append(JDXCompressor.makeSQZ(l));
            String string = "";
            int n4 = 0;
            if ((i += n3) == n2) {
                i -= n3;
            } else {
                while (i + n3 != n2 && sB.length() < 50) {
                    long l2 = Math.round(coordinateArray[i].getYVal() / d2);
                    String string2 = JDXCompressor.makeDIF(l2 - l);
                    if (bl && string2.equals(string)) {
                        ++n4;
                    } else {
                        string = string2;
                        if (n4 > 0) {
                            sB.append(JDXCompressor.makeDUP(n4 + 1));
                            n4 = 0;
                        }
                        sB.append(string2);
                    }
                    if (Logger.debugging) {
                        Logger.info("" + i + '\t' + coordinateArray[i].getXVal() + '\t' + coordinateArray[i].getYVal() + '\t' + l2 + '\t' + n4 + '\t' + sB);
                    }
                    l = l2;
                    i += n3;
                }
                if (n4 > 0) {
                    sB.append(JDXCompressor.makeDUP(n4 + 1));
                }
                sB.append(JDXCompressor.makeSQZ(coordinateArray[i], d2));
                if (Logger.debugging) {
                    Logger.info("" + i + '\t' + coordinateArray[i].getXVal() + '\t' + coordinateArray[i].getYVal() + '\t' + n4 + '\t' + sB);
                }
            }
            sB2.append(sB.toString()).append(Exporter.newLine);
        }
        sB2.append(JDXCompressor.fixIntNoExponent(coordinateArray[n2].getXVal() / d)).append(JDXCompressor.makeSQZ(coordinateArray[n2], d2));
        sB2.append("  $$checkpoint").append(Exporter.newLine);
        return sB2.toString();
    }

    static String compressFIX(Coordinate[] coordinateArray, int n, int n2, int n3, double d, double d2) {
        n2 += n3;
        SB sB = new SB();
        int n4 = n;
        while (n4 != n2) {
            JDXCompressor.leftJustify(sB, "              ", JDXCompressor.fixIntNoExponent(coordinateArray[n4].getXVal() / d));
            for (int i = 0; i < 6 && n4 != n2; n4 += n3, ++i) {
                JDXCompressor.rightJustify(sB, "          ", "" + Math.round(coordinateArray[n4].getYVal() / d2));
                sB.append(" ");
            }
            sB.append(Exporter.newLine);
        }
        return sB.toString();
    }

    public static void leftJustify(SB sB, String string, String string2) {
        sB.append(string2);
        int n = string.length() - string2.length();
        if (n > 0) {
            sB.append(string.substring(0, n));
        }
    }

    public static void rightJustify(SB sB, String string, String string2) {
        int n = string.length() - string2.length();
        if (n > 0) {
            sB.append(string.substring(0, n));
        }
        sB.append(string2);
    }

    static String compressSQZ(Coordinate[] coordinateArray, int n, int n2, int n3, double d, double d2) {
        SB sB = new SB();
        n2 += n3;
        SB sB2 = new SB();
        int n4 = n;
        while (n4 == n || n4 != n2) {
            sB2.append(JDXCompressor.fixIntNoExponent(coordinateArray[n4].getXVal() / d));
            sB.setLength(0);
            sB.append(JDXCompressor.makeSQZ(coordinateArray[n4], d2));
            n4 += n3;
            while (sB.length() < 60 && n4 != n2) {
                sB.append(JDXCompressor.makeSQZ(coordinateArray[n4], d2));
                n4 += n3;
            }
            sB2.append(sB.toString()).append(Exporter.newLine);
        }
        return sB2.toString();
    }

    static String compressPAC(Coordinate[] coordinateArray, int n, int n2, int n3, double d, double d2) {
        SB sB = new SB();
        n2 += n3;
        int n4 = n;
        while (n4 != n2) {
            sB.append(JDXCompressor.fixIntNoExponent(coordinateArray[n4].getXVal() / d)).append(JDXCompressor.fixPacY(coordinateArray[n4].getYVal() / d2));
            n4 += n3;
            for (int i = 0; i < 4 && n4 != n2; n4 += n3, ++i) {
                sB.append(JDXCompressor.fixPacY(coordinateArray[n4].getYVal() / d2));
            }
            sB.append(Exporter.newLine);
        }
        return sB.toString();
    }

    private static String fixPacY(double d) {
        return (d < 0.0 ? "" : " ") + JDXCompressor.fixIntNoExponent(d);
    }

    private static String makeSQZ(Coordinate coordinate, double d) {
        return JDXCompressor.makeSQZ(Math.round(coordinate.getYVal() / d));
    }

    private static String makeSQZ(long l) {
        return JDXCompressor.compress(l, "@ABCDEFGHI", "abcdefghi");
    }

    private static String makeDIF(long l) {
        return JDXCompressor.compress(l, "%JKLMNOPQR", "jklmnopqr");
    }

    private static String makeDUP(long l) {
        return JDXCompressor.compress(l, "0STUVWXYZs", "");
    }

    private static String compress(long l, String string, String string2) {
        boolean bl = false;
        String string3 = String.valueOf(l);
        char c = string3.charAt(0);
        if (c == '-') {
            bl = true;
            string3 = string3.substring(1);
            c = string3.charAt(0);
        }
        char[] cArray = string3.toCharArray();
        cArray[0] = bl ? string2.charAt(c - 49) : string.charAt(c - 48);
        return new String(cArray);
    }

    static String getXYList(Coordinate[] coordinateArray, int n, int n2, int n3) {
        n2 += n3;
        SB sB = new SB();
        for (int i = n; i != n2; i += n3) {
            Coordinate coordinate = coordinateArray[i];
            sB.append(JDXCompressor.fixIntNoExponent(coordinate.getXVal())).append(", ").append(JDXCompressor.fixIntNoExponent(coordinate.getYVal())).append(Exporter.newLine);
        }
        return sB.toString();
    }

    private static String fixIntNoExponent(double d) {
        return d == Math.floor(d) ? String.valueOf((int)d) : DF.formatDecimalTrimmed(d, 10);
    }
}

