/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class DatasetConsistencyTest {
    private static final int MAX_ERRORS = 100;
    private final DataSet dataSet;
    private final PrintWriter writer;
    private int errorCount;

    public DatasetConsistencyTest(DataSet dataSet, Writer writer) {
        this.dataSet = dataSet;
        this.writer = new PrintWriter(writer);
    }

    private void printError(String string, String string2, Object ... objectArray) {
        ++this.errorCount;
        if (this.errorCount <= 100) {
            this.writer.println('[' + string + "] " + String.format(string2, objectArray));
        }
    }

    public void checkReferrers() {
        long l = System.currentTimeMillis();
        for (Way osmPrimitive : this.dataSet.getWays()) {
            if (osmPrimitive.isDeleted()) continue;
            for (Node node : osmPrimitive.getNodes()) {
                if (node.getDataSet() == null || node.getReferrers().contains(osmPrimitive)) continue;
                this.printError("WAY NOT IN REFERRERS", "%s is part of %s but is not in referrers", node, osmPrimitive);
            }
        }
        for (Relation relation : this.dataSet.getRelations()) {
            if (relation.isDeleted()) continue;
            for (RelationMember relationMember : relation.getMembers()) {
                if (relationMember.getMember().getDataSet() == null || relationMember.getMember().getReferrers().contains(relation)) continue;
                this.printError("RELATION NOT IN REFERRERS", "%s is part of %s but is not in referrers", relationMember.getMember(), relation);
            }
        }
        this.printElapsedTime(l);
    }

    public void checkCompleteWaysWithIncompleteNodes() {
        long l = System.currentTimeMillis();
        for (Way way : this.dataSet.getWays()) {
            if (!way.isUsable()) continue;
            for (Node node : way.getNodes()) {
                if (!node.isIncomplete()) continue;
                this.printError("USABLE HAS INCOMPLETE", "%s is usable but contains incomplete node '%s'", way, node);
            }
        }
        this.printElapsedTime(l);
    }

    public void checkCompleteNodesWithoutCoordinates() {
        long l = System.currentTimeMillis();
        for (Node node : this.dataSet.getNodes()) {
            if (node.isIncomplete() || !node.isVisible() || node.isLatLonKnown()) continue;
            this.printError("COMPLETE WITHOUT COORDINATES", "%s is not incomplete but has null coordinates", node);
        }
        this.printElapsedTime(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchNodes() {
        long l = System.currentTimeMillis();
        this.dataSet.getReadLock().lock();
        try {
            for (Node node : this.dataSet.getNodes()) {
                if (!node.isDrawable() || this.dataSet.containsNode(node)) continue;
                this.printError("SEARCH NODES", "%s not found using Dataset.containsNode()", node);
            }
        }
        finally {
            this.dataSet.getReadLock().unlock();
        }
        this.printElapsedTime(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchWays() {
        long l = System.currentTimeMillis();
        this.dataSet.getReadLock().lock();
        try {
            for (Way way : this.dataSet.getWays()) {
                if (way.isIncomplete() || way.isDeleted() || way.getNodesCount() < 2 || this.dataSet.containsWay(way)) continue;
                this.printError("SEARCH WAYS", "%s not found using Dataset.containsWay()", way);
            }
        }
        finally {
            this.dataSet.getReadLock().unlock();
        }
        this.printElapsedTime(l);
    }

    private void checkReferredPrimitive(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        if (osmPrimitive.getDataSet() == null) {
            this.printError("NO DATASET", "%s is referenced by %s but not found in dataset", osmPrimitive, osmPrimitive2);
        } else if (this.dataSet.getPrimitiveById(osmPrimitive) == null) {
            this.printError("REFERENCED BUT NOT IN DATA", "%s is referenced by %s but not found in dataset", osmPrimitive, osmPrimitive2);
        } else if (this.dataSet.getPrimitiveById(osmPrimitive) != osmPrimitive) {
            this.printError("DIFFERENT INSTANCE", "%s is different instance that referred by %s", osmPrimitive, osmPrimitive2);
        }
        if (osmPrimitive.isDeleted()) {
            this.printError("DELETED REFERENCED", "%s refers to deleted primitive %s", osmPrimitive2, osmPrimitive);
        }
    }

    public void referredPrimitiveNotInDataset() {
        long l = System.currentTimeMillis();
        for (Way osmPrimitive : this.dataSet.getWays()) {
            for (Node node : osmPrimitive.getNodes()) {
                this.checkReferredPrimitive(node, osmPrimitive);
            }
        }
        for (Relation relation : this.dataSet.getRelations()) {
            for (RelationMember relationMember : relation.getMembers()) {
                this.checkReferredPrimitive(relationMember.getMember(), relation);
            }
        }
        this.printElapsedTime(l);
    }

    public void checkZeroNodesWays() {
        long l = System.currentTimeMillis();
        for (Way way : this.dataSet.getWays()) {
            if (way.isUsable() && way.getNodesCount() == 0) {
                this.printError("WARN - ZERO NODES", "Way %s has zero nodes", way);
                continue;
            }
            if (!way.isUsable() || way.getNodesCount() != 1) continue;
            this.printError("WARN - NO NODES", "Way %s has only one node", way);
        }
        this.printElapsedTime(l);
    }

    private void printElapsedTime(long l) {
        if (Main.isDebugEnabled()) {
            StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
            String string = this.getClass().getSimpleName() + '.' + stackTraceElement.getMethodName();
            long l2 = System.currentTimeMillis() - l;
            Main.debug(I18n.tr("Test ''{0}'' completed in {1}", string, Utils.getDurationString(l2)));
        }
    }

    public void runTest() {
        try {
            long l = System.currentTimeMillis();
            this.referredPrimitiveNotInDataset();
            this.checkReferrers();
            this.checkCompleteWaysWithIncompleteNodes();
            this.checkCompleteNodesWithoutCoordinates();
            this.searchNodes();
            this.searchWays();
            this.checkZeroNodesWays();
            this.printElapsedTime(l);
            if (this.errorCount > 100) {
                this.writer.println(this.errorCount - 100 + " more...");
            }
        }
        catch (RuntimeException runtimeException) {
            this.writer.println("Exception during dataset integrity test:");
            runtimeException.printStackTrace(this.writer);
            Main.warn(runtimeException);
        }
    }

    public static String runTests(DataSet dataSet) {
        StringWriter stringWriter = new StringWriter();
        new DatasetConsistencyTest(dataSet, stringWriter).runTest();
        return stringWriter.toString();
    }
}

