/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PlaceSelection
implements DownloadSelection {
    private static final String HISTORY_KEY = "download.places.history";
    private HistoryComboBox cbSearchExpression;
    private NamedResultTableModel model;
    private NamedResultTableColumnModel columnmodel;
    private JTable tblSearchResults;
    private DownloadDialog parent;
    private static final Server[] SERVERS = new Server[]{new Server("Nominatim", "https://nominatim.openstreetmap.org/search?format=xml&q=", I18n.tr("Class Type", new Object[0]), I18n.tr("Bounds", new Object[0]))};
    private final JosmComboBox<Server> server = new JosmComboBox<Server>(SERVERS);

    protected JPanel buildSearchPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add(new JLabel(I18n.tr("Choose the server for searching:", new Object[0])));
        jPanel.add(this.server);
        String string = Main.pref.get("namefinder.server", PlaceSelection.SERVERS[0].name);
        for (int i = 0; i < SERVERS.length; ++i) {
            if (!PlaceSelection.SERVERS[i].name.equals(string)) continue;
            this.server.setSelectedIndex(i);
        }
        jPanel.add(new JLabel(I18n.tr("Enter a place name to search for:", new Object[0])));
        this.cbSearchExpression = new HistoryComboBox();
        this.cbSearchExpression.setToolTipText(I18n.tr("Enter a place name to search for", new Object[0]));
        LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection(HISTORY_KEY, new LinkedList<String>()));
        Collections.reverse(linkedList);
        this.cbSearchExpression.setPossibleItems(linkedList);
        jPanel.add(this.cbSearchExpression);
        jPanel2.add((Component)jPanel, GBC.std().fill(2).insets(5, 5, 0, 5));
        SearchAction searchAction = new SearchAction();
        JButton jButton = new JButton(searchAction);
        this.cbSearchExpression.getEditorComponent().getDocument().addDocumentListener(searchAction);
        this.cbSearchExpression.getEditorComponent().addActionListener(searchAction);
        jPanel2.add((Component)jButton, GBC.eol().insets(5, 5, 0, 5));
        return jPanel2;
    }

    @Override
    public void addGui(DownloadDialog downloadDialog) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildSearchPanel(), "North");
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.model = new NamedResultTableModel(defaultListSelectionModel);
        this.columnmodel = new NamedResultTableColumnModel();
        this.tblSearchResults = new JTable(this.model, this.columnmodel);
        this.tblSearchResults.setSelectionModel(defaultListSelectionModel);
        JScrollPane jScrollPane = new JScrollPane(this.tblSearchResults);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        jPanel.add((Component)jScrollPane, "Center");
        if (downloadDialog != null) {
            downloadDialog.addDownloadAreaSelector(jPanel, I18n.tr("Areas around places", new Object[0]));
        }
        jScrollPane.setPreferredSize(jScrollPane.getPreferredSize());
        this.tblSearchResults.getSelectionModel().setSelectionMode(0);
        this.tblSearchResults.getSelectionModel().addListSelectionListener(new ListSelectionHandler());
        this.tblSearchResults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SearchResult searchResult;
                if (mouseEvent.getClickCount() > 1 && (searchResult = PlaceSelection.this.model.getSelectedSearchResult()) != null) {
                    PlaceSelection.this.parent.startDownload(searchResult.getDownloadArea());
                }
            }
        });
        this.parent = downloadDialog;
    }

    @Override
    public void setDownloadArea(Bounds bounds) {
        this.tblSearchResults.clearSelection();
    }

    static class NamedResultCellRenderer
    extends JLabel
    implements TableCellRenderer {
        NamedResultCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        protected void reset() {
            this.setText("");
            this.setIcon(null);
        }

        protected void renderColor(boolean bl) {
            if (bl) {
                this.setForeground(UIManager.getColor("Table.selectionForeground"));
                this.setBackground(UIManager.getColor("Table.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("Table.foreground"));
                this.setBackground(UIManager.getColor("Table.background"));
            }
        }

        protected String lineWrapDescription(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                if (stringBuilder2.length() == 0) {
                    stringBuilder2.append(string2);
                    continue;
                }
                if (stringBuilder2.length() < 80) {
                    stringBuilder2.append(' ').append(string2);
                    continue;
                }
                stringBuilder2.append(' ').append(string2).append("<br>");
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder2 = new StringBuilder();
            }
            stringBuilder.insert(0, "<html>");
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.reset();
            this.renderColor(bl);
            if (object == null) {
                return this;
            }
            SearchResult searchResult = (SearchResult)object;
            switch (n2) {
                case 0: {
                    this.setText(searchResult.name);
                    break;
                }
                case 1: {
                    this.setText(searchResult.info);
                    break;
                }
                case 2: {
                    this.setText(searchResult.nearestPlace);
                    break;
                }
                case 3: {
                    if (searchResult.bounds != null) {
                        this.setText(searchResult.bounds.toShortString(new DecimalFormat("0.000")));
                        break;
                    }
                    this.setText(searchResult.zoom != 0 ? Integer.toString(searchResult.zoom) : I18n.tr("unknown", new Object[0]));
                    break;
                }
            }
            this.setToolTipText(this.lineWrapDescription(searchResult.description));
            return this;
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            SearchResult searchResult = PlaceSelection.this.model.getSelectedSearchResult();
            if (searchResult != null) {
                PlaceSelection.this.parent.boundingBoxChanged(searchResult.getDownloadArea(), PlaceSelection.this);
            }
        }
    }

    static class NamedResultTableColumnModel
    extends DefaultTableColumnModel {
        private TableColumn col3;
        private TableColumn col4;

        NamedResultTableColumnModel() {
            this.createColumns();
        }

        protected final void createColumns() {
            NamedResultCellRenderer namedResultCellRenderer = new NamedResultCellRenderer();
            TableColumn tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(I18n.tr("Name", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setPreferredWidth(200);
            tableColumn.setCellRenderer(namedResultCellRenderer);
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setHeaderValue(I18n.tr("Type", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setPreferredWidth(100);
            tableColumn.setCellRenderer(namedResultCellRenderer);
            this.addColumn(tableColumn);
            this.col3 = new TableColumn(2);
            this.col3.setHeaderValue(SERVERS[0].thirdcol);
            this.col3.setResizable(true);
            this.col3.setPreferredWidth(100);
            this.col3.setCellRenderer(namedResultCellRenderer);
            this.addColumn(this.col3);
            this.col4 = new TableColumn(3);
            this.col4.setHeaderValue(SERVERS[0].fourthcol);
            this.col4.setResizable(true);
            this.col4.setPreferredWidth(50);
            this.col4.setCellRenderer(namedResultCellRenderer);
            this.addColumn(this.col4);
        }

        public void setHeadlines(String string, String string2) {
            this.col3.setHeaderValue(string);
            this.col4.setHeaderValue(string2);
            this.fireColumnMarginChanged();
        }
    }

    static class NamedResultTableModel
    extends DefaultTableModel {
        private transient List<SearchResult> data = new ArrayList<SearchResult>();
        private final transient ListSelectionModel selectionModel;

        NamedResultTableModel(ListSelectionModel listSelectionModel) {
            this.selectionModel = listSelectionModel;
        }

        @Override
        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data != null ? this.data.get(n) : null;
        }

        public void setData(List<SearchResult> list) {
            if (list == null) {
                this.data.clear();
            } else {
                this.data = new ArrayList<SearchResult>(list);
            }
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public SearchResult getSelectedSearchResult() {
            if (this.selectionModel.getMinSelectionIndex() < 0) {
                return null;
            }
            return this.data.get(this.selectionModel.getMinSelectionIndex());
        }
    }

    class NameQueryTask
    extends PleaseWaitRunnable {
        private final String searchExpression;
        private HttpClient connection;
        private List<SearchResult> data;
        private boolean canceled;
        private final Server useserver;
        private Exception lastException;

        NameQueryTask(String string) {
            super(I18n.tr("Querying name server", new Object[0]), false);
            this.searchExpression = string;
            this.useserver = (Server)PlaceSelection.this.server.getSelectedItem();
            Main.pref.put("namefinder.server", this.useserver.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel() {
            this.canceled = true;
            NameQueryTask nameQueryTask = this;
            synchronized (nameQueryTask) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
            }
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            PlaceSelection.this.columnmodel.setHeadlines(this.useserver.thirdcol, this.useserver.fourthcol);
            PlaceSelection.this.model.setData(this.data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            block19: {
                String string = this.useserver.url + Utils.encodeUrl(this.searchExpression);
                try {
                    this.getProgressMonitor().indeterminateSubTask(I18n.tr("Querying name server ...", new Object[0]));
                    URL uRL = new URL(string);
                    Object object = this;
                    synchronized (object) {
                        this.connection = HttpClient.create(uRL);
                        this.connection.connect();
                    }
                    object = this.connection.getResponse().getContentReader();
                    Throwable throwable = null;
                    try {
                        InputSource inputSource = new InputSource((Reader)object);
                        NameFinderResultParser nameFinderResultParser = new NameFinderResultParser();
                        Utils.parseSafeSAX(inputSource, nameFinderResultParser);
                        this.data = nameFinderResultParser.getResult();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    ((Reader)object).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((Reader)object).close();
                            }
                        }
                    }
                }
                catch (SAXParseException sAXParseException) {
                    if (!this.canceled) {
                        Main.warn((Throwable)sAXParseException, I18n.tr("Error occured with query ''{0}'': ''{1}''", string, sAXParseException.getMessage()));
                        GuiHelper.runInEDTAndWait(() -> HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("Name server returned invalid data. Please try again.", new Object[0]), I18n.tr("Bad response", new Object[0]), 2, null));
                    }
                }
                catch (IOException | ParserConfigurationException exception) {
                    if (this.canceled) break block19;
                    OsmTransferException osmTransferException = new OsmTransferException(exception);
                    osmTransferException.setUrl(string);
                    this.lastException = osmTransferException;
                }
            }
        }
    }

    class SearchAction
    extends AbstractAction
    implements DocumentListener {
        SearchAction() {
            this.putValue("Name", I18n.tr("Search ...", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
            this.putValue("ShortDescription", I18n.tr("Click to start searching for places", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled() || PlaceSelection.this.cbSearchExpression.getText().trim().isEmpty()) {
                return;
            }
            PlaceSelection.this.cbSearchExpression.addCurrentItemToHistory();
            Main.pref.putCollection(PlaceSelection.HISTORY_KEY, PlaceSelection.this.cbSearchExpression.getHistory());
            NameQueryTask nameQueryTask = new NameQueryTask(PlaceSelection.this.cbSearchExpression.getText());
            Main.worker.submit(nameQueryTask);
        }

        protected final void updateEnabledState() {
            this.setEnabled(!PlaceSelection.this.cbSearchExpression.getText().trim().isEmpty());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }
    }

    private static class NameFinderResultParser
    extends DefaultHandler {
        private SearchResult currentResult;
        private StringBuilder description;
        private int depth;
        private final List<SearchResult> data = new LinkedList<SearchResult>();

        private NameFinderResultParser() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.depth;
            try {
                if (!"searchresults".equals(string3)) {
                    if ("named".equals(string3) && this.depth == 2) {
                        this.currentResult = new SearchResult();
                        this.currentResult.name = attributes.getValue("name");
                        this.currentResult.info = attributes.getValue("info");
                        if (this.currentResult.info != null) {
                            this.currentResult.info = I18n.tr(this.currentResult.info, new Object[0]);
                        }
                        this.currentResult.lat = Double.parseDouble(attributes.getValue("lat"));
                        this.currentResult.lon = Double.parseDouble(attributes.getValue("lon"));
                        this.currentResult.zoom = Integer.parseInt(attributes.getValue("zoom"));
                        this.data.add(this.currentResult);
                    } else if ("description".equals(string3) && this.depth == 3) {
                        this.description = new StringBuilder();
                    } else if ("named".equals(string3) && this.depth == 4) {
                        String string4 = attributes.getValue("info");
                        if ("city".equals(string4) || "town".equals(string4) || "village".equals(string4)) {
                            this.currentResult.nearestPlace = attributes.getValue("name");
                        }
                    } else if ("place".equals(string3) && attributes.getValue("lat") != null) {
                        this.currentResult = new SearchResult();
                        this.currentResult.description = this.currentResult.name = attributes.getValue("display_name");
                        this.currentResult.info = attributes.getValue("class");
                        if (this.currentResult.info != null) {
                            this.currentResult.info = I18n.tr(this.currentResult.info, new Object[0]);
                        }
                        this.currentResult.nearestPlace = I18n.tr(attributes.getValue("type"), new Object[0]);
                        this.currentResult.lat = Double.parseDouble(attributes.getValue("lat"));
                        this.currentResult.lon = Double.parseDouble(attributes.getValue("lon"));
                        String[] stringArray = attributes.getValue("boundingbox").split(",");
                        this.currentResult.bounds = new Bounds(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[3]));
                        this.data.add(this.currentResult);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                Main.error(numberFormatException);
                throw new SAXException(numberFormatException.getMessage(), numberFormatException);
            }
            catch (NullPointerException nullPointerException) {
                Main.error(nullPointerException);
                throw new SAXException(I18n.tr("Null pointer exception, possibly some missing tags.", new Object[0]), nullPointerException);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("description".equals(string3) && this.description != null) {
                this.currentResult.description = this.description.toString();
                this.description = null;
            }
            --this.depth;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.description != null) {
                this.description.append(cArray, n, n2);
            }
        }

        public List<SearchResult> getResult() {
            return this.data;
        }
    }

    private static class SearchResult {
        public String name;
        public String info;
        public String nearestPlace;
        public String description;
        public double lat;
        public double lon;
        public int zoom;
        public Bounds bounds;

        private SearchResult() {
        }

        public Bounds getDownloadArea() {
            return this.bounds != null ? this.bounds : OsmUrlToBounds.positionToBounds(this.lat, this.lon, this.zoom);
        }
    }

    private static class Server {
        public final String name;
        public final String url;
        public final String thirdcol;
        public final String fourthcol;

        Server(String string, String string2, String string3, String string4) {
            this.name = string;
            this.url = string2;
            this.thirdcol = string3;
            this.fourthcol = string4;
        }

        public String toString() {
            return this.name;
        }
    }
}

