/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.gui.layer.MapViewGraphics;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;

public abstract class AbstractMapViewPaintable
implements MapViewPaintable {
    private final CopyOnWriteArrayList<MapViewPaintable.PaintableInvalidationListener> invalidationListeners = new CopyOnWriteArrayList();

    public MapViewPaintable.LayerPainter attachToMapView(MapViewPaintable.MapViewEvent mapViewEvent) {
        return this.createMapViewPainter(mapViewEvent);
    }

    protected MapViewPaintable.LayerPainter createMapViewPainter(MapViewPaintable.MapViewEvent mapViewEvent) {
        return new CompatibilityModeLayerPainter();
    }

    public void addInvalidationListener(MapViewPaintable.PaintableInvalidationListener paintableInvalidationListener) {
        this.invalidationListeners.add(paintableInvalidationListener);
    }

    public void removeInvalidationListener(MapViewPaintable.PaintableInvalidationListener paintableInvalidationListener) {
        this.invalidationListeners.remove(paintableInvalidationListener);
    }

    public void invalidate() {
        for (MapViewPaintable.PaintableInvalidationListener paintableInvalidationListener : this.invalidationListeners) {
            paintableInvalidationListener.paintableInvalidated(new MapViewPaintable.PaintableInvalidationEvent(this));
        }
    }

    protected class CompatibilityModeLayerPainter
    implements MapViewPaintable.LayerPainter {
        protected CompatibilityModeLayerPainter() {
        }

        @Override
        public void paint(MapViewGraphics mapViewGraphics) {
            AbstractMapViewPaintable.this.paint(mapViewGraphics.getDefaultGraphics(), mapViewGraphics.getMapView(), mapViewGraphics.getClipBounds().getLatLonBoundsBox());
        }

        @Override
        public void detachFromMapView(MapViewPaintable.MapViewEvent mapViewEvent) {
        }
    }
}

