/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CustomizeColor
extends AbstractAction
implements Layer.LayerAction,
Layer.MultiLayerAction {
    private final transient List<AbstractProperty<Color>> colors;

    public CustomizeColor(List<Layer> list) {
        super(I18n.tr("Customize Color", new Object[0]), ImageProvider.get("colorchooser"));
        this.colors = list.stream().map(Layer::getColorProperty).collect(Collectors.toList());
        CheckParameterUtil.ensureThat(this.colors.stream().allMatch(Objects::nonNull), "All layers must have colors.");
        this.putValue("help", HelpUtil.ht("/Action/LayerCustomizeColor"));
    }

    public CustomizeColor(Layer layer) {
        this(Collections.singletonList(layer));
    }

    @Override
    public boolean supportLayers(List<Layer> list) {
        return list.stream().allMatch(layer -> layer.getColorProperty() != null);
    }

    @Override
    public Component createMenuComponent() {
        return new JMenuItem(this);
    }

    @Override
    public Action getMultiLayerAction(List<Layer> list) {
        return new CustomizeColor(list);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color = this.colors.stream().map(abstractProperty -> (Color)abstractProperty.get()).filter(Objects::nonNull).findAny().orElse(Color.GRAY);
        JColorChooser jColorChooser = new JColorChooser(color);
        Object[] objectArray = new Object[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Default", new Object[0])};
        int n = JOptionPane.showOptionDialog(Main.parent, jColorChooser, I18n.tr("Choose a color", new Object[0]), 2, -1, null, objectArray, objectArray[0]);
        switch (n) {
            case 0: {
                this.colors.stream().forEach(abstractProperty -> abstractProperty.put(jColorChooser.getColor()));
                break;
            }
            case 1: {
                return;
            }
            case 2: {
                this.colors.stream().forEach(abstractProperty -> abstractProperty.put(null));
            }
        }
        LayerListDialog.getInstance().repaint();
    }
}

