/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.core.rope.AsciiOnlyLeafRope;
import org.jruby.truffle.core.rope.InvalidLeafRope;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.ValidLeafRope;

public class RopeConstants {
    public static final LeafRope EMPTY_ASCII_8BIT_ROPE;
    public static final LeafRope EMPTY_US_ASCII_ROPE;
    public static final LeafRope EMPTY_UTF8_ROPE;
    public static final LeafRope[] UTF8_SINGLE_BYTE_ROPES;
    public static final LeafRope[] US_ASCII_SINGLE_BYTE_ROPES;
    public static final LeafRope[] ASCII_8BIT_SINGLE_BYTE_ROPES;

    static {
        byte[] bytes;
        int i;
        UTF8_SINGLE_BYTE_ROPES = new LeafRope[256];
        US_ASCII_SINGLE_BYTE_ROPES = new LeafRope[256];
        ASCII_8BIT_SINGLE_BYTE_ROPES = new LeafRope[256];
        byte[] emptyBytes = new byte[]{};
        EMPTY_UTF8_ROPE = new AsciiOnlyLeafRope(emptyBytes, (Encoding)UTF8Encoding.INSTANCE).computeHashCode();
        EMPTY_US_ASCII_ROPE = new AsciiOnlyLeafRope(emptyBytes, (Encoding)USASCIIEncoding.INSTANCE).computeHashCode();
        EMPTY_ASCII_8BIT_ROPE = new AsciiOnlyLeafRope(emptyBytes, (Encoding)ASCIIEncoding.INSTANCE).computeHashCode();
        for (i = 0; i < 128; ++i) {
            bytes = new byte[]{(byte)i};
            RopeConstants.UTF8_SINGLE_BYTE_ROPES[i] = new AsciiOnlyLeafRope(bytes, (Encoding)UTF8Encoding.INSTANCE).computeHashCode();
            RopeConstants.US_ASCII_SINGLE_BYTE_ROPES[i] = new AsciiOnlyLeafRope(bytes, (Encoding)USASCIIEncoding.INSTANCE).computeHashCode();
            RopeConstants.ASCII_8BIT_SINGLE_BYTE_ROPES[i] = new AsciiOnlyLeafRope(bytes, (Encoding)ASCIIEncoding.INSTANCE).computeHashCode();
        }
        for (i = 128; i < 256; ++i) {
            bytes = new byte[]{(byte)i};
            RopeConstants.UTF8_SINGLE_BYTE_ROPES[i] = new InvalidLeafRope(bytes, (Encoding)UTF8Encoding.INSTANCE).computeHashCode();
            RopeConstants.US_ASCII_SINGLE_BYTE_ROPES[i] = new InvalidLeafRope(bytes, (Encoding)USASCIIEncoding.INSTANCE).computeHashCode();
            RopeConstants.ASCII_8BIT_SINGLE_BYTE_ROPES[i] = new ValidLeafRope(bytes, (Encoding)ASCIIEncoding.INSTANCE, 1).computeHashCode();
        }
    }
}

