/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierList;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0004H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/ModifierMaskUtils;", "", "()V", "computeMask", "", "hasModifier", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "", "computeMaskFromModifierList", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "maskHasModifier", "mask", "modifierToken", "maskToString", "", "kotlin-compiler"})
public final class ModifierMaskUtils {
    public static final ModifierMaskUtils INSTANCE;

    @JvmStatic
    public static final int computeMaskFromModifierList(@NotNull KtModifierList modifierList) {
        Intrinsics.checkParameterIsNotNull(modifierList, "modifierList");
        return ModifierMaskUtils.computeMask((Function1<? super KtModifierKeywordToken, Boolean>)new Function1<KtModifierKeywordToken, Boolean>(modifierList){
            final /* synthetic */ KtModifierList $modifierList;

            public final boolean invoke(@NotNull KtModifierKeywordToken it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return this.$modifierList.hasModifier(it);
            }
            {
                this.$modifierList = ktModifierList;
                super(1);
            }
        });
    }

    @JvmStatic
    public static final int computeMask(@NotNull Function1<? super KtModifierKeywordToken, Boolean> hasModifier) {
        Intrinsics.checkParameterIsNotNull(hasModifier, "hasModifier");
        int mask = 0;
        for (IndexedValue<Object> indexedValue : ArraysKt.withIndex((Object[])KtTokens.MODIFIER_KEYWORDS_ARRAY)) {
            KtModifierKeywordToken modifierKeywordToken;
            int index2 = indexedValue.component1();
            KtModifierKeywordToken ktModifierKeywordToken = modifierKeywordToken = (KtModifierKeywordToken)indexedValue.component2();
            Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "modifierKeywordToken");
            if (!hasModifier.invoke(ktModifierKeywordToken).booleanValue()) continue;
            mask |= 1 << index2;
        }
        return mask;
    }

    @JvmStatic
    public static final boolean maskHasModifier(int mask, @NotNull KtModifierKeywordToken modifierToken) {
        Intrinsics.checkParameterIsNotNull(modifierToken, "modifierToken");
        int index2 = ArraysKt.indexOf((Object[])KtTokens.MODIFIER_KEYWORDS_ARRAY, modifierToken);
        boolean bl = index2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "All JetModifierKeywordTokens should be present in MODIFIER_KEYWORDS_ARRAY";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return (mask & 1 << index2) != 0;
    }

    @JvmStatic
    @NotNull
    public static final String maskToString(int mask) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = KtTokens.MODIFIER_KEYWORDS_ARRAY;
        for (int i = 0; i < ktModifierKeywordTokenArray.length; ++i) {
            KtModifierKeywordToken modifierKeyword;
            KtModifierKeywordToken ktModifierKeywordToken = modifierKeyword = ktModifierKeywordTokenArray[i];
            Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "modifierKeyword");
            if (!ModifierMaskUtils.maskHasModifier(mask, ktModifierKeywordToken)) continue;
            if (!first) {
                sb.append(" ");
            }
            sb.append(modifierKeyword.getValue());
            first = false;
        }
        sb.append("]");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    private ModifierMaskUtils() {
        INSTANCE = this;
        boolean bl = ((Object[])KtTokens.MODIFIER_KEYWORDS_ARRAY).length <= 32;
        if (_Assertions.ENABLED && !bl) {
            String string = "Current implementation depends on the ability to represent modifier list as bit mask";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    static {
        new ModifierMaskUtils();
    }
}

