/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.util;

import com.intellij.lang.ASTNode;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

public class DelegatingCall
implements Call {
    private final Call delegate;

    public DelegatingCall(@NotNull Call delegate2) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/resolve/calls/util/DelegatingCall", "<init>"));
        }
        this.delegate = delegate2;
    }

    @Override
    @Nullable
    public ASTNode getCallOperationNode() {
        return this.delegate.getCallOperationNode();
    }

    @Override
    @Nullable
    public Receiver getExplicitReceiver() {
        return this.delegate.getExplicitReceiver();
    }

    @Override
    @Nullable
    public ReceiverValue getDispatchReceiver() {
        return this.delegate.getDispatchReceiver();
    }

    @Override
    @Nullable
    public KtExpression getCalleeExpression() {
        return this.delegate.getCalleeExpression();
    }

    @Override
    @Nullable
    public KtValueArgumentList getValueArgumentList() {
        return this.delegate.getValueArgumentList();
    }

    @Override
    @NotNull
    @ReadOnly
    public List<? extends ValueArgument> getValueArguments() {
        List<? extends ValueArgument> list2 = this.delegate.getValueArguments();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/DelegatingCall", "getValueArguments"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<? extends LambdaArgument> getFunctionLiteralArguments() {
        List<? extends LambdaArgument> list2 = this.delegate.getFunctionLiteralArguments();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/DelegatingCall", "getFunctionLiteralArguments"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<KtTypeProjection> getTypeArguments() {
        List<KtTypeProjection> list2 = this.delegate.getTypeArguments();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/DelegatingCall", "getTypeArguments"));
        }
        return list2;
    }

    @Override
    @Nullable
    public KtTypeArgumentList getTypeArgumentList() {
        return this.delegate.getTypeArgumentList();
    }

    @Override
    @NotNull
    public KtElement getCallElement() {
        KtElement ktElement = this.delegate.getCallElement();
        if (ktElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/DelegatingCall", "getCallElement"));
        }
        return ktElement;
    }

    @Override
    @NotNull
    public Call.CallType getCallType() {
        Call.CallType callType = this.delegate.getCallType();
        if (callType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/util/DelegatingCall", "getCallType"));
        }
        return callType;
    }
}

