/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.checker.TypeCheckerProcedureCallbacksImpl;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

public class KotlinTypeChecker {
    public static final KotlinTypeChecker DEFAULT = new KotlinTypeChecker(new TypeCheckingProcedure(new TypeCheckerProcedureCallbacksImpl()));
    public static final KotlinTypeChecker ERROR_TYPES_ARE_EQUAL_TO_ANYTHING = new KotlinTypeChecker(new TypeCheckingProcedure(new TypeCheckerProcedureCallbacksImpl(){

        @Override
        public boolean assertEqualTypes(@NotNull KotlinType a, @NotNull KotlinType b, @NotNull TypeCheckingProcedure typeCheckingProcedure2) {
            if (a == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/types/checker/KotlinTypeChecker$1", "assertEqualTypes"));
            }
            if (b == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/types/checker/KotlinTypeChecker$1", "assertEqualTypes"));
            }
            if (typeCheckingProcedure2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCheckingProcedure", "org/jetbrains/kotlin/types/checker/KotlinTypeChecker$1", "assertEqualTypes"));
            }
            return a.isError() || b.isError() || super.assertEqualTypes(a, b, typeCheckingProcedure2);
        }
    }));
    public static final KotlinTypeChecker FLEXIBLE_UNEQUAL_TO_INFLEXIBLE = new KotlinTypeChecker(new TypeCheckingProcedure(new TypeCheckerProcedureCallbacksImpl()){

        @Override
        protected boolean heterogeneousEquivalence(KotlinType inflexibleType, KotlinType flexibleType) {
            return false;
        }
    });
    private final TypeCheckingProcedure procedure;

    @NotNull
    public static KotlinTypeChecker withAxioms(final @NotNull TypeConstructorEquality equalityAxioms) {
        if (equalityAxioms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equalityAxioms", "org/jetbrains/kotlin/types/checker/KotlinTypeChecker", "withAxioms"));
        }
        KotlinTypeChecker kotlinTypeChecker = new KotlinTypeChecker(new TypeCheckingProcedure(new TypeCheckerProcedureCallbacksImpl(){

            @Override
            public boolean assertEqualTypeConstructors(@NotNull TypeConstructor constructor1, @NotNull TypeConstructor constructor2) {
                if (constructor1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor1", "org/jetbrains/kotlin/types/checker/KotlinTypeChecker$3", "assertEqualTypeConstructors"));
                }
                if (constructor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor2", "org/jetbrains/kotlin/types/checker/KotlinTypeChecker$3", "assertEqualTypeConstructors"));
                }
                return constructor1.equals(constructor2) || equalityAxioms.equals(constructor1, constructor2);
            }
        }));
        if (kotlinTypeChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/checker/KotlinTypeChecker", "withAxioms"));
        }
        return kotlinTypeChecker;
    }

    private KotlinTypeChecker(@NotNull TypeCheckingProcedure procedure) {
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "org/jetbrains/kotlin/types/checker/KotlinTypeChecker", "<init>"));
        }
        this.procedure = procedure;
    }

    public boolean isSubtypeOf(@NotNull KotlinType subtype, @NotNull KotlinType supertype) {
        if (subtype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subtype", "org/jetbrains/kotlin/types/checker/KotlinTypeChecker", "isSubtypeOf"));
        }
        if (supertype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertype", "org/jetbrains/kotlin/types/checker/KotlinTypeChecker", "isSubtypeOf"));
        }
        return this.procedure.isSubtypeOf(subtype, supertype);
    }

    public boolean equalTypes(@NotNull KotlinType a, @NotNull KotlinType b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/types/checker/KotlinTypeChecker", "equalTypes"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/types/checker/KotlinTypeChecker", "equalTypes"));
        }
        return this.procedure.equalTypes(a, b);
    }

    public static interface TypeConstructorEquality {
        public boolean equals(@NotNull TypeConstructor var1, @NotNull TypeConstructor var2);
    }
}

