/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.channels.SocketChannel;

public class CustomStreamsSocket
extends Socket {
    private final Socket delegate;
    private final InputStream customInputStream;
    private final OutputStream customOutputStream;

    public CustomStreamsSocket(Socket socket, InputStream inputStream, OutputStream outputStream) throws IOException {
        super((SocketImpl)null);
        if (socket == null) {
            throw new IllegalArgumentException("Parameter socket must not be null.");
        }
        if (inputStream == null && outputStream == null) {
            throw new IllegalArgumentException("Parameters inputStream and outputStream must not be both null.");
        }
        this.delegate = socket;
        this.customInputStream = inputStream != null ? inputStream : socket.getInputStream();
        this.customOutputStream = outputStream != null ? outputStream : socket.getOutputStream();
    }

    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        this.delegate.connect(socketAddress);
    }

    @Override
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        this.delegate.connect(socketAddress, n);
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        this.delegate.bind(socketAddress);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.delegate.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.delegate.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        return this.delegate.getChannel();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.customInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.customOutputStream;
    }

    @Override
    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.delegate.setTcpNoDelay(bl);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.delegate.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.delegate.setSoLinger(bl, n);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.delegate.getSoLinger();
    }

    @Override
    public void sendUrgentData(int n) throws IOException {
        this.delegate.sendUrgentData(n);
    }

    @Override
    public void setOOBInline(boolean bl) throws SocketException {
        this.delegate.setOOBInline(bl);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.delegate.getOOBInline();
    }

    @Override
    public synchronized void setSoTimeout(int n) throws SocketException {
        this.delegate.setSoTimeout(n);
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.delegate.getSoTimeout();
    }

    @Override
    public synchronized void setSendBufferSize(int n) throws SocketException {
        this.delegate.setSendBufferSize(n);
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.delegate.getSendBufferSize();
    }

    @Override
    public synchronized void setReceiveBufferSize(int n) throws SocketException {
        this.delegate.setReceiveBufferSize(n);
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.delegate.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean bl) throws SocketException {
        this.delegate.setKeepAlive(bl);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.delegate.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int n) throws SocketException {
        this.delegate.setTrafficClass(n);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.delegate.getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean bl) throws SocketException {
        this.delegate.setReuseAddress(bl);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.delegate.getReuseAddress();
    }

    @Override
    public synchronized void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.delegate.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.delegate.shutdownOutput();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.delegate.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.delegate.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.delegate.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int n, int n2, int n3) {
        this.delegate.setPerformancePreferences(n, n2, n3);
    }
}

