/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import ch.csnc.extension.httpclient.SSLContextManager;
import java.io.File;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.network.SSLConnector;

public class OptionsParamCertificate
extends AbstractParam {
    private static final Logger logger = Logger.getLogger(OptionsParamCertificate.class);
    private static final String CERTIFICATE_BASE_KEY = "certificate";
    private static final String USE_CLIENT_CERT = "certificate.use";
    private static final String CLIENT_CERT_LOCATION = "certificate.clientCertLocation";
    private static final String ALLOW_UNSAFE_SSL_RENEGOTIATION = "certificate.allowUnsafeSslRenegotiation";
    private int useClientCert = 0;
    private String clientCertLocation = "";
    private boolean allowUnsafeSslRenegotiation = false;

    @Override
    protected void parse() {
        this.setUseClientCert(false);
        this.setClientCertLocation("");
        try {
            this.allowUnsafeSslRenegotiation = this.getConfig().getBoolean(ALLOW_UNSAFE_SSL_RENEGOTIATION, false);
            OptionsParamCertificate.setAllowUnsafeSslRenegotiationSystemProperty(this.allowUnsafeSslRenegotiation);
        }
        catch (ConversionException conversionException) {
            logger.error((Object)("Error while loading the option Allow Unsafe SSL Renegotiation: " + conversionException.getMessage()), (Throwable)conversionException);
        }
    }

    public String getClientCertLocation() {
        return this.clientCertLocation;
    }

    public void setClientCertLocation(String string) {
        if (string != null && !string.equals("")) {
            File file = new File(string);
            if (!file.exists()) {
                this.setUseClientCert(false);
                return;
            }
        } else {
            this.setUseClientCert(false);
        }
        this.clientCertLocation = string;
        this.getConfig().setProperty(CLIENT_CERT_LOCATION, (Object)string);
    }

    public boolean isUseClientCert() {
        return this.useClientCert != 0;
    }

    private void setUseClientCert(boolean bl) {
        if (bl) {
            this.useClientCert = 1;
            this.getConfig().setProperty(USE_CLIENT_CERT, (Object)Integer.toString(this.useClientCert));
            return;
        }
        this.useClientCert = 0;
        this.getConfig().setProperty(USE_CLIENT_CERT, (Object)Integer.toString(this.useClientCert));
    }

    public void setEnableCertificate(boolean bl) {
        ProtocolSocketFactory protocolSocketFactory = Protocol.getProtocol((String)"https").getSocketFactory();
        if (protocolSocketFactory instanceof SSLConnector) {
            SSLConnector sSLConnector = (SSLConnector)protocolSocketFactory;
            sSLConnector.setEnableClientCert(bl);
            this.setUseClientCert(bl);
        }
    }

    public void setActiveCertificate() {
        ProtocolSocketFactory protocolSocketFactory = Protocol.getProtocol((String)"https").getSocketFactory();
        if (protocolSocketFactory instanceof SSLConnector) {
            SSLConnector sSLConnector = (SSLConnector)protocolSocketFactory;
            sSLConnector.setActiveCertificate();
        }
    }

    public SSLContextManager getSSLContextManager() {
        ProtocolSocketFactory protocolSocketFactory = Protocol.getProtocol((String)"https").getSocketFactory();
        if (protocolSocketFactory instanceof SSLConnector) {
            SSLConnector sSLConnector = (SSLConnector)protocolSocketFactory;
            return sSLConnector.getSSLContextManager();
        }
        return null;
    }

    public boolean isAllowUnsafeSslRenegotiation() {
        return this.allowUnsafeSslRenegotiation;
    }

    public void setAllowUnsafeSslRenegotiation(boolean bl) {
        if (this.allowUnsafeSslRenegotiation != bl) {
            this.allowUnsafeSslRenegotiation = bl;
            OptionsParamCertificate.setAllowUnsafeSslRenegotiationSystemProperty(this.allowUnsafeSslRenegotiation);
            this.getConfig().setProperty(ALLOW_UNSAFE_SSL_RENEGOTIATION, (Object)this.allowUnsafeSslRenegotiation);
        }
    }

    private static void setAllowUnsafeSslRenegotiationSystemProperty(boolean bl) {
        String string;
        if (bl) {
            logger.info((Object)"Unsafe SSL renegotiation enabled.");
            string = "ALL";
        } else {
            logger.info((Object)"Unsafe SSL renegotiation disabled.");
            string = "NONE";
        }
        System.setProperty("com.ibm.jsse2.renegotiate", string);
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", String.valueOf(bl));
    }
}

