/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.ascan.ActiveScan;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.extension.script.ScriptCollection;
import org.zaproxy.zap.model.ScanController;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.users.User;

public class ActiveScanController
implements ScanController<ActiveScan> {
    private ExtensionActiveScan extension;
    private static final Logger logger = Logger.getLogger(ActiveScanController.class);
    private ExtensionAlert extAlert = null;
    private final Lock activeScansLock = new ReentrantLock();
    private int scanIdCounter;
    private Map<Integer, ActiveScan> activeScanMap;
    private List<ActiveScan> activeScanList;

    public ActiveScanController(ExtensionActiveScan extensionActiveScan) {
        this.extension = extensionActiveScan;
        this.activeScanMap = new HashMap<Integer, ActiveScan>();
        this.activeScanList = new ArrayList<ActiveScan>();
    }

    public void setExtAlert(ExtensionAlert extensionAlert) {
        this.extAlert = extensionAlert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startScan(String string, Target target, User user, Object[] objectArray) {
        this.activeScansLock.lock();
        try {
            int n = this.scanIdCounter++;
            ActiveScan activeScan = new ActiveScan(string, this.extension.getScannerParam(), this.extension.getModel().getOptionsParam().getConnectionParam(), null){

                @Override
                public void alertFound(Alert alert) {
                    if (ActiveScanController.this.extAlert != null) {
                        ActiveScanController.this.extAlert.alertFound(alert, null);
                    }
                    super.alertFound(alert);
                }
            };
            Session session = Model.getSingleton().getSession();
            activeScan.setExcludeList(session.getExcludeFromScanRegexs());
            ScanPolicy scanPolicy = null;
            activeScan.setId(n);
            activeScan.setUser(user);
            boolean bl = false;
            if (objectArray != null) {
                for (Object object : objectArray) {
                    if (object instanceof ScannerParam) {
                        logger.debug((Object)"Setting custom scanner params");
                        activeScan.setScannerParam((ScannerParam)object);
                        continue;
                    }
                    if (object instanceof ScanPolicy) {
                        scanPolicy = (ScanPolicy)object;
                        logger.debug((Object)("Setting custom policy " + scanPolicy.getName()));
                        activeScan.setScanPolicy(scanPolicy);
                        continue;
                    }
                    if (object instanceof TechSet) {
                        activeScan.setTechSet((TechSet)object);
                        bl = true;
                        continue;
                    }
                    if (object instanceof ScriptCollection) {
                        activeScan.addScriptCollection((ScriptCollection)object);
                        continue;
                    }
                    logger.error((Object)("Unexpected contextSpecificObject: " + object.getClass().getCanonicalName()));
                }
            }
            if (scanPolicy == null) {
                scanPolicy = this.extension.getPolicyManager().getDefaultScanPolicy();
                logger.debug((Object)("Setting default policy " + scanPolicy.getName()));
                activeScan.setScanPolicy(scanPolicy);
            }
            if (!bl && target.getContext() != null) {
                activeScan.setTechSet(target.getContext().getTechSet());
            }
            this.activeScanMap.put(n, activeScan);
            this.activeScanList.add(activeScan);
            activeScan.start(target);
            int n2 = n;
            return n2;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerScan(ActiveScan activeScan) {
        this.activeScansLock.lock();
        try {
            int n = this.scanIdCounter++;
            activeScan.setScanId(n);
            this.activeScanMap.put(n, activeScan);
            this.activeScanList.add(activeScan);
            int n2 = n;
            return n2;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    @Override
    public ActiveScan getScan(int n) {
        return this.activeScanMap.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActiveScan getLastScan() {
        this.activeScansLock.lock();
        try {
            if (this.activeScanList.size() == 0) {
                ActiveScan activeScan = null;
                return activeScan;
            }
            ActiveScan activeScan = this.activeScanList.get(this.activeScanList.size() - 1);
            return activeScan;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActiveScan> getAllScans() {
        ArrayList<ActiveScan> arrayList = new ArrayList<ActiveScan>();
        this.activeScansLock.lock();
        try {
            for (ActiveScan activeScan : this.activeScanList) {
                arrayList.add(activeScan);
            }
            ArrayList<ActiveScan> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActiveScan> getActiveScans() {
        ArrayList<ActiveScan> arrayList = new ArrayList<ActiveScan>();
        this.activeScansLock.lock();
        try {
            for (ActiveScan activeScan : this.activeScanList) {
                if (activeScan.isStopped()) continue;
                arrayList.add(activeScan);
            }
            ArrayList<ActiveScan> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActiveScan removeScan(int n) {
        this.activeScansLock.lock();
        try {
            ActiveScan activeScan = this.activeScanMap.get(n);
            if (!this.activeScanMap.containsKey(n)) {
                ActiveScan activeScan2 = null;
                return activeScan2;
            }
            activeScan.stopScan();
            this.activeScanMap.remove(n);
            this.activeScanList.remove(activeScan);
            ActiveScan activeScan3 = activeScan;
            return activeScan3;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    public int getTotalNumberScans() {
        return this.activeScanMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAllScans() {
        this.activeScansLock.lock();
        try {
            for (ActiveScan activeScan : this.activeScanMap.values()) {
                activeScan.stopScan();
            }
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseAllScans() {
        this.activeScansLock.lock();
        try {
            for (ActiveScan activeScan : this.activeScanMap.values()) {
                activeScan.pauseScan();
            }
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeAllScans() {
        this.activeScansLock.lock();
        try {
            for (ActiveScan activeScan : this.activeScanMap.values()) {
                activeScan.resumeScan();
            }
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAllScans() {
        this.activeScansLock.lock();
        try {
            int n = 0;
            Iterator<ActiveScan> iterator = this.activeScanMap.values().iterator();
            while (iterator.hasNext()) {
                ActiveScan activeScan = iterator.next();
                activeScan.stopScan();
                iterator.remove();
                this.activeScanList.remove(activeScan);
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeFinishedScans() {
        this.activeScansLock.lock();
        try {
            int n = 0;
            Iterator<ActiveScan> iterator = this.activeScanMap.values().iterator();
            while (iterator.hasNext()) {
                ActiveScan activeScan = iterator.next();
                if (!activeScan.isStopped()) continue;
                activeScan.stopScan();
                iterator.remove();
                this.activeScanList.remove(activeScan);
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopScan(int n) {
        this.activeScansLock.lock();
        try {
            if (this.activeScanMap.containsKey(n)) {
                this.activeScanMap.get(n).stopScan();
            }
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseScan(int n) {
        this.activeScansLock.lock();
        try {
            if (this.activeScanMap.containsKey(n)) {
                this.activeScanMap.get(n).pauseScan();
            }
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeScan(int n) {
        this.activeScansLock.lock();
        try {
            if (this.activeScanMap.containsKey(n)) {
                this.activeScanMap.get(n).resumeScan();
            }
        }
        finally {
            this.activeScansLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.removeAllScans();
        this.activeScansLock.lock();
        try {
            this.scanIdCounter = 0;
        }
        finally {
            this.activeScansLock.unlock();
        }
    }
}

