/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsPanel;

public class PopupMenuItemCopySessionToken
extends ExtensionPopupMenuItem
implements ClipboardOwner {
    private static final long serialVersionUID = -2462677795340933336L;
    private final HttpSessionsPanel httpSessionsPanel;

    public PopupMenuItemCopySessionToken(HttpSessionsPanel httpSessionsPanel) {
        super(Constant.messages.getString("httpsessions.popup.session.copyToken"));
        this.httpSessionsPanel = httpSessionsPanel;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HttpSession httpSession = PopupMenuItemCopySessionToken.this.httpSessionsPanel.getSelectedSession();
                if (httpSession == null) {
                    return;
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(httpSession.getTokenValuesString()), PopupMenuItemCopySessionToken.this);
            }
        });
    }

    @Override
    public boolean isEnableForComponent(Component component) {
        if ("httpsessions".equals(component.getName())) {
            this.setEnabled(this.httpSessionsPanel.getSelectedSession() != null);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

