/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenTestRunningSettings;

@State(name="MavenProjectSettings", storages={@Storage(value="mavenProjectSettings.xml")})
public class MavenProjectSettings
implements PersistentStateComponent<MavenProjectSettings> {
    private final Project myProject;
    private MavenTestRunningSettings myTestRunningSettings = new MavenTestRunningSettings();

    public MavenProjectSettings() {
        this(null);
    }

    public MavenProjectSettings(Project project) {
        this.myProject = project;
    }

    public static MavenProjectSettings getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenProjectSettings", "getInstance"));
        }
        return (MavenProjectSettings)ServiceManager.getService((Project)project, MavenProjectSettings.class);
    }

    @Nullable
    public MavenProjectSettings getState() {
        return this;
    }

    public MavenTestRunningSettings getTestRunningSettings() {
        return this.myTestRunningSettings;
    }

    public void setTestRunningSettings(MavenTestRunningSettings testRunningSettings) {
        this.myTestRunningSettings = testRunningSettings;
    }

    public void loadState(MavenProjectSettings state) {
        this.myTestRunningSettings = state.myTestRunningSettings;
    }
}

