/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.descriptors;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayFactory;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.Arrays;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptorBase;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;

public class JavaFxRootTagDescriptor
extends JavaFxClassTagDescriptorBase {
    private final XmlTag myXmlTag;

    public JavaFxRootTagDescriptor(XmlTag xmlTag) {
        super("fx:root");
        this.myXmlTag = xmlTag;
    }

    @Override
    public PsiClass getPsiClass() {
        String className = this.myXmlTag.getAttributeValue("type");
        return className != null ? JavaFxPsiUtil.findPsiClass(className, (PsiElement)this.myXmlTag) : null;
    }

    @Override
    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
        if ("type".equals(attributeName)) {
            return new RootTagTypeAttributeDescriptor();
        }
        return super.getAttributeDescriptor(attributeName, context);
    }

    @Override
    public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
        return (XmlAttributeDescriptor[])Stream.concat(Arrays.stream(super.getAttributesDescriptors(context)), Stream.of(new RootTagTypeAttributeDescriptor())).toArray(arg_0 -> ((ArrayFactory)XmlAttributeDescriptor.ARRAY_FACTORY).create(arg_0));
    }

    @Override
    public boolean isReadOnlyAttribute(String attributeName) {
        return !"type".equals(attributeName) && super.isReadOnlyAttribute(attributeName);
    }

    @Override
    public void validate(@NotNull XmlTag context, @NotNull Validator.ValidationHost host) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxRootTagDescriptor", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/javaFX/fxml/descriptors/JavaFxRootTagDescriptor", "validate"));
        }
        super.validate(context, host);
        if (context.getParentTag() != null) {
            host.addMessage(context.getNavigationElement(), "<fx:root> is valid only as the root node of an FXML document", Validator.ValidationHost.ErrorType.ERROR);
        }
    }

    public String toString() {
        PsiClass psiClass = this.getPsiClass();
        return "<" + this.getName() + " -> " + (psiClass != null ? psiClass.getName() : this.myXmlTag.getAttributeValue("type") + "?") + ">";
    }

    @Override
    public PsiElement getDeclaration() {
        PsiClass psiClass = this.getPsiClass();
        return psiClass != null ? psiClass : this.myXmlTag;
    }

    public static class RootTagTypeAttributeDescriptor
    extends JavaFxPropertyAttributeDescriptor {
        public RootTagTypeAttributeDescriptor() {
            super("type", null);
        }

        @Override
        public boolean hasIdType() {
            return false;
        }

        @Override
        public boolean isEnumerated() {
            return false;
        }

        @Override
        public boolean isRequired() {
            return true;
        }

        @Override
        protected PsiClass getEnum() {
            return null;
        }

        @Override
        protected boolean isConstant(PsiField field) {
            return false;
        }

        @Override
        @Nullable
        public String validateValue(XmlElement context, String value) {
            PsiReference[] references = context.getReferences();
            if (references.length == 0 || references[references.length - 1].resolve() == null) {
                return "Cannot resolve class " + value;
            }
            return null;
        }

        @Override
        public String toString() {
            return "fx:root#" + this.getName();
        }
    }
}

